/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.DeleteDecisionRuleCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteDecisionRuleCommandTest {
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private Command canvasOperation;
    private DecisionTable dtable;
    private DecisionRule rule;
    private GridData uiModel;
    private GridRow uiModelRow;
    private DeleteDecisionRuleCommand command;

    @Before
    public void setup() {
        this.dtable = new DecisionTable();
        this.rule = new DecisionRule();
        this.dtable.getRule().add(this.rule);
        this.uiModel = new DMNGridData();
        this.uiModelRow = new BaseGridRow();
        this.uiModel.appendRow(this.uiModelRow);
    }

    private void makeCommand(int index) {
        this.command = (DeleteDecisionRuleCommand)Mockito.spy((Object)new DeleteDecisionRuleCommand(this.dtable, this.uiModel, index, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandCheck() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandExecute() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)0L, (long)this.dtable.getRule().size());
    }

    @Test
    public void testGraphCommandExecuteRemoveFromMiddle() throws Exception {
        DecisionRule firstRule = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule lastRule = (DecisionRule)Mockito.mock(DecisionRule.class);
        this.dtable.getRule().add(0, firstRule);
        this.dtable.getRule().add(lastRule);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.makeCommand(1);
        Assert.assertEquals((long)3L, (long)this.dtable.getRule().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)2L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)firstRule, this.dtable.getRule().get(0));
        Assert.assertEquals((Object)lastRule, this.dtable.getRule().get(1));
    }

    @Test
    public void testGraphCommandExecuteAndThenUndo() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        Assert.assertEquals((long)0L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)this.rule, this.dtable.getRule().get(0));
    }

    @Test
    public void testCanvasCommandAllow() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testCanvasCommandExecute() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command canvasAddRuleCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.execute((Object)this.canvasHandler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
        ((DeleteDecisionRuleCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteDecisionRuleCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testCanvasCommandExecuteAndThenUndo() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command canvasAddRuleCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.execute((Object)this.canvasHandler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        Mockito.reset((Object[])new Object[]{this.canvasOperation, this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.undo((Object)this.canvasHandler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, (Object)this.uiModel.getRow(0));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
        ((DeleteDecisionRuleCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteDecisionRuleCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }
}

