/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.DeleteRuleAnnotationClauseCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DeleteRuleAnnotationClauseCommandTest {
    @Mock
    private DecisionTable decisionTable;

    @Test
    public void testExtractColumnData() {
        DeleteRuleAnnotationClauseCommand command = (DeleteRuleAnnotationClauseCommand)Mockito.mock(DeleteRuleAnnotationClauseCommand.class);
        ((DeleteRuleAnnotationClauseCommand)Mockito.doCallRealMethod().when((Object)command)).extractColumnData();
        int clauseIndex = 2;
        DecisionRule rule1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule rule2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List<DecisionRule> rules = Arrays.asList(rule1, rule2);
        List rule1AnnotationEntry = (List)Mockito.mock(List.class);
        List rule2AnnotationEntry = (List)Mockito.mock(List.class);
        RuleAnnotationClauseText text1 = (RuleAnnotationClauseText)Mockito.mock(RuleAnnotationClauseText.class);
        RuleAnnotationClauseText text2 = (RuleAnnotationClauseText)Mockito.mock(RuleAnnotationClauseText.class);
        Mockito.when((Object)command.getDecisionTable()).thenReturn((Object)this.decisionTable);
        Mockito.when((Object)command.getRuleAnnotationClauseIndex()).thenReturn((Object)2);
        Mockito.when(rule1AnnotationEntry.get(2)).thenReturn((Object)text1);
        Mockito.when(rule2AnnotationEntry.get(2)).thenReturn((Object)text2);
        Mockito.when((Object)rule1.getAnnotationEntry()).thenReturn((Object)rule1AnnotationEntry);
        Mockito.when((Object)rule2.getAnnotationEntry()).thenReturn((Object)rule2AnnotationEntry);
        Mockito.when((Object)this.decisionTable.getRule()).thenReturn(rules);
        List columnData = command.extractColumnData();
        Assert.assertEquals((long)2L, (long)columnData.size());
        Assert.assertTrue((boolean)columnData.contains(text1));
        Assert.assertTrue((boolean)columnData.contains(text2));
    }

    @Test
    public void testGetRuleAnnotationClauseIndex() {
        int columnIndex = 15;
        int inputSize = 2;
        int outputSize = 5;
        List input = (List)Mockito.mock(List.class);
        List output = (List)Mockito.mock(List.class);
        DeleteRuleAnnotationClauseCommand deleteCommand = (DeleteRuleAnnotationClauseCommand)Mockito.mock(DeleteRuleAnnotationClauseCommand.class);
        ((DeleteRuleAnnotationClauseCommand)Mockito.doCallRealMethod().when((Object)deleteCommand)).getRuleAnnotationClauseIndex();
        Mockito.when((Object)deleteCommand.getDecisionTable()).thenReturn((Object)this.decisionTable);
        Mockito.when((Object)deleteCommand.getUiColumnIndex()).thenReturn((Object)15);
        Mockito.when((Object)input.size()).thenReturn((Object)2);
        Mockito.when((Object)output.size()).thenReturn((Object)5);
        Mockito.when((Object)this.decisionTable.getInput()).thenReturn((Object)input);
        Mockito.when((Object)this.decisionTable.getOutput()).thenReturn((Object)output);
        int expected = 7;
        int actual = deleteCommand.getRuleAnnotationClauseIndex();
        Assert.assertEquals((long)7L, (long)actual);
    }

    @Test
    public void testNewGraphCommandExecute() {
        int uiColumnIndex = 3;
        int annotationClauseIndex = 2;
        AbstractCanvasHandler handler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        DeleteRuleAnnotationClauseCommand command = (DeleteRuleAnnotationClauseCommand)Mockito.mock(DeleteRuleAnnotationClauseCommand.class);
        DecisionRule rule1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule rule2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List<DecisionRule> rules = Arrays.asList(rule1, rule2);
        List rule1AnnotationEntries = (List)Mockito.mock(List.class);
        List rule2AnnotationEntries = (List)Mockito.mock(List.class);
        List annotations = (List)Mockito.mock(List.class);
        List widths = (List)Mockito.mock(List.class);
        GraphCommandExecutionContext context = (GraphCommandExecutionContext)Mockito.mock(GraphCommandExecutionContext.class);
        ((DeleteRuleAnnotationClauseCommand)Mockito.doCallRealMethod().when((Object)command)).newGraphCommand(handler);
        Mockito.when((Object)command.getDecisionTable()).thenReturn((Object)this.decisionTable);
        Mockito.when((Object)command.getRuleAnnotationClauseIndex()).thenReturn((Object)2);
        Mockito.when((Object)command.getUiColumnIndex()).thenReturn((Object)3);
        Mockito.when((Object)rule1.getAnnotationEntry()).thenReturn((Object)rule1AnnotationEntries);
        Mockito.when((Object)rule2.getAnnotationEntry()).thenReturn((Object)rule2AnnotationEntries);
        Mockito.when((Object)this.decisionTable.getRule()).thenReturn(rules);
        Mockito.when((Object)this.decisionTable.getAnnotations()).thenReturn((Object)annotations);
        Mockito.when((Object)this.decisionTable.getComponentWidths()).thenReturn((Object)widths);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = command.newGraphCommand(handler);
        CommandResult result = graphCommand.execute((Object)context);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)result);
        ((List)Mockito.verify((Object)widths)).remove(3);
        ((List)Mockito.verify((Object)rule1AnnotationEntries)).remove(2);
        ((List)Mockito.verify((Object)rule2AnnotationEntries)).remove(2);
        ((List)Mockito.verify((Object)annotations)).remove(2);
    }

    @Test
    public void testNewGraphCommandUndo() {
        int uiColumnIndex = 3;
        int annotationClauseIndex = 2;
        AbstractCanvasHandler handler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        DeleteRuleAnnotationClauseCommand command = (DeleteRuleAnnotationClauseCommand)Mockito.mock(DeleteRuleAnnotationClauseCommand.class);
        DecisionRule rule1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule rule2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List<DecisionRule> rules = Arrays.asList(rule1, rule2);
        List rule1AnnotationEntries = (List)Mockito.mock(List.class);
        List rule2AnnotationEntries = (List)Mockito.mock(List.class);
        List annotations = (List)Mockito.mock(List.class);
        List widths = (List)Mockito.mock(List.class);
        GraphCommandExecutionContext context = (GraphCommandExecutionContext)Mockito.mock(GraphCommandExecutionContext.class);
        RuleAnnotationClause oldRuleClause = (RuleAnnotationClause)Mockito.mock(RuleAnnotationClause.class);
        GridColumn oldUiModelColumn = (GridColumn)Mockito.mock(GridColumn.class);
        double oldUiModelColumnWidth = 123.4;
        RuleAnnotationClauseText deleted1 = (RuleAnnotationClauseText)Mockito.mock(RuleAnnotationClauseText.class);
        RuleAnnotationClauseText deleted2 = (RuleAnnotationClauseText)Mockito.mock(RuleAnnotationClauseText.class);
        List<RuleAnnotationClauseText> oldCommandData = Arrays.asList(deleted1, deleted2);
        ((DeleteRuleAnnotationClauseCommand)Mockito.doCallRealMethod().when((Object)command)).newGraphCommand(handler);
        Mockito.when((Object)command.getOldColumnData()).thenReturn(oldCommandData);
        Mockito.when((Object)command.getOldRuleClause()).thenReturn((Object)oldRuleClause);
        Mockito.when((Object)oldUiModelColumn.getWidth()).thenReturn((Object)123.4);
        Mockito.when((Object)command.getOldUiModelColumn()).thenReturn((Object)oldUiModelColumn);
        Mockito.when((Object)command.getDecisionTable()).thenReturn((Object)this.decisionTable);
        Mockito.when((Object)command.getRuleAnnotationClauseIndex()).thenReturn((Object)2);
        Mockito.when((Object)command.getUiColumnIndex()).thenReturn((Object)3);
        Mockito.when((Object)rule1.getAnnotationEntry()).thenReturn((Object)rule1AnnotationEntries);
        Mockito.when((Object)rule2.getAnnotationEntry()).thenReturn((Object)rule2AnnotationEntries);
        Mockito.when((Object)this.decisionTable.getRule()).thenReturn(rules);
        Mockito.when((Object)this.decisionTable.getAnnotations()).thenReturn((Object)annotations);
        Mockito.when((Object)this.decisionTable.getComponentWidths()).thenReturn((Object)widths);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = command.newGraphCommand(handler);
        CommandResult result = graphCommand.undo((Object)context);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)result);
        ((List)Mockito.verify((Object)annotations)).add(2, oldRuleClause);
        ((List)Mockito.verify((Object)rule1AnnotationEntries)).add(2, deleted1);
        ((List)Mockito.verify((Object)rule2AnnotationEntries)).add(2, deleted2);
    }

    @Test
    public void testNewCanvasCommandExecute() {
        DeleteRuleAnnotationClauseCommand command = (DeleteRuleAnnotationClauseCommand)Mockito.mock(DeleteRuleAnnotationClauseCommand.class);
        AbstractCanvasHandler handler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        int uiColumnIndex = 7;
        List columns = (List)Mockito.mock(List.class);
        GridData uiModel = (GridData)Mockito.mock(GridData.class);
        Command executeCanvasOperation = (Command)Mockito.mock(Command.class);
        GridColumn gridColumn = (GridColumn)Mockito.mock(GridColumn.class);
        ((DeleteRuleAnnotationClauseCommand)Mockito.doCallRealMethod().when((Object)command)).newCanvasCommand(handler);
        Mockito.when((Object)command.getUiModel()).thenReturn((Object)uiModel);
        Mockito.when((Object)uiModel.getColumns()).thenReturn((Object)columns);
        Mockito.when((Object)command.getUiColumnIndex()).thenReturn((Object)7);
        Mockito.when((Object)command.getExecuteCanvasOperation()).thenReturn((Object)executeCanvasOperation);
        Mockito.when(columns.get(7)).thenReturn((Object)gridColumn);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = command.newCanvasCommand(handler);
        CommandResult result = canvasCommand.execute((Object)handler);
        ((GridData)Mockito.verify((Object)uiModel)).deleteColumn(gridColumn);
        ((DeleteRuleAnnotationClauseCommand)Mockito.verify((Object)command)).updateParentInformation();
        ((Command)Mockito.verify((Object)executeCanvasOperation)).execute();
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)result);
    }

    @Test
    public void testNewCanvasCommandUndo() {
        DeleteRuleAnnotationClauseCommand command = (DeleteRuleAnnotationClauseCommand)Mockito.mock(DeleteRuleAnnotationClauseCommand.class);
        AbstractCanvasHandler handler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        GridData uiModel = (GridData)Mockito.mock(GridData.class);
        GridColumn oldUiModelColumn = (GridColumn)Mockito.mock(GridColumn.class);
        int uiColumnIndex = 3;
        DecisionRule rule1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule rule2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List<DecisionRule> rules = Arrays.asList(rule1, rule2);
        Command undoCanvasOperation = (Command)Mockito.mock(Command.class);
        DecisionTableUIModelMapper uiModelMapper = (DecisionTableUIModelMapper)Mockito.mock(DecisionTableUIModelMapper.class);
        ((DeleteRuleAnnotationClauseCommand)Mockito.doCallRealMethod().when((Object)command)).newCanvasCommand(handler);
        Mockito.when((Object)command.getUiModel()).thenReturn((Object)uiModel);
        Mockito.when((Object)command.getUiColumnIndex()).thenReturn((Object)3);
        Mockito.when((Object)command.getOldUiModelColumn()).thenReturn((Object)oldUiModelColumn);
        Mockito.when((Object)command.getDecisionTable()).thenReturn((Object)this.decisionTable);
        Mockito.when((Object)this.decisionTable.getRule()).thenReturn(rules);
        Mockito.when((Object)command.getUiModelMapper()).thenReturn((Object)uiModelMapper);
        Mockito.when((Object)command.getUndoCanvasOperation()).thenReturn((Object)undoCanvasOperation);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = command.newCanvasCommand(handler);
        CommandResult result = canvasCommand.undo((Object)handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)result);
        ((DecisionTableUIModelMapper)Mockito.verify((Object)uiModelMapper)).fromDMNModel(0, 3);
        ((DecisionTableUIModelMapper)Mockito.verify((Object)uiModelMapper)).fromDMNModel(1, 3);
        ((DeleteRuleAnnotationClauseCommand)Mockito.verify((Object)command)).updateParentInformation();
        ((Command)Mockito.verify((Object)undoCanvasOperation)).execute();
    }
}

