/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.MoveRowsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableRowNumberColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class MoveRowsCommandTest {
    @Mock
    private DecisionTableRowNumberColumn uiRowNumberColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumn;
    @Mock
    private OutputClauseColumn uiOutputClauseColumn;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    private DecisionTable dtable;
    @Mock
    private InputClause inputClause;
    @Mock
    private OutputClause outputClause;
    private DMNGridData uiModel;
    private MoveRowsCommand command;
    private org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> graphCommand;
    private org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> canvasCommand;
    @Mock
    private Command canvasOperation;
    private List<GridRow> rowsUnderTest = new ArrayList<GridRow>();

    @Before
    public void setUp() throws Exception {
        this.dtable = new DecisionTable();
        this.uiModel = new DMNGridData();
        this.dtable.getInput().add(this.inputClause);
        this.dtable.getOutput().add(this.outputClause);
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumn);
        ((DecisionTableRowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumn)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)2).when((Object)this.uiOutputClauseColumn)).getIndex();
        this.rowsUnderTest.clear();
        this.appendRow(0, "a");
        this.appendRow(1, "b");
        this.appendRow(2, "c");
    }

    @Test
    public void moveSingleRowUp() throws Exception {
        this.moveRowsToPositionCommand(Collections.singletonList(this.rowsUnderTest.get(2)), 0);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
        this.canvasCommand.execute((Object)this.canvasHandler);
        this.assertRow(0, "in c", "out c");
        this.assertRow(1, "in a", "out a");
        this.assertRow(2, "in b", "out b");
    }

    @Test
    public void moveSingleRowDown() throws Exception {
        this.moveRowsToPositionCommand(Collections.singletonList(this.rowsUnderTest.get(0)), 2);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
        this.canvasCommand.execute((Object)this.canvasHandler);
        this.assertRow(0, "in b", "out b");
        this.assertRow(1, "in c", "out c");
        this.assertRow(2, "in a", "out a");
    }

    @Test
    public void moveMultipleRowsUp() throws Exception {
        this.moveRowsToPositionCommand(this.rowsUnderTest.subList(1, 3), 0);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
        this.canvasCommand.execute((Object)this.canvasHandler);
        this.assertRow(0, "in b", "out b");
        this.assertRow(1, "in c", "out c");
        this.assertRow(2, "in a", "out a");
    }

    @Test
    public void moveMultipleRowsDown() throws Exception {
        this.moveRowsToPositionCommand(this.rowsUnderTest.subList(0, 2), 2);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
        this.canvasCommand.execute((Object)this.canvasHandler);
        this.assertRow(0, "in c", "out c");
        this.assertRow(1, "in a", "out a");
        this.assertRow(2, "in b", "out b");
    }

    private void appendRow(int rowIndex, String rowIdentifier) {
        final String inValue = "in " + rowIdentifier;
        final String outValue = "out " + rowIdentifier;
        this.dtable.getRule().add(new DecisionRule(){
            {
                this.getInputEntry().add(new UnaryTests(){
                    {
                        this.getText().setValue(inValue);
                    }
                });
                this.getOutputEntry().add(new LiteralExpression(){
                    {
                        this.getText().setValue(outValue);
                    }
                });
            }
        });
        BaseGridRow uiRow = new BaseGridRow();
        this.uiModel.appendRow((GridRow)uiRow);
        this.uiModel.setCellValue(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1)));
        this.uiModel.setCellValue(rowIndex, 1, (GridCellValue)new BaseGridCellValue((Object)inValue));
        this.uiModel.setCellValue(rowIndex, 2, (GridCellValue)new BaseGridCellValue((Object)outValue));
        this.rowsUnderTest.add((GridRow)uiRow);
    }

    private void moveRowsToPositionCommand(List<GridRow> rows, int position) {
        this.command = new MoveRowsCommand(this.dtable, this.uiModel, position, rows, this.canvasOperation);
        this.graphCommand = this.command.newGraphCommand(this.canvasHandler);
        this.canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
    }

    private void assertRow(int rowIndex, String inValue, String outValue) {
        this.assertTableModelRow(rowIndex, inValue, outValue);
        this.assertUiModelRow(rowIndex, inValue, outValue);
    }

    private void assertTableModelRow(int rowIndex, String inValue, String outValue) {
        Assert.assertEquals((Object)inValue, (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(rowIndex)).getInputEntry().get(0)).getText().getValue());
        Assert.assertEquals((Object)outValue, (Object)((LiteralExpression)((DecisionRule)this.dtable.getRule().get(rowIndex)).getOutputEntry().get(0)).getText().getValue());
    }

    private void assertUiModelRow(int rowIndex, String inValue, String outValue) {
        Assert.assertEquals((Object)(rowIndex + 1), (Object)this.uiModel.getCell(rowIndex, 0).getValue().getValue());
        Assert.assertEquals((Object)inValue, (Object)this.uiModel.getCell(rowIndex, 1).getValue().getValue());
        Assert.assertEquals((Object)outValue, (Object)this.uiModel.getCell(rowIndex, 2).getValue().getValue());
    }
}

