/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.canvas;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.factory.canvas.DMNDeleteCanvasNodeCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNGraphsProvider;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDeleteCanvasNodeCommandTest {
    @Mock
    private Node candidate;
    @Mock
    private DMNGraphsProvider graphsProvide;
    private DMNDeleteCanvasNodeCommand command;

    @Before
    public void setup() {
        this.command = (DMNDeleteCanvasNodeCommand)Mockito.spy((Object)new DMNDeleteCanvasNodeCommand(this.candidate, this.graphsProvide));
    }

    @Test
    public void testCreateUndoCommandWhenBelongsToCurrentGraph() {
        AbstractCanvasCommand superCanvasCommand = (AbstractCanvasCommand)Mockito.mock(AbstractCanvasCommand.class);
        Node parent = (Node)Mockito.mock(Node.class);
        String ssid = "ssid";
        ((DMNDeleteCanvasNodeCommand)Mockito.doReturn((Object)true).when((Object)this.command)).belongsToCurrentGraph(this.candidate);
        ((DMNDeleteCanvasNodeCommand)Mockito.doReturn((Object)superCanvasCommand).when((Object)this.command)).superCreateUndoCommand(parent, this.candidate, "ssid");
        AbstractCanvasCommand actualUndoCommand = this.command.createUndoCommand(parent, this.candidate, "ssid");
        Assert.assertEquals((Object)superCanvasCommand, (Object)actualUndoCommand);
        ((DMNDeleteCanvasNodeCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.never())).createEmptyCommand();
    }

    @Test
    public void testCreateUndoCommandWhenDoesNotBelongsToCurrentGraph() {
        Node parent = (Node)Mockito.mock(Node.class);
        String ssid = "ssid";
        ((DMNDeleteCanvasNodeCommand)Mockito.doReturn((Object)false).when((Object)this.command)).belongsToCurrentGraph(this.candidate);
        AbstractCanvasCommand emptyCommand = (AbstractCanvasCommand)Mockito.mock(AbstractCanvasCommand.class);
        ((DMNDeleteCanvasNodeCommand)Mockito.doReturn((Object)emptyCommand).when((Object)this.command)).createEmptyCommand();
        AbstractCanvasCommand actualUndoCommand = this.command.createUndoCommand(parent, this.candidate, "ssid");
        Assert.assertEquals((Object)emptyCommand, (Object)actualUndoCommand);
        ((DMNDeleteCanvasNodeCommand)Mockito.verify((Object)this.command)).createEmptyCommand();
        ((DMNDeleteCanvasNodeCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.never())).superCreateUndoCommand(parent, this.candidate, "ssid");
    }

    @Test
    public void testEmptyCommand() {
        AbstractCanvasCommand emptyCommand = this.command.createEmptyCommand();
        AbstractCanvasHandler handler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)emptyCommand.execute((Object)handler));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)emptyCommand.undo((Object)handler));
    }
}

