/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.graph;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.commands.factory.graph.RegisterNodeCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommandTest;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class RegisterNodeCommandTest
extends AbstractGraphCommandTest {
    @Mock
    private Node candidate;
    @Mock
    private View candidateContent;
    private Decision decision = (Decision)Mockito.spy((Object)new Decision());
    private BusinessKnowledgeModel businessKnowledgeModel = (BusinessKnowledgeModel)Mockito.spy((Object)new BusinessKnowledgeModel());
    private RegisterNodeCommand command;

    @Before
    public void setup() {
        this.init();
        Mockito.when((Object)this.candidate.getContent()).thenReturn((Object)this.candidateContent);
        this.command = new RegisterNodeCommand(this.candidate);
    }

    @Test
    public void testExecuteWithBusinessKnowledgeModelNode() {
        Mockito.when((Object)this.candidateContent.getDefinition()).thenReturn((Object)this.businessKnowledgeModel);
        Assertions.assertThat((Comparable)this.command.execute(this.graphCommandExecutionContext).getType()).isEqualTo((Object)CommandResult.Type.INFO);
        FunctionDefinition encapsulatedLogic = this.businessKnowledgeModel.getEncapsulatedLogic();
        Expression expression = encapsulatedLogic.getExpression();
        Assertions.assertThat((Object)expression).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((Object)expression.getParent()).isEqualTo((Object)encapsulatedLogic);
        Assertions.assertThat((Comparable)KindUtilities.getKind((FunctionDefinition)encapsulatedLogic)).isEqualTo((Object)FunctionDefinition.Kind.FEEL);
    }

    @Test
    public void testExecuteWithBusinessKnowledgeModelNodeWhenNodeIsNotNew() {
        FunctionDefinition functionDefinition = new FunctionDefinition();
        LiteralExpression literalExpression = this.makeLiteralExpression("123");
        Mockito.when((Object)this.candidateContent.getDefinition()).thenReturn((Object)this.businessKnowledgeModel);
        ((BusinessKnowledgeModel)Mockito.doReturn((Object)functionDefinition).when((Object)this.businessKnowledgeModel)).getEncapsulatedLogic();
        functionDefinition.setExpression((Expression)literalExpression);
        literalExpression.setParent((DMNModelInstrumentedBase)functionDefinition);
        Assertions.assertThat((Comparable)this.command.execute(this.graphCommandExecutionContext).getType()).isEqualTo((Object)CommandResult.Type.INFO);
        FunctionDefinition encapsulatedLogic = this.businessKnowledgeModel.getEncapsulatedLogic();
        Expression expression = encapsulatedLogic.getExpression();
        Assertions.assertThat((Object)expression).isEqualTo((Object)this.makeLiteralExpression("123"));
        Assertions.assertThat((Object)expression.getParent()).isEqualTo((Object)encapsulatedLogic);
        Assertions.assertThat((Comparable)KindUtilities.getKind((FunctionDefinition)encapsulatedLogic)).isEqualTo((Object)FunctionDefinition.Kind.FEEL);
    }

    private LiteralExpression makeLiteralExpression(String text) {
        LiteralExpression expression = new LiteralExpression();
        expression.setId(new Id("0"));
        expression.setText(new Text(text));
        return expression;
    }

    @Test
    public void testExecuteWithNonBusinessKnowledgeModelNode() {
        Mockito.when((Object)this.candidateContent.getDefinition()).thenReturn((Object)this.decision);
        Assertions.assertThat((Comparable)this.command.execute(this.graphCommandExecutionContext).getType()).isEqualTo((Object)CommandResult.Type.INFO);
    }
}

