/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.util.ContentDefinitionIdUtils;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ContentDefinitionIdUtilsTest {
    @Test
    public void testNodeBelongsToCurrentGraph() {
        String currentDiagramId = "currentDiagramId";
        Node node = this.createNode("currentDiagramId");
        GraphsProvider graphsProvider = this.createGraphsProvider("currentDiagramId");
        Assert.assertTrue((boolean)ContentDefinitionIdUtils.belongsToCurrentGraph((Node)node, (GraphsProvider)graphsProvider));
    }

    @Test
    public void testNodeBelongsToCurrentGraphWhenDoesNot() {
        String nodeDiagramId = "nodeDiagramId";
        String currentDiagramId = "currentDiagramId";
        Node node = this.createNode("nodeDiagramId");
        GraphsProvider graphsProvider = this.createGraphsProvider("currentDiagramId");
        Assert.assertFalse((boolean)ContentDefinitionIdUtils.belongsToCurrentGraph((Node)node, (GraphsProvider)graphsProvider));
    }

    @Test
    public void testEdgeBelongsToCurrentGraph() {
        String currentDiagramId = "currentDiagramId";
        Node node = this.createNode("currentDiagramId");
        Edge edge = this.createEdge(node, null);
        GraphsProvider graphsProvider = this.createGraphsProvider("currentDiagramId");
        Assert.assertTrue((boolean)ContentDefinitionIdUtils.belongsToCurrentGraph((Edge)edge, (GraphsProvider)graphsProvider));
    }

    @Test
    public void testEdgeBelongsToCurrentGraphWhenDoesNot() {
        String nodeDiagramId = "nodeDiagramId";
        String currentDiagramId = "currentDiagramId";
        Node node = this.createNode("nodeDiagramId");
        Edge edge = this.createEdge(node, null);
        GraphsProvider graphsProvider = this.createGraphsProvider("currentDiagramId");
        Assert.assertFalse((boolean)ContentDefinitionIdUtils.belongsToCurrentGraph((Edge)edge, (GraphsProvider)graphsProvider));
    }

    @Test
    public void testGetDiagramIdFromEdge() {
        String targetNodeDiagramId = "targetNodeId";
        String sourceNodeDiagramId = "sourceNodeId";
        Node target = this.createNode("targetNodeId");
        Node source = this.createNode("sourceNodeId");
        Edge edge = this.createEdge(source, target);
        Optional actualId = ContentDefinitionIdUtils.getDiagramId((Edge)edge);
        Assert.assertTrue((boolean)actualId.isPresent());
        Assert.assertEquals((Object)"sourceNodeId", actualId.get());
    }

    @Test
    public void testGetDiagramIdFromEdgeSourceNode() {
        String sourceNodeDiagramId = "diagram id";
        Node source = this.createNode("diagram id");
        Edge edge = this.createEdge(source, null);
        Optional actualId = ContentDefinitionIdUtils.getDiagramId((Edge)edge);
        Assert.assertTrue((boolean)actualId.isPresent());
        Assert.assertEquals((Object)"diagram id", actualId.get());
    }

    @Test
    public void testGetDiagramIdFromEdgeTargetNode() {
        String targetNodeDiagramId = "diagram id";
        Node target = this.createNode("diagram id");
        Edge edge = this.createEdge(null, target);
        Optional actualId = ContentDefinitionIdUtils.getDiagramId((Edge)edge);
        Assert.assertTrue((boolean)actualId.isPresent());
        Assert.assertEquals((Object)"diagram id", actualId.get());
    }

    @Test
    public void testGetDiagramIdFromNode() {
        String diagramId = "diagram Id";
        Node node = this.createNode("diagram Id");
        Optional actual = ContentDefinitionIdUtils.getDiagramId((Node)node);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)"diagram Id", actual.get());
    }

    @Test
    public void testGetDiagramIdFromNodeWhenNodeIsNull() {
        Optional diagramId = ContentDefinitionIdUtils.getDiagramId((Node)null);
        Assert.assertFalse((boolean)diagramId.isPresent());
        Assert.assertNotNull((Object)diagramId);
    }

    private Edge createEdge(Node sourceNode, Node targetNode) {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Mockito.when((Object)edge.getTargetNode()).thenReturn((Object)targetNode);
        return edge;
    }

    private Node createNode(String diagramId) {
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        HasContentDefinitionId hasContentDefinitionId = (HasContentDefinitionId)Mockito.mock(HasContentDefinitionId.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)hasContentDefinitionId.getDiagramId()).thenReturn((Object)diagramId);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)hasContentDefinitionId);
        return node;
    }

    private GraphsProvider createGraphsProvider(String currentDiagramId) {
        GraphsProvider graphsProvider = (GraphsProvider)Mockito.mock(GraphsProvider.class);
        Mockito.when((Object)graphsProvider.getCurrentDiagramId()).thenReturn((Object)currentDiagramId);
        return graphsProvider;
    }
}

