/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemBuilder;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorObserver;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorObserverTest {
    @Mock
    private DecisionNavigatorPresenter presenter;
    @Mock
    private DecisionNavigatorTreePresenter treePresenter;
    @Mock
    private Canvas canvas;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private ClientSession clientSession;
    @Mock
    private HasName hasName;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private Element<?> element;
    private String uuid;
    private DecisionNavigatorObserver observer;

    @Before
    public void setup() {
        Mockito.when((Object)this.presenter.getTreePresenter()).thenReturn((Object)this.treePresenter);
        this.observer = (DecisionNavigatorObserver)Mockito.spy((Object)new DecisionNavigatorObserver());
        this.uuid = "uuid";
    }

    @Test
    public void testOnCanvasClearWhenPresenterIsPresent() {
        this.observer.init(this.presenter);
        this.observer.onCanvasClear(new CanvasClearEvent(this.canvas));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testOnCanvasElementAdded() {
        this.observer.init(this.presenter);
        this.observer.onCanvasElementAdded(new CanvasElementAddedEvent(this.canvasHandler, this.element));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testOnCanvasElementUpdated() {
        this.observer.init(this.presenter);
        this.observer.onCanvasElementUpdated(new CanvasElementUpdatedEvent(this.canvasHandler, this.element));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testOnCanvasElementRemoved() {
        this.observer.init(this.presenter);
        this.observer.onCanvasElementRemoved(new CanvasElementRemovedEvent(this.canvasHandler, this.element));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testOnNestedElementSelected() {
        this.observer.init(this.presenter);
        this.observer.onNestedElementSelected(new EditExpressionEvent(this.clientSession, this.uuid, this.hasExpression, Optional.of(this.hasName), false));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testOnNestedElementAdded() {
        this.observer.init(this.presenter);
        this.observer.onNestedElementAdded(new ExpressionEditorChanged(this.uuid));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testOnDMNDiagramSelected() {
        this.observer.init(this.presenter);
        this.observer.onDMNDiagramSelected(new DMNDiagramSelected(null));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testSelectItemWhenExpressionIsNotNull() {
        EditExpressionEvent event = this.makeEditExpressionEvent();
        Expression expression = (Expression)Mockito.mock(Expression.class);
        Id id = (Id)Mockito.mock(Id.class);
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)expression);
        Mockito.when((Object)expression.getId()).thenReturn((Object)id);
        Mockito.when((Object)id.getValue()).thenReturn((Object)this.uuid);
        this.observer.init(this.presenter);
        this.observer.selectItem(event.getHasExpression());
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).selectItem(this.uuid);
    }

    @Test
    public void testSelectItemWhenExpressionIsNull() {
        EditExpressionEvent event = this.makeEditExpressionEvent();
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn(null);
        this.observer.init(this.presenter);
        this.observer.selectItem(event.getHasExpression());
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter, (VerificationMode)Mockito.never())).selectItem((String)Mockito.any());
    }

    @Test
    public void testSetActiveParent() {
        EditExpressionEvent event = this.makeEditExpressionEvent();
        this.observer.init(this.presenter);
        this.observer.setActiveParent(event);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).setActiveParentUUID(this.uuid);
    }

    @Test
    public void testGetActiveParent() {
        DecisionNavigatorItem expectedItem = this.makeItem(this.uuid, new DecisionNavigatorItem[0]);
        Mockito.when((Object)this.treePresenter.getActiveParent()).thenReturn((Object)expectedItem);
        this.observer.init(this.presenter);
        DecisionNavigatorItem actualItem = (DecisionNavigatorItem)this.observer.getActiveParent().get();
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    private DecisionNavigatorItem makeItem(String uuid, DecisionNavigatorItem ... items) {
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID(uuid).build();
        item.getChildren().addAll(Arrays.asList(items));
        return item;
    }

    private EditExpressionEvent makeEditExpressionEvent() {
        Optional<HasName> optionalName = Optional.of(this.hasName);
        return new EditExpressionEvent(this.clientSession, this.uuid, this.hasExpression, optionalName, false);
    }
}

