/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DomGlobal;
import java.util.ArrayList;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemsProvider;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorObserver;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsContext;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorPresenterTest {
    @Mock
    private DecisionNavigatorPresenter.View view;
    @Mock
    private DecisionNavigatorTreePresenter treePresenter;
    @Mock
    private DecisionComponents decisionComponents;
    @Mock
    private DecisionNavigatorObserver decisionNavigatorObserver;
    @Mock
    private TranslationService translationService;
    @Mock
    private IncludedModelsContext includedModelContext;
    @Mock
    private DecisionNavigatorItemsProvider navigatorItemsProvider;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    private DecisionNavigatorPresenter presenter;

    @Before
    public void setup() {
        this.presenter = (DecisionNavigatorPresenter)Mockito.spy((Object)new DecisionNavigatorPresenter(this.view, this.treePresenter, this.decisionComponents, this.decisionNavigatorObserver, this.translationService, this.includedModelContext, this.navigatorItemsProvider, this.dmnDiagramsSession));
    }

    @Test
    public void testSetup() {
        this.presenter.setup();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).initialize();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).setupView();
    }

    @Test
    public void testInitialize() {
        this.presenter.initialize();
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((DecisionNavigatorObserver)Mockito.verify((Object)this.decisionNavigatorObserver)).init(this.presenter);
    }

    @Test
    public void testSetupViewWhenChannelIsVSCodeOrDefault() {
        DecisionNavigatorTreePresenter.View treeView = (DecisionNavigatorTreePresenter.View)Mockito.mock(DecisionNavigatorTreePresenter.View.class);
        DecisionComponents.View decisionComponentsView = (DecisionComponents.View)Mockito.mock(DecisionComponents.View.class);
        Mockito.when((Object)this.includedModelContext.isIncludedModelChannel()).thenReturn((Object)true);
        Mockito.when((Object)this.treePresenter.getView()).thenReturn((Object)treeView);
        Mockito.when((Object)this.decisionComponents.getView()).thenReturn((Object)decisionComponentsView);
        this.presenter.setupView();
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view)).setupMainTree(treeView);
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).showDecisionComponentsContainer();
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setupDecisionComponents(decisionComponentsView);
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideDecisionComponentsContainer();
    }

    @Test
    public void testSetupViewWhenChannelIsNotVSCodeOrDefault() {
        DecisionNavigatorTreePresenter.View treeView = (DecisionNavigatorTreePresenter.View)Mockito.mock(DecisionNavigatorTreePresenter.View.class);
        DecisionComponents.View decisionComponentsView = (DecisionComponents.View)Mockito.mock(DecisionComponents.View.class);
        Mockito.when((Object)this.includedModelContext.isIncludedModelChannel()).thenReturn((Object)false);
        Mockito.when((Object)this.treePresenter.getView()).thenReturn((Object)treeView);
        Mockito.when((Object)this.decisionComponents.getView()).thenReturn((Object)decisionComponentsView);
        this.presenter.setupView();
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view)).setupMainTree(treeView);
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showDecisionComponentsContainer();
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setupDecisionComponents(decisionComponentsView);
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).hideDecisionComponentsContainer();
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testGetTitle() {
        String expectedTitle = "Decision Navigator";
        Mockito.when((Object)this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0])).thenReturn((Object)"Decision Navigator");
        String actualTitle = this.presenter.getTitle();
        Assert.assertEquals((Object)"Decision Navigator", (Object)actualTitle);
    }

    @Test
    public void testGetDefaultPosition() {
        CompassPosition expected = CompassPosition.WEST;
        Position actual = this.presenter.getDefaultPosition();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetTreePresenter() {
        Assert.assertEquals((Object)this.treePresenter, (Object)this.presenter.getTreePresenter());
    }

    @Test
    public void testRefreshTreeView() {
        ArrayList items = new ArrayList();
        ((DecisionNavigatorPresenter)Mockito.doReturn(items).when((Object)this.presenter)).getItems();
        this.presenter.refreshTreeView();
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).setupItems(items);
    }

    @Test
    public void testRefresh() {
        ArgumentCaptor cmdCaptor = ArgumentCaptor.forClass(Command.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)true).when((Object)this.dmnDiagramsSession)).isSessionStatePresent();
        ((DecisionNavigatorPresenter)Mockito.doNothing().when((Object)this.presenter)).defer((Command)ArgumentMatchers.any());
        this.presenter.refresh();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).defer((Command)cmdCaptor.capture());
        ((Command)cmdCaptor.getValue()).execute();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refreshTreeView();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refreshComponentsView();
    }

    @Test
    public void testRefreshWhenSessionStateIsNotPresent() {
        ArgumentCaptor cmdCaptor = ArgumentCaptor.forClass(Command.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)false).when((Object)this.dmnDiagramsSession)).isSessionStatePresent();
        ((DecisionNavigatorPresenter)Mockito.doNothing().when((Object)this.presenter)).defer((Command)ArgumentMatchers.any());
        this.presenter.refresh();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).defer((Command)ArgumentMatchers.any());
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).refreshTreeView();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).refreshComponentsView();
    }

    @Test
    public void testRemoveAllElements() {
        this.presenter.removeAllElements();
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).removeAllItems();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).removeAllItems();
    }

    @Test
    public void testClearSelections() {
        this.presenter.clearSelections();
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).deselectItem();
    }

    @Test
    public void testOnRefreshDecisionComponents() {
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.times((int)2))).refresh();
    }

    @Test
    public void testOnRefreshDecisionComponents_WhenRefreshComponentsIsSuspended() {
        this.presenter.setIsRefreshComponentsViewSuspended(true);
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.never())).refresh();
    }

    @Test
    public void testOnRefreshDecisionComponents_WhenSuspendAndResume() {
        this.presenter.setIsRefreshComponentsViewSuspended(true);
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.never())).refresh();
        this.presenter.setIsRefreshComponentsViewSuspended(false);
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.times((int)2))).refresh();
    }

    @Test
    public void testDefer() {
        Command cmd = (Command)Mockito.mock(Command.class);
        ArgumentCaptor timeoutCaptor = ArgumentCaptor.forClass(DomGlobal.SetTimeoutCallbackFn.class);
        ((DecisionNavigatorPresenter)Mockito.doNothing().when((Object)this.presenter)).clearTimeout((double)ArgumentMatchers.anyInt());
        ((DecisionNavigatorPresenter)Mockito.doReturn((Object)0.0).when((Object)this.presenter)).setTimeout((DomGlobal.SetTimeoutCallbackFn)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        this.presenter.defer(cmd);
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).clearTimeout(0.0);
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).setTimeout((DomGlobal.SetTimeoutCallbackFn)timeoutCaptor.capture(), ArgumentMatchers.eq((int)250));
        ((DomGlobal.SetTimeoutCallbackFn)timeoutCaptor.getValue()).onInvoke(new Object[0]);
        ((Command)Mockito.verify((Object)cmd)).execute();
    }
}

