/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.drds;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.appformer.client.stateControl.registry.Registry;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSessionState;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDiagramsSessionTest {
    @Mock
    private ManagedInstance<DMNDiagramsSessionState> dmnDiagramsSessionStates;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private ClientSession clientSession;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Metadata metadata;
    @Mock
    private Path path;
    @Mock
    private Diagram diagram;
    @Mock
    private EventSourceMock locker;
    @Mock
    private EventSourceMock currentRegistryChangedEvent;
    private String uri = "://cyber/v.dmn";
    private Map<String, Diagram> diagramsByDiagramElementId = new HashMap<String, Diagram>();
    private Map<String, DMNDiagramElement> dmnDiagramsByDiagramElementId = new HashMap<String, DMNDiagramElement>();
    private DMNDiagramsSession dmnDiagramsSession;
    private DMNDiagramsSessionState dmnDiagramsSessionState;

    @Before
    public void setup() {
        this.dmnDiagramsSessionState = (DMNDiagramsSessionState)Mockito.spy((Object)new DMNDiagramsSessionState(this.dmnDiagramUtils));
        this.dmnDiagramsSession = (DMNDiagramsSession)Mockito.spy((Object)new DMNDiagramsSession(this.dmnDiagramsSessionStates, this.sessionManager, this.dmnDiagramUtils, (Event)this.locker, (Event)this.currentRegistryChangedEvent));
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.clientSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.clientSession);
        Mockito.when((Object)this.metadata.getPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)this.uri);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)((DMNDiagramsSessionState)this.dmnDiagramsSessionStates.get())).thenReturn((Object)this.dmnDiagramsSessionState);
        this.dmnDiagramsSession.setState(this.metadata, this.diagramsByDiagramElementId, this.dmnDiagramsByDiagramElementId);
    }

    @Test
    public void testDestroyState() {
        Assert.assertNotNull((Object)this.dmnDiagramsSession.getSessionState());
        this.dmnDiagramsSession.destroyState(this.metadata);
        Assert.assertNull((Object)this.dmnDiagramsSession.getSessionState());
    }

    @Test
    public void testGetCurrentSessionKey() {
        Assert.assertEquals((Object)this.uri, (Object)this.dmnDiagramsSession.getCurrentSessionKey());
    }

    @Test
    public void testAddAndRemove() {
        DMNDiagramElement dmnDiagram = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        String diagramId = "0000";
        Mockito.when((Object)dmnDiagram.getId()).thenReturn((Object)new Id("0000"));
        this.dmnDiagramsSession.add(dmnDiagram, stunnerDiagram);
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
        this.dmnDiagramsSession.remove(dmnDiagram);
        Assert.assertNull((Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
    }

    @Test
    public void testGetDMNDiagrams() {
        List<DMNDiagramTuple> expected = Arrays.asList((DMNDiagramTuple)Mockito.mock(DMNDiagramTuple.class), (DMNDiagramTuple)Mockito.mock(DMNDiagramTuple.class));
        ((DMNDiagramsSessionState)Mockito.doReturn(expected).when((Object)this.dmnDiagramsSessionState)).getDMNDiagrams();
        List actual = this.dmnDiagramsSession.getDMNDiagrams();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testSetCurrentDMNDiagramElement() {
        DMNDiagramElement diagramElement = new DMNDiagramElement(new Id(), new Name("DRG"));
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        ((DMNDiagramsSessionState)Mockito.verify((Object)this.dmnDiagramsSessionState)).setCurrentDMNDiagramElement(diagramElement);
    }

    @Test
    public void testGetCurrentDMNDiagramElement() {
        DMNDiagramElement diagramElement = new DMNDiagramElement();
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        Optional currentDMNDiagramElement = this.dmnDiagramsSession.getCurrentDMNDiagramElement();
        Assert.assertTrue((boolean)currentDMNDiagramElement.isPresent());
        Assert.assertEquals((Object)diagramElement, currentDMNDiagramElement.get());
    }

    @Test
    public void testGetCurrentDiagram() {
        DMNDiagramElement diagramElement = new DMNDiagramElement();
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        Optional currentDiagram = this.dmnDiagramsSession.getCurrentDiagram();
        Assert.assertTrue((boolean)currentDiagram.isPresent());
        Assert.assertEquals((Object)stunnerDiagram, currentDiagram.get());
    }

    @Test
    public void testGetDRGDiagram() {
        Diagram expected = (Diagram)Mockito.mock(Diagram.class);
        ((DMNDiagramsSessionState)Mockito.doReturn((Object)expected).when((Object)this.dmnDiagramsSessionState)).getDRGDiagram();
        Diagram actual = this.dmnDiagramsSession.getDRGDiagram();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDRGDiagramElement() {
        DMNDiagramElement expected = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        ((DMNDiagramsSessionState)Mockito.doReturn((Object)expected).when((Object)this.dmnDiagramsSessionState)).getDRGDiagramElement();
        DMNDiagramElement actual = this.dmnDiagramsSession.getDRGDiagramElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testClear() {
        DMNDiagramElement dmnDiagram = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        String diagramId = "0000";
        Mockito.when((Object)dmnDiagram.getId()).thenReturn((Object)new Id("0000"));
        this.dmnDiagramsSession.add(dmnDiagram, stunnerDiagram);
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
        this.dmnDiagramsSession.clear();
        Assert.assertNull((Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
    }

    @Test
    public void testGetModelDRGElements() {
        List<DRGElement> expected = Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class));
        ((DMNDiagramsSessionState)Mockito.doReturn(expected).when((Object)this.dmnDiagramsSessionState)).getModelDRGElements();
        List actual = this.dmnDiagramsSession.getModelDRGElements();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetModelImports() {
        List<Import> expected = Arrays.asList((Import)Mockito.mock(Import.class), (Import)Mockito.mock(Import.class));
        ((DMNDiagramsSessionState)Mockito.doReturn(expected).when((Object)this.dmnDiagramsSessionState)).getModelImports();
        List actual = this.dmnDiagramsSession.getModelImports();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testIsGlobalGraphWhenItReturnsTrue() {
        DMNDiagramElement diagramElement = new DMNDiagramElement(new Id(), new Name("DRG"));
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(new DMNDiagramSelected(diagramElement));
        Assert.assertTrue((boolean)this.dmnDiagramsSession.isGlobalGraphSelected());
    }

    @Test
    public void testIsGlobalGraphWhenItReturnsFalse() {
        DMNDiagramElement diagramElement = new DMNDiagramElement(new Id(), new Name("None"));
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(new DMNDiagramSelected(diagramElement));
        Assert.assertFalse((boolean)this.dmnDiagramsSession.isGlobalGraphSelected());
    }

    @Test
    public void testGetCurrentDiagramId() {
        DMNDiagramElement diagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        Id id = (Id)Mockito.mock(Id.class);
        String expectedId = "value";
        Mockito.when((Object)id.getValue()).thenReturn((Object)"value");
        Mockito.when((Object)diagramElement.getId()).thenReturn((Object)id);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        String actualId = this.dmnDiagramsSession.getCurrentDiagramId();
        Assert.assertEquals((Object)"value", (Object)actualId);
    }

    @Test
    public void testsSessionStatePresentWhenItReturnsTrue() {
        DMNDiagramsSessionState sessionState = (DMNDiagramsSessionState)Mockito.mock(DMNDiagramsSessionState.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)sessionState).when((Object)this.dmnDiagramsSession)).getSessionState();
        Assert.assertTrue((boolean)this.dmnDiagramsSession.isSessionStatePresent());
    }

    @Test
    public void testsSessionStatePresentWhenItReturnsFalse() {
        ((DMNDiagramsSession)Mockito.doReturn(null).when((Object)this.dmnDiagramsSession)).getSessionState();
        Assert.assertFalse((boolean)this.dmnDiagramsSession.isSessionStatePresent());
    }

    @Test
    public void testGetNodesFromAllDiagramsWithContentId() {
        String contentId = "contentId";
        String anotherId1 = "anotherId1";
        String anotherId2 = "anotherId1";
        Node expected1 = this.createNodeWithContentDefinitionId("contentId");
        Node notExpected1 = this.createNodeWithContentDefinitionId("anotherId1");
        Node notExpected2 = this.createNodeWithContentDefinitionId("anotherId1");
        Node expected2 = this.createNodeWithContentDefinitionId("contentId");
        Node expected3 = this.createNodeWithContentDefinitionId("contentId");
        List<Node> nodes = Arrays.asList(expected1, notExpected1, notExpected2, expected2, expected3);
        ((DMNDiagramsSession)Mockito.doReturn(nodes).when((Object)this.dmnDiagramsSession)).getAllNodes();
        List foundNodes = this.dmnDiagramsSession.getNodesFromAllDiagramsWithContentId("contentId");
        Assert.assertEquals((long)3L, (long)foundNodes.size());
        Assert.assertTrue((boolean)foundNodes.contains(expected1));
        Assert.assertTrue((boolean)foundNodes.contains(expected2));
        Assert.assertTrue((boolean)foundNodes.contains(expected3));
    }

    @Test
    public void testDefinitionContainsDRGElement() {
        Node nodeWithContentDefinition = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)nodeWithContentDefinition.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Assert.assertTrue((boolean)this.dmnDiagramsSession.definitionContainsDRGElement(nodeWithContentDefinition));
    }

    @Test
    public void testDefinitionContainsDRGElement_WhenDefinitionIsNotDRGElement() {
        Node nodeWithContentDefinition = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Object obj = Mockito.mock(Object.class);
        Mockito.when((Object)nodeWithContentDefinition.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn(obj);
        Assert.assertFalse((boolean)this.dmnDiagramsSession.definitionContainsDRGElement(nodeWithContentDefinition));
    }

    @Test
    public void testDefinitionContainsDRGElement_WhenContentIsNotDefinition() {
        Node nodeWithContentDefinition = (Node)Mockito.mock(Node.class);
        Object obj = Mockito.mock(Object.class);
        Mockito.when((Object)nodeWithContentDefinition.getContent()).thenReturn(obj);
        Assert.assertFalse((boolean)this.dmnDiagramsSession.definitionContainsDRGElement(nodeWithContentDefinition));
    }

    @Test
    public void testGetDRGElementFromContentDefinition() {
        Node nodeWithContentDefinition = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)nodeWithContentDefinition.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        DRGElement actual = this.dmnDiagramsSession.getDRGElementFromContentDefinition(nodeWithContentDefinition);
        Assert.assertEquals((Object)drgElement, (Object)actual);
    }

    @Test
    public void testOnSessionDiagramOpenedEvent() {
        SessionDiagramOpenedEvent sessionDiagramOpenedEvent = (SessionDiagramOpenedEvent)Mockito.mock(SessionDiagramOpenedEvent.class);
        this.dmnDiagramsSession.onSessionDiagramOpenedEvent(sessionDiagramOpenedEvent);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).loadHistoryForTheCurrentDiagram();
    }

    @Test
    public void testLoadHistoryForTheCurrentDiagram() {
        Map storedRedoHistory = (Map)Mockito.mock(Map.class);
        Map storedUndoHistory = (Map)Mockito.mock(Map.class);
        String diagramId = "diagramId";
        EditorSession editorSession = (EditorSession)Mockito.mock(EditorSession.class);
        Optional<EditorSession> optionalEditorSession = Optional.of(editorSession);
        Registry undoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        Registry redoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        List redoHistory = (List)Mockito.mock(List.class);
        List undoHistory = (List)Mockito.mock(List.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedRedoHistory).when((Object)this.dmnDiagramsSession)).getStoredRedoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedUndoHistory).when((Object)this.dmnDiagramsSession)).getStoredUndoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)"diagramId").when((Object)this.dmnDiagramsSession)).getCurrentDiagramId();
        ((DMNDiagramsSession)Mockito.doReturn(optionalEditorSession).when((Object)this.dmnDiagramsSession)).getCurrentSession();
        Mockito.when((Object)storedRedoHistory.containsKey("diagramId")).thenReturn((Object)true);
        Mockito.when((Object)storedUndoHistory.containsKey("diagramId")).thenReturn((Object)true);
        Mockito.when((Object)editorSession.getCommandRegistry()).thenReturn((Object)undoCommandRegistry);
        Mockito.when((Object)editorSession.getRedoCommandRegistry()).thenReturn((Object)redoCommandRegistry);
        Mockito.when((Object)((List)storedRedoHistory.get("diagramId"))).thenReturn((Object)redoHistory);
        Mockito.when((Object)((List)storedUndoHistory.get("diagramId"))).thenReturn((Object)undoHistory);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(redoHistory, redoCommandRegistry);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(undoHistory, undoCommandRegistry);
        this.dmnDiagramsSession.loadHistoryForTheCurrentDiagram();
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(redoHistory, redoCommandRegistry);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(undoHistory, undoCommandRegistry);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).notifyRegistryChanged();
        ((Registry)Mockito.verify((Object)undoCommandRegistry, (VerificationMode)Mockito.never())).clear();
        ((Registry)Mockito.verify((Object)redoCommandRegistry, (VerificationMode)Mockito.never())).clear();
    }

    @Test
    public void testLoadHistoryForTheCurrentDiagram_WhenItIsNotEditorSession() {
        Map storedRedoHistory = (Map)Mockito.mock(Map.class);
        Map storedUndoHistory = (Map)Mockito.mock(Map.class);
        String diagramId = "diagramId";
        ViewerSession viewerSession = (ViewerSession)Mockito.mock(ViewerSession.class);
        Optional<ViewerSession> optionalViewerSession = Optional.of(viewerSession);
        Registry undoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        Registry redoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        List redoHistory = (List)Mockito.mock(List.class);
        List undoHistory = (List)Mockito.mock(List.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedRedoHistory).when((Object)this.dmnDiagramsSession)).getStoredRedoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedUndoHistory).when((Object)this.dmnDiagramsSession)).getStoredUndoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)"diagramId").when((Object)this.dmnDiagramsSession)).getCurrentDiagramId();
        ((DMNDiagramsSession)Mockito.doReturn(optionalViewerSession).when((Object)this.dmnDiagramsSession)).getCurrentSession();
        Mockito.when((Object)storedRedoHistory.containsKey("diagramId")).thenReturn((Object)true);
        Mockito.when((Object)storedUndoHistory.containsKey("diagramId")).thenReturn((Object)true);
        Mockito.when((Object)((List)storedRedoHistory.get("diagramId"))).thenReturn((Object)redoHistory);
        Mockito.when((Object)((List)storedUndoHistory.get("diagramId"))).thenReturn((Object)undoHistory);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(redoHistory, redoCommandRegistry);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(undoHistory, undoCommandRegistry);
        this.dmnDiagramsSession.loadHistoryForTheCurrentDiagram();
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.never())).loadHistoryToTheRegistry(redoHistory, redoCommandRegistry);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.never())).loadHistoryToTheRegistry(undoHistory, undoCommandRegistry);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.never())).notifyRegistryChanged();
        ((Registry)Mockito.verify((Object)undoCommandRegistry, (VerificationMode)Mockito.never())).clear();
        ((Registry)Mockito.verify((Object)redoCommandRegistry, (VerificationMode)Mockito.never())).clear();
    }

    @Test
    public void testLoadHistoryForTheCurrentDiagram_WhenThereIsNotHistoryStored() {
        Map storedRedoHistory = (Map)Mockito.mock(Map.class);
        Map storedUndoHistory = (Map)Mockito.mock(Map.class);
        String diagramId = "diagramId";
        EditorSession editorSession = (EditorSession)Mockito.mock(EditorSession.class);
        Optional<EditorSession> optionalEditorSession = Optional.of(editorSession);
        Registry undoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        Registry redoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        List redoHistory = (List)Mockito.mock(List.class);
        List undoHistory = (List)Mockito.mock(List.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedRedoHistory).when((Object)this.dmnDiagramsSession)).getStoredRedoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedUndoHistory).when((Object)this.dmnDiagramsSession)).getStoredUndoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)"diagramId").when((Object)this.dmnDiagramsSession)).getCurrentDiagramId();
        ((DMNDiagramsSession)Mockito.doReturn(optionalEditorSession).when((Object)this.dmnDiagramsSession)).getCurrentSession();
        Mockito.when((Object)storedRedoHistory.containsKey("diagramId")).thenReturn((Object)false);
        Mockito.when((Object)storedUndoHistory.containsKey("diagramId")).thenReturn((Object)false);
        Mockito.when((Object)editorSession.getCommandRegistry()).thenReturn((Object)undoCommandRegistry);
        Mockito.when((Object)editorSession.getRedoCommandRegistry()).thenReturn((Object)redoCommandRegistry);
        Mockito.when((Object)((List)storedRedoHistory.get("diagramId"))).thenReturn((Object)redoHistory);
        Mockito.when((Object)((List)storedUndoHistory.get("diagramId"))).thenReturn((Object)undoHistory);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(redoHistory, redoCommandRegistry);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).loadHistoryToTheRegistry(undoHistory, undoCommandRegistry);
        this.dmnDiagramsSession.loadHistoryForTheCurrentDiagram();
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.never())).loadHistoryToTheRegistry(redoHistory, redoCommandRegistry);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.never())).loadHistoryToTheRegistry(undoHistory, undoCommandRegistry);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).notifyRegistryChanged();
        ((Registry)Mockito.verify((Object)undoCommandRegistry)).clear();
        ((Registry)Mockito.verify((Object)redoCommandRegistry)).clear();
    }

    @Test
    public void testLoadHistoryToTheRegistry() {
        Command command1 = (Command)Mockito.mock(Command.class);
        Command command2 = (Command)Mockito.mock(Command.class);
        Command command3 = (Command)Mockito.mock(Command.class);
        List<Command> history = Arrays.asList(command1, command2, command3);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{registry});
        this.dmnDiagramsSession.loadHistoryToTheRegistry(history, registry);
        ((Registry)inOrder.verify((Object)registry)).clear();
        ((Registry)inOrder.verify((Object)registry)).register((Object)command1);
        ((Registry)inOrder.verify((Object)registry)).register((Object)command2);
        ((Registry)inOrder.verify((Object)registry)).register((Object)command3);
    }

    @Test
    public void testStoreCurrentRegistryHistory() {
        Map storedRedoHistory = (Map)Mockito.mock(Map.class);
        Map storedUndoHistory = (Map)Mockito.mock(Map.class);
        String diagramId = "diagramId";
        EditorSession editorSession = (EditorSession)Mockito.mock(EditorSession.class);
        Optional<EditorSession> optionalEditorSession = Optional.of(editorSession);
        List undoHistory = (List)Mockito.mock(List.class);
        List redoHistory = (List)Mockito.mock(List.class);
        Registry undoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        Registry redoCommandRegistry = (Registry)Mockito.mock(Registry.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedRedoHistory).when((Object)this.dmnDiagramsSession)).getStoredRedoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)storedUndoHistory).when((Object)this.dmnDiagramsSession)).getStoredUndoHistories();
        ((DMNDiagramsSession)Mockito.doReturn((Object)"diagramId").when((Object)this.dmnDiagramsSession)).getCurrentDiagramId();
        ((DMNDiagramsSession)Mockito.doReturn(optionalEditorSession).when((Object)this.dmnDiagramsSession)).getCurrentSession();
        Mockito.when((Object)editorSession.getCommandRegistry()).thenReturn((Object)undoCommandRegistry);
        Mockito.when((Object)editorSession.getRedoCommandRegistry()).thenReturn((Object)redoCommandRegistry);
        Mockito.when((Object)undoCommandRegistry.getHistory()).thenReturn((Object)undoHistory);
        Mockito.when((Object)redoCommandRegistry.getHistory()).thenReturn((Object)redoHistory);
        this.dmnDiagramsSession.storeCurrentRegistryHistory();
        ((Map)Mockito.verify((Object)storedUndoHistory)).put("diagramId", undoHistory);
        ((Map)Mockito.verify((Object)storedRedoHistory)).put("diagramId", redoHistory);
    }

    @Test
    public void testOnDMNDiagramSelected_WhenBelongsToCurrentSessionState() {
        DMNDiagramElement selectedDiagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        DMNDiagramSelected dmnDiagramSelected = new DMNDiagramSelected(selectedDiagramElement);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).storeCurrentRegistryHistory();
        ((DMNDiagramsSession)Mockito.doReturn((Object)true).when((Object)this.dmnDiagramsSession)).belongsToCurrentSessionState(selectedDiagramElement);
        this.dmnDiagramsSession.onDMNDiagramSelected(dmnDiagramSelected);
        ((DMNDiagramsSessionState)Mockito.verify((Object)this.dmnDiagramsSessionState)).setCurrentDMNDiagramElement(selectedDiagramElement);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).storeCurrentRegistryHistory();
    }

    @Test
    public void testOnDMNDiagramSelected_WhenDopesNotBelongsToCurrentSessionState() {
        DMNDiagramElement selectedDiagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        DMNDiagramSelected dmnDiagramSelected = new DMNDiagramSelected(selectedDiagramElement);
        ((DMNDiagramsSession)Mockito.doNothing().when((Object)this.dmnDiagramsSession)).storeCurrentRegistryHistory();
        ((DMNDiagramsSession)Mockito.doReturn((Object)false).when((Object)this.dmnDiagramsSession)).belongsToCurrentSessionState(selectedDiagramElement);
        this.dmnDiagramsSession.onDMNDiagramSelected(dmnDiagramSelected);
        ((DMNDiagramsSessionState)Mockito.verify((Object)this.dmnDiagramsSessionState, (VerificationMode)Mockito.never())).setCurrentDMNDiagramElement(selectedDiagramElement);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).storeCurrentRegistryHistory();
    }

    private Node createNodeWithContentDefinitionId(String contentDefinitionId) {
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)drgElement.getContentDefinitionId()).thenReturn((Object)contentDefinitionId);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        return node;
    }
}

