/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.factories;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.common.BoxedExpressionHelper;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorNestedItemFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorNestedItemFactoryTest {
    private static final String DECISION_TABLE_DEFINITION_NAME = "Decision Table";
    @Mock
    private SessionManager sessionManager;
    @Mock
    private EventSourceMock<EditExpressionEvent> editExpressionEvent;
    @Mock
    private Node<View, Edge> node;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private EventSourceMock<CanvasSelectionEvent> canvasSelectionEvent;
    @Mock
    private ExpressionEditorDefinition decisionTableEditorDefinition;
    @Mock
    private BoxedExpressionHelper boxedExpressionHelper;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    private DecisionNavigatorNestedItemFactory factory;

    @Before
    public void setup() {
        this.factory = (DecisionNavigatorNestedItemFactory)Mockito.spy((Object)new DecisionNavigatorNestedItemFactory(this.sessionManager, this.editExpressionEvent, this.dmnGraphUtils, this.expressionEditorDefinitionsSupplier, this.canvasSelectionEvent, this.boxedExpressionHelper, this.readOnlyProvider));
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.decisionTableEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.decisionTableEditorDefinition.getModelClass()).thenReturn(Optional.of(new DecisionTable()));
        Mockito.when((Object)this.decisionTableEditorDefinition.getName()).thenReturn((Object)DECISION_TABLE_DEFINITION_NAME);
    }

    @Test
    public void testMakeItem() {
        String uuid = "uuid";
        String label = "label";
        DecisionNavigatorItem.Type type = DecisionNavigatorItem.Type.DECISION_TABLE;
        Command command = (Command)Mockito.mock(Command.class);
        String parentUUID = "parentUUID";
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)"parentUUID");
        ((DecisionNavigatorNestedItemFactory)Mockito.doReturn((Object)"uuid").when((Object)this.factory)).getUUID(this.node);
        ((DecisionNavigatorNestedItemFactory)Mockito.doReturn((Object)"label").when((Object)this.factory)).getLabel(this.node);
        ((DecisionNavigatorNestedItemFactory)Mockito.doReturn((Object)type).when((Object)this.factory)).getType(this.node);
        ((DecisionNavigatorNestedItemFactory)Mockito.doReturn((Object)command).when((Object)this.factory)).makeOnClickCommand(this.node, "parentUUID");
        DecisionNavigatorItem item = this.factory.makeItem(this.node);
        Assert.assertTrue((boolean)item.getOnClick().isPresent());
        Assert.assertEquals((Object)command, item.getOnClick().get());
        Assert.assertEquals((Object)"uuid", (Object)item.getUUID());
        Assert.assertEquals((Object)"label", (Object)item.getLabel());
        Assert.assertEquals((Object)type, (Object)item.getType());
        Assert.assertEquals((Object)"parentUUID", (Object)item.getParentUUID());
    }

    @Test
    public void testMakeOnClickCommand() {
        EditExpressionEvent expressionEvent = (EditExpressionEvent)Mockito.mock(EditExpressionEvent.class);
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        CanvasSelectionEvent event = (CanvasSelectionEvent)Mockito.mock(CanvasSelectionEvent.class);
        String uuid = "uuid";
        Mockito.when((Object)this.dmnGraphUtils.getCanvasHandler()).thenReturn((Object)canvasHandler);
        ((DecisionNavigatorNestedItemFactory)Mockito.doReturn((Object)event).when((Object)this.factory)).makeCanvasSelectionEvent(canvasHandler, "uuid");
        ((DecisionNavigatorNestedItemFactory)Mockito.doReturn((Object)expressionEvent).when((Object)this.factory)).makeEditExpressionEvent(this.node);
        this.factory.makeOnClickCommand(this.node, "uuid").execute();
        ((EventSourceMock)Mockito.verify(this.canvasSelectionEvent)).fire((Object)event);
        ((EventSourceMock)Mockito.verify(this.editExpressionEvent)).fire((Object)expressionEvent);
    }

    @Test
    public void testMakeCanvasSelectionEvent() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        String uuid = "uuid";
        CanvasSelectionEvent event = this.factory.makeCanvasSelectionEvent(canvasHandler, "uuid");
        Assert.assertEquals((Object)canvasHandler, (Object)event.getCanvasHandler());
        Assert.assertEquals((Object)"uuid", event.getIdentifiers().iterator().next());
    }

    @Test
    public void testMakeEditExpressionEvent() {
        ClientSession currentSession = (ClientSession)Mockito.mock(ClientSession.class);
        HasName hasName = (HasName)Mockito.mock(HasName.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        View view = (View)Mockito.mock(View.class);
        String uuid = "uuid";
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)currentSession);
        Mockito.when((Object)((View)this.node.getContent())).thenReturn((Object)view);
        Mockito.when((Object)view.getDefinition()).thenReturn((Object)hasName);
        Mockito.when((Object)this.boxedExpressionHelper.getHasExpression(this.node)).thenReturn((Object)hasExpression);
        EditExpressionEvent expressionEvent = this.factory.makeEditExpressionEvent(this.node);
        Assert.assertEquals((Object)"uuid", (Object)expressionEvent.getNodeUUID());
        Assert.assertEquals((Object)currentSession, (Object)expressionEvent.getSession());
        Assert.assertEquals(Optional.of(hasName), (Object)expressionEvent.getHasName());
        Assert.assertEquals((Object)hasExpression, (Object)expressionEvent.getHasExpression());
        Assert.assertFalse((boolean)expressionEvent.isOnlyVisualChangeAllowed());
    }

    @Test
    public void testMakeEditExpressionEventWhenIsReadOnly() {
        ClientSession currentSession = (ClientSession)Mockito.mock(ClientSession.class);
        HasName hasName = (HasName)Mockito.mock(HasName.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        View view = (View)Mockito.mock(View.class);
        String uuid = "uuid";
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)currentSession);
        Mockito.when((Object)((View)this.node.getContent())).thenReturn((Object)view);
        Mockito.when((Object)view.getDefinition()).thenReturn((Object)hasName);
        Mockito.when((Object)this.boxedExpressionHelper.getHasExpression(this.node)).thenReturn((Object)hasExpression);
        EditExpressionEvent expressionEvent = this.factory.makeEditExpressionEvent(this.node);
        Assert.assertEquals((Object)"uuid", (Object)expressionEvent.getNodeUUID());
        Assert.assertEquals((Object)currentSession, (Object)expressionEvent.getSession());
        Assert.assertEquals(Optional.of(hasName), (Object)expressionEvent.getHasName());
        Assert.assertEquals((Object)hasExpression, (Object)expressionEvent.getHasExpression());
        Assert.assertTrue((boolean)expressionEvent.isOnlyVisualChangeAllowed());
    }

    @Test
    public void testGetUUID() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        Id id = (Id)Mockito.mock(Id.class);
        String expectedUUID = "uuid";
        Mockito.when((Object)this.boxedExpressionHelper.getExpression(this.node)).thenReturn((Object)expression);
        Mockito.when((Object)expression.getId()).thenReturn((Object)id);
        Mockito.when((Object)id.getValue()).thenReturn((Object)"uuid");
        String actualUUID = this.factory.getUUID(this.node);
        Assert.assertEquals((Object)"uuid", (Object)actualUUID);
    }

    @Test
    public void testGetLabel() {
        DecisionTable expression = new DecisionTable();
        Mockito.when((Object)this.boxedExpressionHelper.getExpression(this.node)).thenReturn((Object)expression);
        String actualLabel = this.factory.getLabel(this.node);
        Assert.assertEquals((Object)DECISION_TABLE_DEFINITION_NAME, (Object)actualLabel);
    }

    @Test
    public void testGetType() {
        DecisionTable expression = new DecisionTable();
        DecisionNavigatorItem.Type expectedType = DecisionNavigatorItem.Type.DECISION_TABLE;
        Mockito.when((Object)this.boxedExpressionHelper.getExpression(this.node)).thenReturn((Object)expression);
        DecisionNavigatorItem.Type actualType = this.factory.getType(this.node);
        Assert.assertEquals((Object)expectedType, (Object)actualType);
    }

    @Test
    public void testHasNestedElementWhenNodeHasExpressionIsNull() {
        Optional hasExpression = Optional.empty();
        Optional expression = Optional.empty();
        Mockito.when((Object)this.boxedExpressionHelper.getOptionalHasExpression(this.node)).thenReturn(hasExpression);
        Mockito.when((Object)this.boxedExpressionHelper.getOptionalExpression(this.node)).thenReturn(expression);
        Assert.assertFalse((boolean)this.factory.hasNestedElement(this.node));
    }

    @Test
    public void testHasNestedElementWhenNodeExpressionIsNull() {
        Optional<HasExpression> hasExpression = Optional.ofNullable((HasExpression)Mockito.mock(HasExpression.class));
        Optional expression = Optional.empty();
        Mockito.when((Object)this.boxedExpressionHelper.getOptionalHasExpression(this.node)).thenReturn(hasExpression);
        Mockito.when((Object)this.boxedExpressionHelper.getOptionalExpression(this.node)).thenReturn(expression);
        Assert.assertFalse((boolean)this.factory.hasNestedElement(this.node));
    }

    @Test
    public void testHasNestedElementWhenNodeHasNestedElement() {
        Optional<HasExpression> hasExpression = Optional.ofNullable((HasExpression)Mockito.mock(HasExpression.class));
        Optional<Expression> expression = Optional.ofNullable((Expression)Mockito.mock(Expression.class));
        Mockito.when((Object)this.boxedExpressionHelper.getOptionalHasExpression(this.node)).thenReturn(hasExpression);
        Mockito.when((Object)this.boxedExpressionHelper.getOptionalExpression(this.node)).thenReturn(expression);
        Assert.assertTrue((boolean)this.factory.hasNestedElement(this.node));
    }
}

