/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponent;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentFilter;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentsItem;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionComponentFilterTest {
    private DecisionComponentFilter filter;

    @Before
    public void setup() {
        this.filter = new DecisionComponentFilter();
    }

    @Test
    public void testGetDrgElementWhenDrgElementIsNotPresent() {
        Assert.assertFalse((boolean)this.filter.getDrgElement().isPresent());
    }

    @Test
    public void testGetDrgElement() {
        String decision = "Decision";
        this.filter.setDrgElement("Decision");
        Assert.assertTrue((boolean)this.filter.getDrgElement().isPresent());
        Assert.assertEquals((Object)"Decision", this.filter.getDrgElement().get());
    }

    @Test
    public void testGetTermWhenTermIsNotPresent() {
        Assert.assertFalse((boolean)this.filter.getTerm().isPresent());
    }

    @Test
    public void testGetTerm() {
        String term = "term";
        this.filter.setTerm("term");
        Assert.assertTrue((boolean)this.filter.getTerm().isPresent());
        Assert.assertEquals((Object)"term", this.filter.getTerm().get());
    }

    @Test
    public void testQueryWithoutFilters() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List<DecisionComponentsItem> expectedResult = Arrays.asList(item1, item2, item3, item4);
        Assert.assertEquals(expectedResult, actualResult);
    }

    @Test
    public void testQueryFilteredByTerm() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        this.filter.setTerm("name");
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List<DecisionComponentsItem> expectedResult = Collections.singletonList(item4);
        Assert.assertEquals(expectedResult, actualResult);
    }

    @Test
    public void testQueryFilteredByTermMultipleResults() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        this.filter.setTerm("?");
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List<DecisionComponentsItem> expectedResult = Arrays.asList(item1, item2);
        Assert.assertEquals(expectedResult, actualResult);
    }

    @Test
    public void testQueryFilteredByDrgElement() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        this.filter.setDrgElement("Decision");
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List<DecisionComponentsItem> expectedResult = Arrays.asList(item1, item2);
        Assert.assertEquals(expectedResult, actualResult);
    }

    @Test
    public void testQueryFilteredByDrgElementNoResult() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        this.filter.setDrgElement("KnowledgeRequirement");
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List expectedResult = Collections.emptyList();
        Assert.assertEquals(expectedResult, actualResult);
    }

    @Test
    public void testQueryFilteredByDrgElementAndTerm() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        this.filter.setTerm("is");
        this.filter.setDrgElement("Decision");
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List<DecisionComponentsItem> expectedResult = Collections.singletonList(item2);
        Assert.assertEquals(expectedResult, actualResult);
    }

    @Test
    public void testQueryFilteredByDrgElementAndTermMultipleResults() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        this.filter.setTerm("e");
        this.filter.setDrgElement("InputData");
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List<DecisionComponentsItem> expectedResult = Arrays.asList(item3, item4);
        Assert.assertEquals(expectedResult, actualResult);
    }

    @Test
    public void testQueryFilteredByDrgElementAndTermNoResult() {
        DecisionComponentsItem item1 = this.item("Can Drive?", (DRGElement)new Decision());
        DecisionComponentsItem item2 = this.item("Is Allowed?", (DRGElement)new Decision());
        DecisionComponentsItem item3 = this.item("Age", (DRGElement)new InputData());
        DecisionComponentsItem item4 = this.item("Name", (DRGElement)new InputData());
        Stream<DecisionComponentsItem> stream = Stream.of(item1, item2, item3, item4);
        this.filter.setTerm("?");
        this.filter.setDrgElement("InputData");
        Stream query = this.filter.query(stream);
        List actualResult = query.collect(Collectors.toList());
        List expectedResult = Collections.emptyList();
        Assert.assertEquals(expectedResult, actualResult);
    }

    private DecisionComponentsItem item(String drgElementName, DRGElement drgElement) {
        DecisionComponentsItem item = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        Name name = (Name)Mockito.mock(Name.class);
        DecisionComponent decisionComponent = new DecisionComponent("file.dmn", drgElement, true);
        Mockito.when((Object)name.getValue()).thenReturn((Object)drgElementName);
        Mockito.when((Object)item.getDecisionComponent()).thenReturn((Object)decisionComponent);
        drgElement.setName(name);
        return item;
    }
}

