/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.common.messages;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessages;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessagesView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class FlashMessagesTest {
    @Mock
    private FlashMessagesView view;
    private FlashMessages flashMessages;

    @Before
    public void setup() {
        this.flashMessages = (FlashMessages)Mockito.spy((Object)new FlashMessages((FlashMessages.View)this.view));
    }

    @Test
    public void testInit() {
        this.flashMessages.init();
        ((FlashMessagesView)Mockito.verify((Object)this.view)).init(this.flashMessages);
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedHTMLElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedHTMLElement);
        HTMLElement actualHTMLElement = this.flashMessages.getElement();
        Assert.assertEquals((Object)expectedHTMLElement, (Object)actualHTMLElement);
    }

    @Test
    public void testOnFlashMessageEventWhenElementIsPresent() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String selector = "selector";
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).registerFlashMessageCallback(flashMessage);
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).showFlashMessage(flashMessage);
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).highlighElement(flashMessage);
        Mockito.when((Object)flashMessage.getElementSelector()).thenReturn((Object)"selector");
        Mockito.when((Object)this.view.isElementPresent("selector")).thenReturn((Object)true);
        this.flashMessages.onFlashMessageEvent(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).registerFlashMessageCallback(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).showFlashMessage(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).highlighElement(flashMessage);
    }

    @Test
    public void testOnFlashMessageEventWhenElementIsNotPresent() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String selector = "selector";
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).registerFlashMessageCallback(flashMessage);
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).showFlashMessage(flashMessage);
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).highlighElement(flashMessage);
        Mockito.when((Object)flashMessage.getElementSelector()).thenReturn((Object)"selector");
        Mockito.when((Object)this.view.isElementPresent("selector")).thenReturn((Object)false);
        this.flashMessages.onFlashMessageEvent(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).registerFlashMessageCallback(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).showFlashMessage(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages, (VerificationMode)Mockito.never())).highlighElement(flashMessage);
    }

    @Test
    public void testOnFlashMessageEventWhenSelectorIsEmpty() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String selector = "";
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).registerFlashMessageCallback(flashMessage);
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).showFlashMessage(flashMessage);
        ((FlashMessages)Mockito.doNothing().when((Object)this.flashMessages)).highlighElement(flashMessage);
        Mockito.when((Object)flashMessage.getElementSelector()).thenReturn((Object)"");
        this.flashMessages.onFlashMessageEvent(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).registerFlashMessageCallback(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).showFlashMessage(flashMessage);
        ((FlashMessages)Mockito.verify((Object)this.flashMessages, (VerificationMode)Mockito.never())).highlighElement(flashMessage);
    }

    @Test
    public void testShowFlashMessageWhenItsAnErrorMessage() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String strongMessage = "*message*";
        String regularMessage = "message";
        Mockito.when((Object)flashMessage.getType()).thenReturn((Object)FlashMessage.Type.ERROR);
        Mockito.when((Object)flashMessage.getStrongMessage()).thenReturn((Object)"*message*");
        Mockito.when((Object)flashMessage.getRegularMessage()).thenReturn((Object)"message");
        this.flashMessages.showFlashMessage(flashMessage);
        ((FlashMessagesView)Mockito.verify((Object)this.view)).showErrorMessage("*message*", "message");
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showWarningMessage((String)Mockito.any(), (String)Mockito.any());
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showSuccessMessage((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testShowFlashMessageWhenItsAWarningMessage() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String strongMessage = "*message*";
        String regularMessage = "message";
        Mockito.when((Object)flashMessage.getType()).thenReturn((Object)FlashMessage.Type.WARNING);
        Mockito.when((Object)flashMessage.getStrongMessage()).thenReturn((Object)"*message*");
        Mockito.when((Object)flashMessage.getRegularMessage()).thenReturn((Object)"message");
        this.flashMessages.showFlashMessage(flashMessage);
        ((FlashMessagesView)Mockito.verify((Object)this.view)).showWarningMessage("*message*", "message");
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showErrorMessage((String)Mockito.any(), (String)Mockito.any());
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showSuccessMessage((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testShowFlashMessageWhenItsASuccessMessage() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String strongMessage = "*message*";
        String regularMessage = "message";
        Mockito.when((Object)flashMessage.getType()).thenReturn((Object)FlashMessage.Type.SUCCESS);
        Mockito.when((Object)flashMessage.getStrongMessage()).thenReturn((Object)"*message*");
        Mockito.when((Object)flashMessage.getRegularMessage()).thenReturn((Object)"message");
        this.flashMessages.showFlashMessage(flashMessage);
        ((FlashMessagesView)Mockito.verify((Object)this.view)).showSuccessMessage("*message*", "message");
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showWarningMessage((String)Mockito.any(), (String)Mockito.any());
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showErrorMessage((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testHighlightElementWhenItsAnErrorMessage() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String elementSelector = "elementSelector";
        Mockito.when((Object)flashMessage.getType()).thenReturn((Object)FlashMessage.Type.ERROR);
        Mockito.when((Object)flashMessage.getElementSelector()).thenReturn((Object)"elementSelector");
        this.flashMessages.highlighElement(flashMessage);
        ((FlashMessagesView)Mockito.verify((Object)this.view)).showErrorHighlight("elementSelector");
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showWarningHighlight((String)Mockito.any());
    }

    @Test
    public void testHighlightElementWhenItsAWarningMessage() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String elementSelector = "elementSelector";
        Mockito.when((Object)flashMessage.getType()).thenReturn((Object)FlashMessage.Type.WARNING);
        Mockito.when((Object)flashMessage.getElementSelector()).thenReturn((Object)"elementSelector");
        this.flashMessages.highlighElement(flashMessage);
        ((FlashMessagesView)Mockito.verify((Object)this.view)).showWarningHighlight("elementSelector");
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showErrorHighlight((String)Mockito.any());
    }

    @Test
    public void testRegisterFlashMessageCallback() {
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        Command onSuccess = (Command)Mockito.mock(Command.class);
        Command onError = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)flashMessage.getOnSuccess()).thenReturn((Object)onSuccess);
        Mockito.when((Object)flashMessage.getOnError()).thenReturn((Object)onError);
        Mockito.when((Object)flashMessage.getType()).thenReturn((Object)FlashMessage.Type.WARNING);
        this.flashMessages.registerFlashMessageCallback(flashMessage);
        this.flashMessages.executeSuccessWarningCallback();
        this.flashMessages.executeErrorWarningCallback();
        ((Command)Mockito.verify((Object)onSuccess)).execute();
        ((Command)Mockito.verify((Object)onError)).execute();
    }

    @Test
    public void testHideMessages() {
        this.flashMessages.hideMessages();
        ((FlashMessagesView)Mockito.verify((Object)this.view)).hideErrorContainer();
        ((FlashMessagesView)Mockito.verify((Object)this.view)).hideWarningContainer();
    }
}

