/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.contextmenu;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenu;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenuView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;

public class ContextMenuTest {
    private ContextMenu contextMenu;
    private ContextMenuView view;
    public static final String TITLE = "TITLE";
    public static final Command DO_NOTHING = () -> {};

    @Before
    public void setUp() {
        this.view = (ContextMenuView)Mockito.mock(ContextMenuView.class);
        this.contextMenu = new ContextMenu((ContextMenu.View)this.view);
    }

    @Test
    public void testWhenInitContextMenuThenRelatedViewIsInit() {
        this.contextMenu.init();
        ((ContextMenuView)Mockito.verify((Object)this.view)).init(this.contextMenu);
    }

    @Test
    public void testWhenShowingContextMenuThenRelatedViewIsShown() {
        this.contextMenu.show();
        ((ContextMenuView)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testWhenShowingContextMenuAndCustomActionsArePassedThenRelatedViewIsShown() {
        this.contextMenu.show(self -> self.addTextMenuItem(TITLE, true, DO_NOTHING));
        ((ContextMenuView)Mockito.verify((Object)this.view)).show();
        this.verifyTextMenuItem();
    }

    @Test
    public void testWhenHidingContextMenuThenRelatedViewIsHidden() {
        ContextMenu contextMenu = new ContextMenu((ContextMenu.View)this.view);
        contextMenu.hide();
        ((ContextMenuView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testWhenGettingContextMenuElementThenRelatedViewElementIsGot() {
        this.contextMenu.getElement();
        ((ContextMenuView)Mockito.verify((Object)this.view)).getElement();
    }

    @Test
    public void testWhenGettingFreshContextMenuItemsThenListIsEmpty() {
        Assertions.assertThat((List)this.contextMenu.getItems()).isNotNull();
        Assertions.assertThat((List)this.contextMenu.getItems()).isEmpty();
    }

    @Test
    public void testWhenSettingHeaderForContextMenuThenItemListContainsHeader() {
        String iconClass = "icon-class";
        this.contextMenu.setHeaderMenu(TITLE, "icon-class");
        Assertions.assertThat((List)this.contextMenu.getItems()).isNotNull();
        Assertions.assertThat((List)this.contextMenu.getItems()).isNotEmpty();
        Assertions.assertThat((int)this.contextMenu.getItems().size()).isEqualTo(1);
        HasListSelectorControl.ListSelectorHeaderItem headerItem = (HasListSelectorControl.ListSelectorHeaderItem)this.contextMenu.getItems().get(0);
        Assertions.assertThat((String)headerItem.getText()).isEqualTo(TITLE);
        Assertions.assertThat((String)headerItem.getIconClass()).isEqualTo("icon-class");
    }

    @Test
    public void testAddingTextMenuItemForContextMenuThenItemListContainsIt() {
        this.contextMenu.addTextMenuItem(TITLE, true, DO_NOTHING);
        this.verifyTextMenuItem();
    }

    private void verifyTextMenuItem() {
        Assertions.assertThat((List)this.contextMenu.getItems()).isNotNull();
        Assertions.assertThat((List)this.contextMenu.getItems()).isNotEmpty();
        Assertions.assertThat((int)this.contextMenu.getItems().size()).isEqualTo(1);
        HasListSelectorControl.ListSelectorTextItem textItem = (HasListSelectorControl.ListSelectorTextItem)this.contextMenu.getItems().get(0);
        Assertions.assertThat((String)textItem.getText()).isEqualTo(TITLE);
        Assertions.assertThat((boolean)textItem.isEnabled()).isEqualTo(true);
        Assertions.assertThat((Object)textItem.getCommand()).isEqualTo((Object)DO_NOTHING);
    }
}

