/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.documentation.DMNDocumentationView;
import org.kie.workbench.common.dmn.client.editors.documentation.DMNDocumentationViewButtonsVisibilitySupplier;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationService;
import org.kie.workbench.common.dmn.client.editors.documentation.common.HTMLDownloadHelper;
import org.kie.workbench.common.stunner.core.client.util.PrintHelper;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.model.DocumentationOutput;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDocumentationViewTest {
    @Mock
    private HTMLDivElement documentationPanel;
    @Mock
    private HTMLDivElement documentationContent;
    @Mock
    private HTMLButtonElement printButton;
    @Mock
    private PrintHelper printHelper;
    @Mock
    private DMNDocumentationService documentationService;
    @Mock
    private Diagram diagram;
    @Mock
    private HTMLDownloadHelper downloadHelper;
    @Mock
    private DMNDocumentationViewButtonsVisibilitySupplier buttonsVisibilitySupplier;
    @Mock
    private DOMTokenList printButtonClassList;
    @Mock
    private DOMTokenList downloadButtonClassList;
    @Mock
    private HTMLButtonElement downloadHtmlFileButton;
    @Captor
    private ArgumentCaptor<DomGlobal.SetTimeoutCallbackFn> callback;
    private DMNDocumentationView view;

    @Before
    public void setup() {
        this.printButton.classList = this.printButtonClassList;
        this.downloadHtmlFileButton.classList = this.downloadButtonClassList;
        this.view = (DMNDocumentationView)Mockito.spy((Object)new DMNDocumentationView(this.documentationPanel, this.documentationContent, this.printButton, this.downloadHtmlFileButton, this.printHelper, this.documentationService, this.downloadHelper, this.buttonsVisibilitySupplier));
    }

    @Test
    public void testRefresh() {
        ((DMNDocumentationView)Mockito.doNothing().when((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Mockito.when((Object)this.buttonsVisibilitySupplier.isButtonsVisible()).thenReturn((Object)true);
        this.view.refresh();
        ((DOMTokenList)Mockito.verify((Object)this.downloadButtonClassList, (VerificationMode)Mockito.never())).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.printButtonClassList, (VerificationMode)Mockito.never())).add(new String[]{"hidden"});
        ((DMNDocumentationViewButtonsVisibilitySupplier)Mockito.verify((Object)this.buttonsVisibilitySupplier)).isButtonsVisible();
        ((DMNDocumentationView)Mockito.verify((Object)this.view)).refreshDocumentationHTML();
        ((DMNDocumentationView)Mockito.verify((Object)this.view)).refreshDocumentationHTMLAfter200ms();
    }

    @Test
    public void testRefreshWhenButtonsAreNotVisible() {
        ((DMNDocumentationView)Mockito.doNothing().when((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Mockito.when((Object)this.buttonsVisibilitySupplier.isButtonsVisible()).thenReturn((Object)false);
        this.view.refresh();
        ((DOMTokenList)Mockito.verify((Object)this.downloadButtonClassList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.printButtonClassList)).add(new String[]{"hidden"});
        ((DMNDocumentationViewButtonsVisibilitySupplier)Mockito.verify((Object)this.buttonsVisibilitySupplier)).isButtonsVisible();
        ((DMNDocumentationView)Mockito.verify((Object)this.view)).refreshDocumentationHTML();
        ((DMNDocumentationView)Mockito.verify((Object)this.view)).refreshDocumentationHTMLAfter200ms();
    }

    @Test
    public void testRefreshDocumentationHTMLWhenDiagramIsPresent() {
        String expectedHTML = "<html />";
        DocumentationOutput output = new DocumentationOutput("<html />");
        ((DMNDocumentationView)Mockito.doReturn(Optional.of(this.diagram)).when((Object)this.view)).getDiagram();
        Mockito.when((Object)this.documentationService.generate(this.diagram)).thenReturn((Object)output);
        this.documentationContent.innerHTML = "something";
        this.view.refreshDocumentationHTML();
        String actualHTML = this.documentationContent.innerHTML;
        Assert.assertEquals((Object)"<html />", (Object)actualHTML);
    }

    @Test
    public void testRefreshDocumentationHTMLWhenDiagramIsNotPresent() {
        String expectedHTML = DocumentationOutput.EMPTY.getValue();
        ((DMNDocumentationView)Mockito.doReturn(Optional.empty()).when((Object)this.view)).getDiagram();
        this.documentationContent.innerHTML = "something";
        this.view.refreshDocumentationHTML();
        String actualHTML = this.documentationContent.innerHTML;
        Assert.assertEquals((Object)expectedHTML, (Object)actualHTML);
    }

    @Test
    public void testRefreshDocumentationHTMLAfter200ms() {
        ((DMNDocumentationView)Mockito.doNothing().when((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        this.view.refreshDocumentationHTMLAfter200ms();
        ((DMNDocumentationView)Mockito.verify((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)this.callback.capture(), ArgumentMatchers.eq((int)200));
        ((DomGlobal.SetTimeoutCallbackFn)this.callback.getValue()).onInvoke(new Object[]{new Object()});
        ((DMNDocumentationView)Mockito.verify((Object)this.view)).refreshDocumentationHTML();
    }

    @Test
    public void testIsEnabled() {
        Assert.assertTrue((boolean)this.view.isEnabled());
    }

    @Test
    public void testOnPrintButtonClick() {
        this.view.onPrintButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((PrintHelper)Mockito.verify((Object)this.printHelper)).print((HTMLElement)this.documentationContent);
    }

    @Test
    public void testOnDownloadHtmlFile() {
        String html = "<html><body>Hi</body></html>";
        String modelName = "model name";
        ((DMNDocumentationView)Mockito.doReturn((Object)"model name").when((Object)this.view)).getCurrentDocumentationModelName();
        ((DMNDocumentationView)Mockito.doReturn((Object)"<html><body>Hi</body></html>").when((Object)this.view)).getCurrentDocumentationHTML();
        this.view.onDownloadHtmlFile((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DMNDocumentationView)Mockito.verify((Object)this.view)).getCurrentDocumentationHTML();
        ((HTMLDownloadHelper)Mockito.verify((Object)this.downloadHelper)).download("model name", "<html><body>Hi</body></html>");
    }
}

