/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder;
import org.kie.workbench.common.dmn.client.editors.documentation.DocumentationLinkItem;
import org.kie.workbench.common.dmn.client.editors.documentation.DocumentationLinksWidget;
import org.kie.workbench.common.dmn.client.editors.documentation.links.NameAndUrlPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.PopupEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocumentationLinksWidgetTest {
    @Mock
    private HTMLDivElement linksContainer;
    @Mock
    private HTMLDivElement noneContainer;
    @Mock
    private HTMLAnchorElement addButton;
    @Mock
    private HTMLElement addLink;
    @Mock
    private HTMLElement noLink;
    @Mock
    private CellEditorControlsView cellEditor;
    @Mock
    private ManagedInstance<DocumentationLinkItem> listItems;
    @Mock
    private NameAndUrlPopoverView.Presenter nameAndUrlPopover;
    @Mock
    private TranslationService translationService;
    @Mock
    private DOMTokenList noneContainerClassList;
    @Mock
    private DOMTokenList addButtonClassList;
    @Mock
    private EventSourceMock<LockRequiredEvent> locker;
    @Mock
    private DOMTokenList linksContainerClassList;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    private DocumentationLinksWidget widget;

    @Before
    public void setup() {
        this.noneContainer.classList = this.noneContainerClassList;
        this.linksContainer.classList = this.linksContainerClassList;
        this.addButton.classList = this.addButtonClassList;
        this.widget = (DocumentationLinksWidget)Mockito.spy((Object)new DocumentationLinksWidget(this.listItems, this.translationService, this.linksContainer, this.noneContainer, this.addButton, this.nameAndUrlPopover, this.cellEditor, this.addLink, this.noLink, this.locker, this.readOnlyProvider));
    }

    @Test
    public void testOnClickTypeButton() {
        int x = 111;
        int y = 222;
        ClickEvent clickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        Mockito.when((Object)clickEvent.getClientX()).thenReturn((Object)111);
        Mockito.when((Object)clickEvent.getClientY()).thenReturn((Object)222);
        this.widget.onClickTypeButton(clickEvent);
        ((CellEditorControlsView)Mockito.verify((Object)this.cellEditor)).show((PopupEditorControls)this.nameAndUrlPopover, 111, 222);
    }

    @Test
    public void testSetDMNModel() {
        DocumentationLinksHolder holder = (DocumentationLinksHolder)Mockito.mock(DocumentationLinksHolder.class);
        DocumentationLinks value = (DocumentationLinks)Mockito.mock(DocumentationLinks.class);
        Mockito.when((Object)holder.getValue()).thenReturn((Object)value);
        DRGElement model = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)model.getLinksHolder()).thenReturn((Object)holder);
        this.widget.setDMNModel(model);
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).setValue(value);
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).refresh();
    }

    @Test
    public void testRefresh() {
        DocumentationLinks value = (DocumentationLinks)Mockito.mock(DocumentationLinks.class);
        DMNExternalLink externalLink = (DMNExternalLink)Mockito.mock(DMNExternalLink.class);
        ArrayList<DMNExternalLink> links = new ArrayList<DMNExternalLink>();
        links.add(externalLink);
        DocumentationLinkItem listItem = (DocumentationLinkItem)Mockito.mock(DocumentationLinkItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)listItem.getElement()).thenReturn((Object)element);
        Mockito.when((Object)((DocumentationLinkItem)this.listItems.get())).thenReturn((Object)listItem);
        this.widget.setValue(value);
        Mockito.when((Object)value.getLinks()).thenReturn(links);
        this.widget.refresh();
        ((DocumentationLinkItem)Mockito.verify((Object)listItem)).init(externalLink);
        ((HTMLDivElement)Mockito.verify((Object)this.linksContainer)).appendChild((Node)element);
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).refreshContainersVisibility();
    }

    @Test
    public void testRefreshContainersVisibility() {
        DocumentationLinks value = (DocumentationLinks)Mockito.mock(DocumentationLinks.class);
        DMNExternalLink externalLink = (DMNExternalLink)Mockito.mock(DMNExternalLink.class);
        ArrayList<DMNExternalLink> links = new ArrayList<DMNExternalLink>();
        links.add(externalLink);
        Mockito.when((Object)value.getLinks()).thenReturn(links);
        this.widget.setValue(value);
        this.widget.refreshContainersVisibility();
        ((DOMTokenList)Mockito.verify((Object)this.noneContainerClassList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.linksContainerClassList)).remove(new String[]{"hidden"});
        links.clear();
        this.widget.refreshContainersVisibility();
        ((DOMTokenList)Mockito.verify((Object)this.noneContainerClassList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.linksContainerClassList)).add(new String[]{"hidden"});
    }

    @Test
    public void testOnExternalLinkDeleted() {
        DocumentationLinks value = (DocumentationLinks)Mockito.mock(DocumentationLinks.class);
        DMNExternalLink externalLink = (DMNExternalLink)Mockito.mock(DMNExternalLink.class);
        ArrayList<DMNExternalLink> links = new ArrayList<DMNExternalLink>();
        links.add(externalLink);
        Mockito.when((Object)value.getLinks()).thenReturn(links);
        this.widget.setValue(value);
        this.widget.onExternalLinkDeleted(externalLink);
        Assert.assertFalse((boolean)links.contains(externalLink));
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).refresh();
        ((EventSourceMock)Mockito.verify(this.locker)).fire((Object)((LockRequiredEvent)ArgumentMatchers.any()));
    }

    @Test
    public void testOnDMNExternalLinkCreated() {
        DMNExternalLink createdLink = (DMNExternalLink)Mockito.mock(DMNExternalLink.class);
        DocumentationLinks value = (DocumentationLinks)Mockito.mock(DocumentationLinks.class);
        this.widget.setValue(value);
        this.widget.onDMNExternalLinkCreated(createdLink);
        ((DocumentationLinks)Mockito.verify((Object)value)).addLink(createdLink);
        ((EventSourceMock)Mockito.verify(this.locker)).fire((Object)((LockRequiredEvent)ArgumentMatchers.any()));
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).refresh();
    }

    @Test
    public void testInit() {
        String addText = "add";
        String noLinkText = "no link text";
        Mockito.when((Object)this.translationService.getTranslation("DMNDocumentationI18n.Add")).thenReturn((Object)"add");
        Mockito.when((Object)this.translationService.getTranslation("DMNDocumentationI18n.None")).thenReturn((Object)"no link text");
        this.widget.init();
        Assert.assertEquals((Object)this.addLink.textContent, (Object)"add");
        Assert.assertEquals((Object)this.noLink.textContent, (Object)"no link text");
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).setupAddButtonReadOnlyStatus();
    }

    @Test
    public void testSetupAddButtonReadOnlyStatusWhenIsReadOnly() {
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        this.widget.setupAddButtonReadOnlyStatus();
        ((DOMTokenList)Mockito.verify((Object)this.addButtonClassList)).add(new String[]{"read-only"});
        ((DOMTokenList)Mockito.verify((Object)this.addButtonClassList, (VerificationMode)Mockito.never())).remove(new String[]{"read-only"});
    }

    @Test
    public void testSetupAddButtonReadOnlyStatusWhenIsNotReadOnly() {
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)false);
        this.widget.setupAddButtonReadOnlyStatus();
        ((DOMTokenList)Mockito.verify((Object)this.addButtonClassList, (VerificationMode)Mockito.never())).add(new String[]{"read-only"});
        ((DOMTokenList)Mockito.verify((Object)this.addButtonClassList)).remove(new String[]{"read-only"});
    }
}

