/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.drd;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLAnchorElement;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.gwtbootstrap3.client.ui.html.Span;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChangerView;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DRDNameChangerViewTest {
    private DRDNameChangerView drdNameChangerView;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private Event<DMNDiagramSelected> selectedEvent;
    @Mock
    private DivElement viewMode;
    @Mock
    private DivElement editMode;
    @Mock
    private HTMLAnchorElement returnToDRG;
    @Mock
    private Span drdName;
    @Mock
    private InputElement drdNameInput;
    @Mock
    private SessionPresenter.View sessionPresenterView;
    @Mock
    private DMNDiagramSelected dmnDiagramSelected;
    @Mock
    private DMNDiagramElement dmnDiagramElement;
    @Mock
    private Style style;
    @Mock
    private ClickEvent clickEvent;
    @Mock
    private KeyDownEvent keyDownEvent;
    @Mock
    private BlurEvent blurEvent;

    @Before
    public void setUp() {
        Mockito.when((Object)this.editMode.getStyle()).thenReturn((Object)this.style);
        Mockito.when((Object)this.viewMode.getStyle()).thenReturn((Object)this.style);
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentDMNDiagramElement()).thenReturn(Optional.empty());
        this.drdNameChangerView = new DRDNameChangerView(this.dmnDiagramsSession, this.selectedEvent, this.viewMode, this.editMode, this.returnToDRG, this.drdName, this.drdNameInput);
        this.drdNameChangerView.setSessionPresenterView(this.sessionPresenterView);
    }

    @Test
    public void testOnSettingCurrentDMNDiagramWhenIsGlobal() {
        Mockito.when((Object)this.dmnDiagramsSession.isGlobalGraphSelected()).thenReturn((Object)true);
        this.drdNameChangerView.onSettingCurrentDMNDiagramElement(this.dmnDiagramSelected);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.times((int)2))).isGlobalGraphSelected();
    }

    @Test
    public void testOnSettingCurrentDMNDiagramWhenIsDRD() {
        Mockito.when((Object)this.dmnDiagramsSession.isGlobalGraphSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.dmnDiagramSelected.getDiagramElement()).thenReturn((Object)this.dmnDiagramElement);
        Mockito.when((Object)this.dmnDiagramElement.getName()).thenReturn((Object)new Name());
        this.drdNameChangerView.onSettingCurrentDMNDiagramElement(this.dmnDiagramSelected);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.times((int)2))).isGlobalGraphSelected();
    }

    @Test
    public void testOnClickReturnToDRG() {
        this.drdNameChangerView.onClickReturnToDRG(this.clickEvent);
        ((Event)Mockito.verify(this.selectedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((DMNDiagramSelected)ArgumentMatchers.any(DMNDiagramSelected.class)));
    }

    @Test
    public void testEnableEdit() {
        String spanText = "SPAN TEXT";
        Mockito.when((Object)this.drdName.getText()).thenReturn((Object)"SPAN TEXT");
        this.drdNameChangerView.enableEdit(this.clickEvent);
        ((InputElement)Mockito.verify((Object)this.drdNameInput, (VerificationMode)Mockito.times((int)1))).setValue("SPAN TEXT");
        ((InputElement)Mockito.verify((Object)this.drdNameInput, (VerificationMode)Mockito.times((int)1))).focus();
    }

    @Test
    public void testOnInputTextKeyPress() {
        NativeEvent nativeEvent = (NativeEvent)Mockito.mock(NativeEvent.class);
        Mockito.when((Object)this.keyDownEvent.getNativeEvent()).thenReturn((Object)nativeEvent);
        Mockito.when((Object)nativeEvent.getKeyCode()).thenReturn((Object)13);
        this.drdNameChangerView.onInputTextKeyPress(this.keyDownEvent);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.times((int)1))).getCurrentDMNDiagramElement();
    }

    @Test
    public void testOnInputTextBlur() {
        this.drdNameChangerView.onInputTextBlur(this.blurEvent);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.times((int)1))).getCurrentDMNDiagramElement();
    }

    @Test
    public void testSaveForTheCurrentDiagram() {
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentDMNDiagramElement()).thenReturn(Optional.of(this.dmnDiagramElement));
        Mockito.when((Object)this.dmnDiagramElement.getName()).thenReturn((Object)new Name());
        this.drdNameChangerView.saveForTheCurrentDiagram();
        ((InputElement)Mockito.verify((Object)this.drdNameInput, (VerificationMode)Mockito.times((int)1))).getValue();
        ((Event)Mockito.verify(this.selectedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((DMNDiagramSelected)ArgumentMatchers.any(DMNDiagramSelected.class)));
    }
}

