/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseContextUIModelMapperTest<M extends ContextUIModelMapper> {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private NameColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    protected LiteralExpressionGrid literalExpressionEditor;
    @Mock
    private UndefinedExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    protected BaseExpressionGrid undefinedExpressionEditor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    @Mock
    protected Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    protected ListSelectorView.Presenter listSelector;
    @Mock
    protected GridWidget gridWidget;
    @Captor
    private ArgumentCaptor<GridCellTuple> parentCaptor;
    protected BaseGridData uiModel;
    protected Context context;
    protected M mapper;

    public void setup(boolean isOnlyVisualChangeAllowedSupplier) {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        Mockito.when((Object)this.uiRowNumberColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiNameColumn.getIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.uiExpressionEditorColumn.getIndex()).thenReturn((Object)2);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditor.getExpression()).thenReturn(() -> Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.undefinedExpressionEditor));
        this.context = new Context();
        this.context.getContextEntry().add(new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("ii1"));
                    }
                });
            }
        });
        this.context.getContextEntry().add(new ContextEntry(){
            {
                this.setExpression((Expression)new LiteralExpression());
            }
        });
        this.mapper = this.getMapper(isOnlyVisualChangeAllowedSupplier);
        this.cellValueSupplier = Optional::empty;
    }

    protected abstract M getMapper(boolean var1);

    @Test
    public void testFromDMNModelUndefinedExpression() {
        this.setup(false);
        this.mapper.fromDMNModel(0, 2);
        this.assertFromDMNModelUndefinedExpression(false);
    }

    @Test
    public void testFromDMNModelUndefinedExpressionWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.mapper.fromDMNModel(0, 2);
        this.assertFromDMNModelUndefinedExpression(true);
    }

    private void assertFromDMNModelUndefinedExpression(boolean isOnlyVisualChangeAllowed) {
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 2).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv0 = (ExpressionCellValue)this.uiModel.getCell(0, 2).getValue();
        Assert.assertEquals((Object)this.undefinedExpressionEditor, ((Optional)dcv0.getValue()).get());
        ((UndefinedExpressionEditorDefinition)Mockito.verify((Object)this.undefinedExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)ArgumentMatchers.eq(Optional.empty()), (HasExpression)ArgumentMatchers.eq((Object)((ContextEntry)this.context.getContextEntry().get(0))), (Optional)ArgumentMatchers.eq(Optional.of(((ContextEntry)this.context.getContextEntry().get(0)).getVariable())), ArgumentMatchers.eq((boolean)isOnlyVisualChangeAllowed), ArgumentMatchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)2L, (long)parent.getColumnIndex());
        Assert.assertEquals((Object)this.gridWidget, (Object)parent.getGridWidget());
    }

    @Test
    public void testFromDMNModelLiteralExpression() {
        this.setup(false);
        this.mapper.fromDMNModel(1, 2);
        this.assertFromDMNModelLiteralExpression(false);
    }

    @Test
    public void testFromDMNModelLiteralExpressionWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.mapper.fromDMNModel(1, 2);
        this.assertFromDMNModelLiteralExpression(true);
    }

    private void assertFromDMNModelLiteralExpression(boolean isOnlyVisualChangeAllowed) {
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 2).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv1 = (ExpressionCellValue)this.uiModel.getCell(1, 2).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv1.getValue()).get());
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)ArgumentMatchers.eq(Optional.empty()), (HasExpression)ArgumentMatchers.eq((Object)((ContextEntry)this.context.getContextEntry().get(1))), (Optional)ArgumentMatchers.eq(Optional.empty()), ArgumentMatchers.eq((boolean)isOnlyVisualChangeAllowed), ArgumentMatchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)parent.getRowIndex());
        Assert.assertEquals((long)2L, (long)parent.getColumnIndex());
        Assert.assertEquals((Object)this.gridWidget, (Object)parent.getGridWidget());
    }

    @Test
    public void testToDMNModelName() {
        this.setup(false);
        this.cellValueSupplier = () -> Optional.of(new BaseGridCellValue((Object)"ii2"));
        this.mapper.toDMNModel(0, 1, this.cellValueSupplier);
        Assert.assertEquals((Object)"ii2", (Object)((ContextEntry)this.context.getContextEntry().get(0)).getVariable().getName().getValue());
    }

    @Test
    public void testToDMNModelExpression() {
        this.setup(false);
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        this.mapper.toDMNModel(0, 2, this.cellValueSupplier);
        Assert.assertEquals((Object)this.literalExpression, (Object)((ContextEntry)this.context.getContextEntry().get(0)).getExpression());
    }
}

