/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddDecisionRuleCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddInputClauseCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddOutputClauseCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.DeleteDecisionRuleCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.DeleteInputClauseCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.DeleteOutputClauseCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.SetBuiltinAggregatorCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.SetHitPolicyCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.expressions.types.GridFactoryCommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableEditorDefinitionEnricher;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableRowNumberColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumnExpressionNameHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.RowNumberColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.RuleAnnotationClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.RuleAnnotationClauseColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;
import org.kie.workbench.common.dmn.client.editors.types.HasValueAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.ValueAndDataTypeHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DecisionTableGridTest {
    private static final int RULE_HEADER = 0;
    private static final int DEFAULT_INSERT_RULE_ABOVE = 1;
    private static final int DEFAULT_INSERT_RULE_BELOW = 2;
    private static final int DEFAULT_DELETE_RULE = 3;
    private static final int DEFAULT_DUPLICATE_RULE = 4;
    private static final int COLUMN_HEADER = 0;
    private static final int INSERT_COLUMN_BEFORE = 1;
    private static final int INSERT_COLUMN_AFTER = 2;
    private static final int DELETE_COLUMN = 3;
    private static final int DIVIDER = 4;
    private static final String INPUT_CLAUSE_NAME = "input-1";
    private static final String OUTPUT_CLAUSE_NAME1 = "output-1";
    private static final String OUTPUT_CLAUSE_NAME2 = "output-2";
    private static final String NAME_NEW = "name-new";
    private static final String HASNAME_NAME = "name";
    private static final String NODE_UUID = "uuid";
    private static final int DEFAULT_ROW_NUMBER_COLUMN_INDEX = 0;
    private static final int DEFAULT_INPUT_CLAUSE_COLUMN_INDEX = 1;
    private static final int DEFAULT_OUTPUT_CLAUSE_COLUMN_INDEX = 2;
    private static final int DEFAULT_DESCRIPTION_COLUMN_INDEX = 3;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private AbsolutePanel gridLayerDomElementContainer;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private UpdateElementPropertyCommand updateElementPropertyCommand;
    @Mock
    private DMNSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private Index index;
    @Mock
    private Element element;
    @Mock
    private GraphCommandExecutionContext graphCommandContext;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private HitPolicyPopoverView.Presenter hitPolicyEditor;
    @Mock
    private ManagedInstance<ValueAndDataTypePopoverView.Presenter> headerEditors;
    @Mock
    private ValueAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private GridColumn parentGridColumn;
    @Mock
    private Command command;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private GridBodyCellEditContext gridBodyCellEditContext;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Captor
    private ArgumentCaptor<AddInputClauseCommand> addInputClauseCommandCaptor;
    @Captor
    private ArgumentCaptor<AddOutputClauseCommand> addOutputClauseCommandCaptor;
    @Captor
    private ArgumentCaptor<DeleteInputClauseCommand> deleteInputClauseCommandCaptor;
    @Captor
    private ArgumentCaptor<DeleteOutputClauseCommand> deleteOutputClauseCommandCaptor;
    @Captor
    private ArgumentCaptor<AddDecisionRuleCommand> addDecisionRuleCommandCaptor;
    @Captor
    private ArgumentCaptor<DeleteDecisionRuleCommand> deleteDecisionRuleCommandCaptor;
    @Captor
    private ArgumentCaptor<CompositeCommand<AbstractCanvasHandler, CanvasViolation>> setHitPolicyCommandCaptor;
    @Captor
    private ArgumentCaptor<SetBuiltinAggregatorCommand> setBuiltInAggregatorCommandCaptor;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCommandCaptor;
    @Captor
    private ArgumentCaptor<CompositeCommand> compositeCommandCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    private GridCellTuple parent;
    private Decision hasExpression = new Decision();
    private Optional<DecisionTable> expression = Optional.empty();
    private DecisionTableEditorDefinition definition;
    private DecisionTableGrid grid;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.definition = new DecisionTableEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.hitPolicyEditor, this.headerEditors, new DecisionTableEditorDefinitionEnricher(this.sessionManager, new DMNGraphUtils(this.sessionManager, this.dmnDiagramUtils, this.dmnDiagramsSession), this.itemDefinitionUtils), this.readOnlyProvider);
        this.expression = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.hasExpression, this.expression);
        Mockito.when((Object)((AbstractCanvasHandler)this.session.getCanvasHandler())).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphCommandContext);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
        Mockito.when((Object)this.parentGridData.getColumns()).thenReturn(Collections.singletonList(this.parentGridColumn));
        this.parent = (GridCellTuple)Mockito.spy((Object)new GridCellTuple(0, 0, this.parentGridWidget));
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.gridLayer.getDomElementContainer()).thenReturn((Object)this.gridLayerDomElementContainer);
        Mockito.when((Object)this.gridLayerDomElementContainer.iterator()).thenReturn((Object)((Iterator)Mockito.mock(Iterator.class)));
        Mockito.when((Object)this.gridLayer.getVisibleBounds()).thenReturn((Object)new BaseBounds(0.0, 0.0, 1000.0, 2000.0));
        Mockito.when((Object)this.gridLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.index);
        Mockito.when((Object)this.index.get((String)Mockito.any())).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getContent()).thenReturn(Mockito.mock(Definition.class));
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(ArgumentMatchers.any())).thenReturn((Object)HASNAME_NAME);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)ArgumentMatchers.any(Element.class), (String)Mockito.any(), ArgumentMatchers.any())).thenReturn((Object)this.updateElementPropertyCommand);
        Mockito.when((Object)this.updateElementPropertyCommand.execute(this.canvasHandler)).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        Mockito.when((Object)((ValueAndDataTypePopoverView.Presenter)this.headerEditors.get())).thenReturn((Object)this.headerEditor);
        Mockito.when((Object)this.gridBodyCellEditContext.getRelativeLocation()).thenReturn(Optional.empty());
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format((String)Mockito.any(), new Object[0]);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation((String)Mockito.any());
    }

    private void setupGrid(Optional<HasName> hasName, int nesting) {
        this.hasExpression.setExpression((Expression)this.expression.get());
        this.grid = (DecisionTableGrid)Mockito.spy((Object)((DecisionTableGrid)this.definition.getEditor(this.parent, nesting == 0 ? Optional.of(NODE_UUID) : Optional.empty(), (HasExpression)this.hasExpression, hasName, false, nesting).get()));
    }

    private Optional<HasName> makeHasNameForDecision() {
        this.hasExpression.setName(new Name(HASNAME_NAME));
        return Optional.of(this.hasExpression);
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof DecisionTableGridData));
        Assert.assertEquals((long)4L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(0) instanceof DecisionTableRowNumberColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(1) instanceof InputClauseColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(2) instanceof OutputClauseColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(3) instanceof RuleAnnotationClauseColumn));
        Assert.assertEquals((long)1L, (long)uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"-", (Object)uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)uiModel.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)uiModel.getCell(0, 3).getValue().getValue());
    }

    @Test
    public void testInitialColumnWidthsFromDefinition() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.assertComponentWidths(50.0, 100.0, 100.0, 100.0);
    }

    @Test
    public void testInitialColumnWidthsFromExpression() {
        List componentWidths = this.expression.get().getComponentWidths();
        componentWidths.set(0, 100.0);
        componentWidths.set(1, 200.0);
        componentWidths.set(2, 300.0);
        componentWidths.set(3, 400.0);
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.assertComponentWidths(100.0, 200.0, 300.0, 400.0);
    }

    private void assertComponentWidths(double ... widths) {
        GridData uiModel = this.grid.getModel();
        IntStream.range(0, widths.length).forEach(i -> Assert.assertEquals((double)widths[i], (double)((GridColumn)uiModel.getColumns().get(i)).getWidth(), (double)0.0));
    }

    @Test
    public void testCacheable() {
        this.setupGrid(Optional.empty(), 0);
        Assert.assertTrue((boolean)this.grid.isCacheable());
    }

    @Test
    public void testColumn0MetaData() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(0);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof RowNumberColumnHeaderMetaData));
        RowNumberColumnHeaderMetaData md = (RowNumberColumnHeaderMetaData)header.get(0);
        this.expression.get().setHitPolicy(HitPolicy.FIRST);
        Assert.assertEquals((Object)"F", (Object)md.getTitle());
        this.expression.get().setHitPolicy(HitPolicy.ANY);
        Assert.assertEquals((Object)"A", (Object)md.getTitle());
    }

    @Test
    public void testColumn1MetaData() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(1);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof InputClauseColumnHeaderMetaData));
        InputClauseColumnHeaderMetaData md = (InputClauseColumnHeaderMetaData)header.get(0);
        Assert.assertEquals((Object)INPUT_CLAUSE_NAME, (Object)md.getTitle());
    }

    @Test
    public void testColumn2MetaData() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(2);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof OutputClauseColumnExpressionNameHeaderMetaData));
        OutputClauseColumnExpressionNameHeaderMetaData md = (OutputClauseColumnExpressionNameHeaderMetaData)header.get(0);
        Assert.assertEquals((Object)HASNAME_NAME, (Object)md.getTitle());
    }

    @Test
    public void testColumn2MetaDataWithoutHasName() {
        this.setupGrid(Optional.empty(), 0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(2);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof OutputClauseColumnHeaderMetaData));
        OutputClauseColumnHeaderMetaData md = (OutputClauseColumnHeaderMetaData)header.get(0);
        Assert.assertEquals((Object)OUTPUT_CLAUSE_NAME1, (Object)md.getTitle());
    }

    @Test
    public void testColumn3MetaData() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(3);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof RuleAnnotationClauseColumnHeaderMetaData));
        RuleAnnotationClauseColumnHeaderMetaData md = (RuleAnnotationClauseColumnHeaderMetaData)header.get(0);
        Assert.assertEquals((Object)"annotation-1", (Object)md.getTitle());
    }

    @Test
    public void testGetItemsRowNumberColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.assertDefaultListItems(this.grid.getItems(0, 0), true);
    }

    @Test
    public void testGetItemsInputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        List items = this.grid.getItems(0, 1);
        Assertions.assertThat((int)items.size()).isEqualTo(10);
        this.assertInputClauseItems(items.subList(0, 4));
        this.assertDefaultListItems(items.subList(5, 10), true);
    }

    @Test
    public void testGetItemsOutputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        List items = this.grid.getItems(0, 2);
        Assertions.assertThat((int)items.size()).isEqualTo(10);
        this.assertOutputClauseItems(items.subList(0, 4));
        this.assertDefaultListItems(items.subList(5, 10), true);
    }

    @Test
    public void testGetItemsRuleAnnotationColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        List items = this.grid.getItems(0, 3);
        Assertions.assertThat((int)items.size()).isEqualTo(10);
        this.assertRuleAnnotationClauseItems(items.subList(0, 4));
        this.assertDefaultListItems(items.subList(5, 10), true);
    }

    @Test
    public void testGetHeaderItemsInputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.assertInputClauseItems(this.grid.getHeaderItems(0, 1));
    }

    @Test
    public void testGetHeaderItemsOutputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.assertOutputClauseItems(this.grid.getHeaderItems(0, 2));
    }

    @Test
    public void testGetHeaderItemsOutputClauseColumnWithMultipleOutputClausesHeaderRow0() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addOutputClause(2);
        List items = this.grid.getHeaderItems(0, 2);
        Assertions.assertThat((int)items.size()).isEqualTo(3);
        this.assertListSelectorHeaderItem((HasListSelectorControl.ListSelectorItem)items.get(0), "DecisionTableEditor.OutputClauseHeader");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(1), "DecisionTableEditor.InsertOutputClauseLeft", true);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(2), "DecisionTableEditor.InsertOutputClauseRight", true);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)items.get(1));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid, (VerificationMode)Mockito.times((int)2))).addOutputClause(ArgumentMatchers.eq((int)2));
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)items.get(2));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addOutputClause(ArgumentMatchers.eq((int)5));
    }

    @Test
    public void testGetHeaderItemsOutputClauseColumnWithMultipleOutputClausesHeaderRow1() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addOutputClause(2);
        List items = this.grid.getHeaderItems(1, 2);
        Assertions.assertThat((int)items.size()).isEqualTo(4);
        this.assertListSelectorHeaderItem((HasListSelectorControl.ListSelectorItem)items.get(0), "DecisionTableEditor.OutputClauseHeader");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(1), "DecisionTableEditor.InsertOutputClauseLeft", true);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(2), "DecisionTableEditor.InsertOutputClauseRight", true);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(3), "DecisionTableEditor.DeleteOutputClause", true);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)items.get(1));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid, (VerificationMode)Mockito.times((int)2))).addOutputClause(ArgumentMatchers.eq((int)2));
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)items.get(2));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addOutputClause(ArgumentMatchers.eq((int)3));
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)items.get(3));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).deleteOutputClause(ArgumentMatchers.eq((int)2));
    }

    @Test
    public void testGetItemsWithCellSelectionsCoveringMultipleRows() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addDecisionRule(0);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(1, 0);
        this.assertDefaultListItems(this.grid.getItems(0, 0), false);
    }

    @Test
    public void testGetItemsInputClauseColumnWithCellSelectionsCoveringMultipleColumns() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addInputClause(1);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(0, 1);
        List items = this.grid.getItems(0, 1);
        Assertions.assertThat((int)items.size()).isEqualTo(10);
        this.assertDefaultListItems(items.subList(5, 10), true);
        this.assertListSelectorHeaderItem((HasListSelectorControl.ListSelectorItem)items.get(0), "DecisionTableEditor.InputClauseHeader");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(1), "DecisionTableEditor.InsertInputClauseLeft", false);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(2), "DecisionTableEditor.InsertInputClauseRight", false);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(3), "DecisionTableEditor.DeleteInputClause", false);
        Assertions.assertThat((Object)((HasListSelectorControl.ListSelectorItem)items.get(4))).isInstanceOf(HasListSelectorControl.ListSelectorDividerItem.class);
    }

    @Test
    public void testGetItemsOutputClauseColumnWithCellSelectionsCoveringMultipleColumns() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addOutputClause(2);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(0, 2);
        List items = this.grid.getItems(0, 2);
        Assertions.assertThat((int)items.size()).isEqualTo(10);
        this.assertDefaultListItems(items.subList(5, 10), true);
        this.assertListSelectorHeaderItem((HasListSelectorControl.ListSelectorItem)items.get(0), "DecisionTableEditor.OutputClauseHeader");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(1), "DecisionTableEditor.InsertOutputClauseLeft", false);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(2), "DecisionTableEditor.InsertOutputClauseRight", false);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(3), "DecisionTableEditor.DeleteOutputClause", false);
        Assertions.assertThat((Object)((HasListSelectorControl.ListSelectorItem)items.get(4))).isInstanceOf(HasListSelectorControl.ListSelectorDividerItem.class);
    }

    private void assertInputClauseItems(List<HasListSelectorControl.ListSelectorItem> items) {
        Assertions.assertThat((int)items.size()).isEqualTo(4);
        this.assertListSelectorHeaderItem(items.get(0), "DecisionTableEditor.InputClauseHeader");
        this.assertListSelectorTextItem(items.get(1), "DecisionTableEditor.InsertInputClauseLeft", true);
        this.assertListSelectorTextItem(items.get(2), "DecisionTableEditor.InsertInputClauseRight", true);
        this.assertListSelectorTextItem(items.get(3), "DecisionTableEditor.DeleteInputClause", false);
        this.grid.onItemSelected(items.get(1));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addInputClause(ArgumentMatchers.eq((int)1));
        this.grid.onItemSelected(items.get(2));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addInputClause(ArgumentMatchers.eq((int)2));
        this.grid.onItemSelected(items.get(3));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).deleteInputClause(ArgumentMatchers.eq((int)1));
    }

    private void assertRuleAnnotationClauseItems(List<HasListSelectorControl.ListSelectorItem> items) {
        Assertions.assertThat((int)items.size()).isEqualTo(4);
        this.assertListSelectorHeaderItem(items.get(0), "DecisionTableEditor.RuleAnnotationClauseHeader");
        this.assertListSelectorTextItem(items.get(1), "DecisionTableEditor.InsertRuleAnnotationClauseLeft", true);
        this.assertListSelectorTextItem(items.get(2), "DecisionTableEditor.InsertRuleAnnotationClauseRight", true);
        this.assertListSelectorTextItem(items.get(3), "DecisionTableEditor.DeleteRuleAnnotationClause", false);
        this.grid.onItemSelected(items.get(1));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addRuleAnnotationClause(ArgumentMatchers.eq((int)3));
        this.grid.onItemSelected(items.get(2));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addRuleAnnotationClause(ArgumentMatchers.eq((int)4));
        this.grid.onItemSelected(items.get(3));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).deleteRuleAnnotationClause(ArgumentMatchers.eq((int)3));
    }

    private void assertOutputClauseItems(List<HasListSelectorControl.ListSelectorItem> items) {
        Assertions.assertThat((int)items.size()).isEqualTo(4);
        this.assertListSelectorHeaderItem(items.get(0), "DecisionTableEditor.OutputClauseHeader");
        this.assertListSelectorTextItem(items.get(1), "DecisionTableEditor.InsertOutputClauseLeft", true);
        this.assertListSelectorTextItem(items.get(2), "DecisionTableEditor.InsertOutputClauseRight", true);
        this.assertListSelectorTextItem(items.get(3), "DecisionTableEditor.DeleteOutputClause", false);
        this.grid.onItemSelected(items.get(1));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addOutputClause(ArgumentMatchers.eq((int)2));
        this.grid.onItemSelected(items.get(2));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addOutputClause(ArgumentMatchers.eq((int)3));
        this.grid.onItemSelected(items.get(3));
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).deleteOutputClause(ArgumentMatchers.eq((int)2));
    }

    private void assertDefaultListItems(List<HasListSelectorControl.ListSelectorItem> items, boolean enabled) {
        Assertions.assertThat((int)items.size()).isEqualTo(5);
        this.assertListSelectorHeaderItem(items.get(0), "DecisionTableEditor.DecisionRuleHeader");
        this.assertListSelectorTextItem(items.get(1), "DecisionTableEditor.InsertDecisionRuleAbove", enabled);
        this.assertListSelectorTextItem(items.get(2), "DecisionTableEditor.InsertDecisionRuleBelow", enabled);
        this.assertListSelectorTextItem(items.get(3), "DecisionTableEditor.DeleteDecisionRule", enabled && this.grid.getModel().getRowCount() > 1);
        this.assertListSelectorTextItem(items.get(4), "DecisionTableEditor.DuplicateDecisionRule", enabled);
    }

    private void assertListSelectorHeaderItem(HasListSelectorControl.ListSelectorItem item, String text) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorHeaderItem.class);
        HasListSelectorControl.ListSelectorHeaderItem hi = (HasListSelectorControl.ListSelectorHeaderItem)item;
        Assertions.assertThat((String)hi.getText()).isEqualTo(text);
    }

    private void assertListSelectorTextItem(HasListSelectorControl.ListSelectorItem item, String text, boolean enabled) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorTextItem.class);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
        Assertions.assertThat((String)ti.getText()).isEqualTo(text);
        Assertions.assertThat((boolean)ti.isEnabled()).isEqualTo(enabled);
    }

    @Test
    public void testOnItemSelected() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testOnItemSelectedInsertRowAbove() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(1);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addDecisionRule(ArgumentMatchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedInsertRowBelow() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(2);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).addDecisionRule(ArgumentMatchers.eq((int)1));
    }

    @Test
    public void testOnItemSelectedDeleteRow() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(3);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).deleteDecisionRule(ArgumentMatchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedDuplicateRow() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(4);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).duplicateDecisionRule(ArgumentMatchers.eq((int)0));
    }

    @Test
    public void testAddInputClause() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addInputClause(1);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).selectHeaderCell(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        this.verifyEditHeaderCell(InputClauseColumnHeaderMetaData.class, 0, 1);
        Mockito.reset((Object[])new Object[]{this.gridPanel, this.gridLayer, this.grid, this.parentGridColumn});
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.addInputClauseCommandCaptor.capture());
        ((AddInputClauseCommand)this.addInputClauseCommandCaptor.getValue()).undo(this.canvasHandler);
        this.verifyCommandUndoOperation(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
    }

    private void addInputClause(int index) {
        this.mockInsertColumnCommandExecution();
        this.grid.addInputClause(index);
    }

    private void mockInsertColumnCommandExecution() {
        Mockito.when((Object)this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)ArgumentMatchers.any(AbstractCanvasGraphCommand.class))).thenAnswer(i -> {
            AbstractCanvasHandler handler = (AbstractCanvasHandler)i.getArguments()[0];
            org.kie.workbench.common.stunner.core.command.Command command = (org.kie.workbench.common.stunner.core.command.Command)i.getArguments()[1];
            return command.execute((Object)handler);
        });
    }

    private void verifyCommandExecuteOperation(Function<BaseExpressionGrid, Double> resizeFunction) {
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(ArgumentMatchers.eq((double)(this.grid.getWidth() + this.grid.getPadding() * 2.0)), (Function)ArgumentMatchers.eq(resizeFunction));
        ((GridColumn)Mockito.verify((Object)this.parentGridColumn)).setWidth(this.grid.getWidth() + this.grid.getPadding() * 2.0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    private void verifyCommandUndoOperation(Function<BaseExpressionGrid, Double> resizeFunction) {
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(ArgumentMatchers.eq((double)(this.grid.getWidth() + this.grid.getPadding() * 2.0)), (Function)ArgumentMatchers.eq(resizeFunction));
        ((GridColumn)Mockito.verify((Object)this.parentGridColumn)).setWidth(this.grid.getWidth() + this.grid.getPadding() * 2.0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        Assertions.assertThat((List)this.redrawCommandCaptor.getAllValues()).hasSize(2);
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getAllValues().get(1)).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testDeleteInputClause() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.deleteInputClause(1);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.deleteInputClauseCommandCaptor.capture());
        DeleteInputClauseCommand deleteInputClauseCommand = (DeleteInputClauseCommand)this.deleteInputClauseCommandCaptor.getValue();
        deleteInputClauseCommand.execute(this.canvasHandler);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        Mockito.reset((Object[])new Object[]{this.gridPanel, this.gridLayer, this.grid, this.parentGridColumn});
        deleteInputClauseCommand.undo(this.canvasHandler);
        this.verifyCommandUndoOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    @Test
    public void testAddOutputClause() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addOutputClause(2);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
        ((DecisionTableGrid)Mockito.verify((Object)this.grid)).selectHeaderCell(ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        this.verifyEditHeaderCell(OutputClauseColumnHeaderMetaData.class, 1, 2);
        Mockito.reset((Object[])new Object[]{this.gridPanel, this.gridLayer, this.grid, this.parentGridColumn});
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.addOutputClauseCommandCaptor.capture());
        ((AddOutputClauseCommand)this.addOutputClauseCommandCaptor.getValue()).undo(this.canvasHandler);
        this.verifyCommandUndoOperation(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
    }

    private void addOutputClause(int index) {
        this.mockInsertColumnCommandExecution();
        this.grid.addOutputClause(index);
    }

    @Test
    public void testDeleteOutputClause() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.deleteOutputClause(2);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.deleteOutputClauseCommandCaptor.capture());
        DeleteOutputClauseCommand deleteOutputClauseCommand = (DeleteOutputClauseCommand)this.deleteOutputClauseCommandCaptor.getValue();
        deleteOutputClauseCommand.execute(this.canvasHandler);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        Mockito.reset((Object[])new Object[]{this.gridPanel, this.gridLayer, this.grid, this.parentGridColumn});
        deleteOutputClauseCommand.undo(this.canvasHandler);
        this.verifyCommandUndoOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    @Test
    public void testAddDecisionRule() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        DecisionTable dtable = (DecisionTable)((Optional)this.grid.getExpression().get()).get();
        Assertions.assertThat((int)dtable.getRule().size()).isEqualTo(1);
        Assertions.assertThat((int)((DecisionRule)dtable.getRule().get(0)).getInputEntry().size()).isEqualTo(1);
        Assertions.assertThat((int)((DecisionRule)dtable.getRule().get(0)).getOutputEntry().size()).isEqualTo(1);
        this.addDecisionRule(0);
        Assertions.assertThat((int)dtable.getRule().size()).isEqualTo(2);
        Assertions.assertThat((int)((DecisionRule)dtable.getRule().get(1)).getInputEntry().size()).isEqualTo(1);
        Assertions.assertThat((int)((DecisionRule)dtable.getRule().get(1)).getOutputEntry().size()).isEqualTo(1);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    private void addDecisionRule(int index) {
        this.grid.addDecisionRule(index);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.addDecisionRuleCommandCaptor.capture());
        AddDecisionRuleCommand addDecisionRuleCommand = (AddDecisionRuleCommand)this.addDecisionRuleCommandCaptor.getValue();
        addDecisionRuleCommand.execute(this.canvasHandler);
    }

    @Test
    public void testDeleteDecisionRule() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.deleteDecisionRule(0);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.deleteDecisionRuleCommandCaptor.capture());
        DeleteDecisionRuleCommand deleteDecisionRuleCommand = (DeleteDecisionRuleCommand)this.deleteDecisionRuleCommandCaptor.getValue();
        deleteDecisionRuleCommand.execute(this.canvasHandler);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    @Test
    public void testDuplicateDecisionRule() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        DecisionTable dtable = (DecisionTable)((Optional)this.grid.getExpression().get()).get();
        Assertions.assertThat((int)dtable.getRule().size()).isEqualTo(1);
        DecisionRule rule0 = (DecisionRule)dtable.getRule().get(0);
        Assertions.assertThat((int)rule0.getInputEntry().size()).isEqualTo(1);
        Assertions.assertThat((int)rule0.getOutputEntry().size()).isEqualTo(1);
        ((UnaryTests)rule0.getInputEntry().get(0)).getText().setValue("input");
        ((LiteralExpression)rule0.getOutputEntry().get(0)).getText().setValue("output");
        rule0.getDescription().setValue("description");
        this.grid.duplicateDecisionRule(0);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.addDecisionRuleCommandCaptor.capture());
        AddDecisionRuleCommand addDecisionRuleCommand = (AddDecisionRuleCommand)this.addDecisionRuleCommandCaptor.getValue();
        addDecisionRuleCommand.execute(this.canvasHandler);
        Assertions.assertThat((int)dtable.getRule().size()).isEqualTo(2);
        DecisionRule rule1 = (DecisionRule)dtable.getRule().get(1);
        Assertions.assertThat((int)rule1.getInputEntry().size()).isEqualTo(1);
        Assertions.assertThat((int)rule1.getOutputEntry().size()).isEqualTo(1);
        Assertions.assertThat((String)((UnaryTests)rule0.getInputEntry().get(0)).getText().getValue()).isEqualTo("input");
        Assertions.assertThat((String)((LiteralExpression)rule0.getOutputEntry().get(0)).getText().getValue()).isEqualTo("output");
        Assertions.assertThat((String)rule0.getDescription().getValue()).isEqualTo("description");
        Assertions.assertThat((String)((UnaryTests)rule1.getInputEntry().get(0)).getText().getValue()).isEqualTo("input");
        Assertions.assertThat((String)((LiteralExpression)rule1.getOutputEntry().get(0)).getText().getValue()).isEqualTo("output");
        Assertions.assertThat((String)rule1.getDescription().getValue()).isEqualTo("description");
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    @Test
    public void testSetHitPolicy() {
        HitPolicy hitPolicy = HitPolicy.ANY;
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.setHitPolicy(hitPolicy, this.command);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.setHitPolicyCommandCaptor.capture());
        CompositeCommand setHitPolicyCommand = (CompositeCommand)this.setHitPolicyCommandCaptor.getValue();
        Assert.assertEquals((long)2L, (long)setHitPolicyCommand.getCommands().size());
        Assert.assertTrue((boolean)(setHitPolicyCommand.getCommands().get(0) instanceof SetBuiltinAggregatorCommand));
        Assert.assertTrue((boolean)(setHitPolicyCommand.getCommands().get(1) instanceof SetHitPolicyCommand));
        setHitPolicyCommand.execute((Object)this.canvasHandler);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.atLeast((int)1))).batch();
        ((Command)Mockito.verify((Object)this.command)).execute();
        Assert.assertEquals((Object)hitPolicy, (Object)this.expression.get().getHitPolicy());
        Assert.assertNull((Object)this.expression.get().getAggregation());
    }

    @Test
    public void testSetBuiltInAggregator() {
        BuiltinAggregator aggregator = BuiltinAggregator.SUM;
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.setBuiltinAggregator(aggregator);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.setBuiltInAggregatorCommandCaptor.capture());
        SetBuiltinAggregatorCommand setBuiltinAggregatorCommand = (SetBuiltinAggregatorCommand)this.setBuiltInAggregatorCommandCaptor.getValue();
        setBuiltinAggregatorCommand.execute(this.canvasHandler);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    private void verifyEditHeaderCell(Class<? extends ValueAndDataTypeHeaderMetaData> headerMetaDataClass, int uiHeaderRowIndex, int uiColumnIndex) {
        ((ValueAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.headerEditor)).bind((Object)((HasValueAndTypeRef)ArgumentMatchers.any(headerMetaDataClass)), ArgumentMatchers.eq((int)uiHeaderRowIndex), ArgumentMatchers.eq((int)uiColumnIndex));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)ArgumentMatchers.eq((Object)this.headerEditor), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testBodyTextBoxFactoryWhenNested() {
        this.setupGrid(this.makeHasNameForDecision(), 1);
        GridCellTuple tupleWithoutValue = new GridCellTuple(0, 3, this.gridWidget);
        GridCellValueTuple tupleWithValue = new GridCellValueTuple(0, 3, this.gridWidget, (GridCellValue)new BaseGridCellValue((Object)"value"));
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasNoValueCommand().apply(tupleWithoutValue))).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasValueCommand().apply(tupleWithValue))).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testBodyTextBoxFactoryWhenNotNested() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        GridCellTuple tupleWithoutValue = new GridCellTuple(0, 3, this.gridWidget);
        GridCellValueTuple tupleWithValue = new GridCellValueTuple(0, 3, this.gridWidget, (GridCellValue)new BaseGridCellValue((Object)"value"));
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasNoValueCommand().apply(tupleWithoutValue))).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasValueCommand().apply(tupleWithValue))).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testBodyTextAreaFactoryWhenNested() {
        this.setupGrid(this.makeHasNameForDecision(), 1);
        GridCellTuple tupleWithoutValue = new GridCellTuple(0, 1, this.gridWidget);
        GridCellValueTuple tupleWithValue = new GridCellValueTuple(0, 1, this.gridWidget, (GridCellValue)new BaseGridCellValue((Object)"value"));
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasNoValueCommand().apply(tupleWithoutValue))).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasValueCommand().apply(tupleWithValue))).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testBodyTextAreaFactoryWhenNotNested() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        GridCellTuple tupleWithoutValue = new GridCellTuple(0, 1, this.gridWidget);
        GridCellValueTuple tupleWithValue = new GridCellValueTuple(0, 1, this.gridWidget, (GridCellValue)new BaseGridCellValue((Object)"value"));
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasNoValueCommand().apply(tupleWithoutValue))).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat((Object)((org.kie.workbench.common.stunner.core.command.Command)factory.getHasValueCommand().apply(tupleWithValue))).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testGetDisplayName() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Assertions.assertThat((String)((Text)this.extractHeaderMetaData(0, 1).getValue()).getValue()).isEqualTo(INPUT_CLAUSE_NAME);
        Assertions.assertThat((String)((Name)this.extractHeaderMetaData(0, 2).getValue()).getValue()).isEqualTo(HASNAME_NAME);
        this.addOutputClause(3);
        Assertions.assertThat((String)((Name)this.extractHeaderMetaData(0, 2).getValue()).getValue()).isEqualTo(HASNAME_NAME);
        Assertions.assertThat((String)((Name)this.extractHeaderMetaData(1, 2).getValue()).getValue()).isEqualTo(OUTPUT_CLAUSE_NAME1);
        Assertions.assertThat((String)((Name)this.extractHeaderMetaData(0, 3).getValue()).getValue()).isEqualTo(HASNAME_NAME);
        Assertions.assertThat((String)((Name)this.extractHeaderMetaData(1, 3).getValue()).getValue()).isEqualTo(OUTPUT_CLAUSE_NAME2);
    }

    private ValueAndDataTypeHeaderMetaData extractHeaderMetaData(int uiHeaderRowIndex, int uiColumnIndex) {
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(uiColumnIndex);
        return (ValueAndDataTypeHeaderMetaData)column.getHeaderMetaData().get(uiHeaderRowIndex);
    }

    @Test
    public void testSetDisplayNameWithNoChange() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.assertHeaderMetaDataTest(0, 1, (ValueAndDataTypeHeaderMetaData md) -> md.setValue((Object)new Text(INPUT_CLAUSE_NAME)), new Class[0]);
        this.assertHeaderMetaDataTest(0, 2, (ValueAndDataTypeHeaderMetaData md) -> md.setValue((Object)new Name(HASNAME_NAME)), new Class[0]);
        this.addOutputClause(3);
        this.assertHeaderMetaDataTest(0, 2, (ValueAndDataTypeHeaderMetaData md) -> md.setValue((Object)new Name(HASNAME_NAME)), new Class[0]);
        this.assertHeaderMetaDataTest(1, 2, (ValueAndDataTypeHeaderMetaData md) -> md.setValue((Object)new Name(OUTPUT_CLAUSE_NAME1)), new Class[0]);
        this.assertHeaderMetaDataTest(0, 3, (ValueAndDataTypeHeaderMetaData md) -> md.setValue((Object)new Name(HASNAME_NAME)), new Class[0]);
        this.assertHeaderMetaDataTest(1, 3, (ValueAndDataTypeHeaderMetaData md) -> md.setValue((Object)new Name(OUTPUT_CLAUSE_NAME2)), new Class[0]);
    }

    @Test
    public void testSetDisplayNameSingleInputClauseWithEmptyValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue((Object)new Text());
        this.assertHeaderMetaDataTest(0, 1, test, DeleteHasValueCommand.class);
        ((CompositeCommand)this.compositeCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)((InputClause)this.expression.get().getInput().get(0)).getInputExpression().getText()).isEqualTo((Object)new Text());
    }

    @Test
    public void testSetDisplayNameSingleOutputClauseWithEmptyValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue((Object)new Name());
        this.assertHeaderMetaDataTest(0, 2, test, DeleteHasValueCommand.class, DeleteHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((CompositeCommand)this.compositeCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo("");
    }

    @Test
    public void testSetDisplayNameMultipleOutputClauseWithEmptyValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue((Object)new Name());
        this.addOutputClause(3);
        this.assertDisplayNameMultipleOutputClause(test);
    }

    private void assertDisplayNameMultipleOutputClause(Consumer<ValueAndDataTypeHeaderMetaData> test) {
        String defaultName = "defaultName";
        ArgumentCaptor compositeCommandCaptor1 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("defaultName");
        ((OutputClause)this.expression.get().getOutput().get(0)).setName("defaultName");
        this.assertHeaderMetaDataTest(0, 2, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor1, DeleteHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((CompositeCommand)compositeCommandCaptor1.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo("defaultName");
        ArgumentCaptor compositeCommandCaptor2 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("defaultName");
        ((OutputClause)this.expression.get().getOutput().get(0)).setName("defaultName");
        this.assertHeaderMetaDataTest(1, 2, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor2, DeleteHasValueCommand.class);
        ((CompositeCommand)compositeCommandCaptor2.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("defaultName");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo("");
        ArgumentCaptor compositeCommandCaptor3 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("defaultName");
        ((OutputClause)this.expression.get().getOutput().get(1)).setName("defaultName");
        this.assertHeaderMetaDataTest(0, 3, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor3, DeleteHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((CompositeCommand)compositeCommandCaptor3.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(1)).getName()).isEqualTo("defaultName");
        ArgumentCaptor compositeCommandCaptor4 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("defaultName");
        ((OutputClause)this.expression.get().getOutput().get(1)).setName("defaultName");
        this.assertHeaderMetaDataTest(1, 3, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor4, DeleteHasValueCommand.class);
        ((CompositeCommand)compositeCommandCaptor4.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("defaultName");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo("");
    }

    @Test
    public void testSetDisplayNameSingleInputClauseWithNullValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue(null);
        this.assertHeaderMetaDataTest(0, 1, test, DeleteHasValueCommand.class);
        ((CompositeCommand)this.compositeCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)((InputClause)this.expression.get().getInput().get(0)).getInputExpression().getText()).isEqualTo((Object)new Text());
    }

    @Test
    public void testSetDisplayNameSingleOutputClauseWithNullValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue(null);
        this.assertHeaderMetaDataTest(0, 2, test, DeleteHasValueCommand.class, DeleteHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((CompositeCommand)this.compositeCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo("");
    }

    @Test
    public void testSetDisplayNameMultipleOutputClauseWithNullValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue(null);
        this.addOutputClause(3);
        this.assertDisplayNameMultipleOutputClause(test);
    }

    @Test
    public void testSetDisplayNameSingleInputClauseWithNonEmptyValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue((Object)new Text(NAME_NEW));
        this.assertHeaderMetaDataTest(0, 1, test, SetHasValueCommand.class);
        ((CompositeCommand)this.compositeCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)((InputClause)this.expression.get().getInput().get(0)).getInputExpression().getText()).isEqualTo((Object)new Text(NAME_NEW));
    }

    @Test
    public void testSetDisplayNameSingleOutputClauseWithNonEmptyValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue((Object)new Name(NAME_NEW));
        this.assertHeaderMetaDataTest(0, 2, test, SetHasValueCommand.class, SetHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((CompositeCommand)this.compositeCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)this.hasExpression.getName()).isEqualTo((Object)new Name(NAME_NEW));
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo(NAME_NEW);
    }

    @Test
    public void testSetDisplayNameMultipleOutputClauseWithNonEmptyValue() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        String defaultName = "default-name";
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setValue((Object)new Name(NAME_NEW));
        this.addOutputClause(3);
        ArgumentCaptor compositeCommandCaptor1 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("default-name");
        ((OutputClause)this.expression.get().getOutput().get(0)).setName("default-name");
        this.assertHeaderMetaDataTest(0, 2, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor1, SetHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((CompositeCommand)compositeCommandCaptor1.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo(NAME_NEW);
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo("default-name");
        ArgumentCaptor compositeCommandCaptor2 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("default-name");
        ((OutputClause)this.expression.get().getOutput().get(0)).setName("default-name");
        this.assertHeaderMetaDataTest(1, 2, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor2, SetHasValueCommand.class);
        ((CompositeCommand)compositeCommandCaptor2.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("default-name");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo(NAME_NEW);
        ArgumentCaptor compositeCommandCaptor3 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("default-name");
        ((OutputClause)this.expression.get().getOutput().get(1)).setName("default-name");
        this.assertHeaderMetaDataTest(0, 3, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor3, SetHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((CompositeCommand)compositeCommandCaptor3.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo(NAME_NEW);
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(1)).getName()).isEqualTo("default-name");
        ArgumentCaptor compositeCommandCaptor4 = ArgumentCaptor.forClass(CompositeCommand.class);
        this.hasExpression.getName().setValue("default-name");
        ((OutputClause)this.expression.get().getOutput().get(1)).setName("default-name");
        this.assertHeaderMetaDataTest(1, 3, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)compositeCommandCaptor4, SetHasValueCommand.class);
        ((CompositeCommand)compositeCommandCaptor4.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((String)this.hasExpression.getName().getValue()).isEqualTo("default-name");
        Assertions.assertThat((String)((OutputClause)this.expression.get().getOutput().get(0)).getName()).isEqualTo(NAME_NEW);
    }

    @Test
    public void testGetTypeRef() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Assertions.assertThat((Object)this.extractHeaderMetaData(0, 1).getTypeRef()).isNotNull();
        Assertions.assertThat((Object)this.extractHeaderMetaData(0, 2).getTypeRef()).isNotNull();
        this.addOutputClause(3);
        Assertions.assertThat((Object)this.extractHeaderMetaData(0, 2).getTypeRef()).isNotNull();
        Assertions.assertThat((Object)this.extractHeaderMetaData(1, 2).getTypeRef()).isNotNull();
        Assertions.assertThat((Object)this.extractHeaderMetaData(0, 3).getTypeRef()).isNotNull();
        Assertions.assertThat((Object)this.extractHeaderMetaData(1, 3).getTypeRef()).isNotNull();
    }

    @Test
    public void testSetTypeRefSingleInputClause() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        QName typeRef = new QName("", BuiltInType.DATE.getName());
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setTypeRef(typeRef);
        ArgumentCaptor canvasCommandCaptor = ArgumentCaptor.forClass(CanvasCommand.class);
        this.assertHeaderMetaDataTest(0, 1, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)canvasCommandCaptor, SetTypeRefCommand.class);
        ((CanvasCommand)canvasCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)((InputClause)this.expression.get().getInput().get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)typeRef);
    }

    @Test
    public void testSetTypeRefSingleOutputClause() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        QName typeRef = new QName("", BuiltInType.DATE.getName());
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setTypeRef(typeRef);
        this.assertHeaderMetaDataTest(0, 2, test, SetTypeRefCommand.class, SetTypeRefCommand.class);
        ((CompositeCommand)this.compositeCommandCaptor.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)this.hasExpression.getVariable().getTypeRef()).isEqualTo((Object)typeRef);
        Assertions.assertThat((Object)((OutputClause)this.expression.get().getOutput().get(0)).getTypeRef()).isEqualTo((Object)typeRef);
    }

    @Test
    public void testSetTypeRefMultipleOutputClauses() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        QName typeRef = new QName("", BuiltInType.DATE.getName());
        QName defaultTypeRef = new QName();
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setTypeRef(typeRef);
        this.addOutputClause(3);
        ArgumentCaptor canvasCommandCaptor1 = ArgumentCaptor.forClass(CanvasCommand.class);
        this.hasExpression.getVariable().setTypeRef(defaultTypeRef);
        ((OutputClause)this.expression.get().getOutput().get(0)).setTypeRef(defaultTypeRef);
        this.assertHeaderMetaDataTest(0, 2, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)canvasCommandCaptor1, SetTypeRefCommand.class);
        ((CanvasCommand)canvasCommandCaptor1.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)this.hasExpression.getVariable().getTypeRef()).isEqualTo((Object)typeRef);
        Assertions.assertThat((Object)((OutputClause)this.expression.get().getOutput().get(0)).getTypeRef()).isEqualTo((Object)defaultTypeRef);
        ArgumentCaptor canvasCommandCaptor2 = ArgumentCaptor.forClass(CanvasCommand.class);
        this.hasExpression.getVariable().setTypeRef(defaultTypeRef);
        ((OutputClause)this.expression.get().getOutput().get(0)).setTypeRef(defaultTypeRef);
        this.assertHeaderMetaDataTest(1, 2, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)canvasCommandCaptor2, SetTypeRefCommand.class);
        ((CanvasCommand)canvasCommandCaptor2.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)this.hasExpression.getVariable().getTypeRef()).isEqualTo((Object)defaultTypeRef);
        Assertions.assertThat((Object)((OutputClause)this.expression.get().getOutput().get(0)).getTypeRef()).isEqualTo((Object)typeRef);
        ArgumentCaptor canvasCommandCaptor3 = ArgumentCaptor.forClass(CanvasCommand.class);
        this.hasExpression.getVariable().setTypeRef(defaultTypeRef);
        ((OutputClause)this.expression.get().getOutput().get(1)).setTypeRef(defaultTypeRef);
        this.assertHeaderMetaDataTest(0, 3, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)canvasCommandCaptor3, SetTypeRefCommand.class);
        ((CanvasCommand)canvasCommandCaptor3.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)this.hasExpression.getVariable().getTypeRef()).isEqualTo((Object)typeRef);
        Assertions.assertThat((Object)((OutputClause)this.expression.get().getOutput().get(1)).getTypeRef()).isEqualTo((Object)defaultTypeRef);
        ArgumentCaptor canvasCommandCaptor4 = ArgumentCaptor.forClass(CanvasCommand.class);
        this.hasExpression.getVariable().setTypeRef(defaultTypeRef);
        ((OutputClause)this.expression.get().getOutput().get(1)).setTypeRef(defaultTypeRef);
        this.assertHeaderMetaDataTest(1, 3, test, (ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command>)canvasCommandCaptor4, SetTypeRefCommand.class);
        ((CanvasCommand)canvasCommandCaptor4.getValue()).execute((Object)this.canvasHandler);
        Assertions.assertThat((Object)this.hasExpression.getVariable().getTypeRef()).isEqualTo((Object)defaultTypeRef);
        Assertions.assertThat((Object)((OutputClause)this.expression.get().getOutput().get(1)).getTypeRef()).isEqualTo((Object)typeRef);
    }

    @Test
    public void testSetTypeRefWithoutChange() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Consumer<ValueAndDataTypeHeaderMetaData> test = md -> md.setTypeRef(new QName());
        this.assertHeaderMetaDataTest(0, 1, test, new Class[0]);
        this.assertHeaderMetaDataTest(0, 2, test, new Class[0]);
        this.addOutputClause(3);
        this.assertHeaderMetaDataTest(0, 2, test, new Class[0]);
        this.assertHeaderMetaDataTest(1, 2, test, new Class[0]);
        this.assertHeaderMetaDataTest(0, 3, test, new Class[0]);
        this.assertHeaderMetaDataTest(1, 3, test, new Class[0]);
    }

    private void assertHeaderMetaDataTest(int uiHeaderRowIndex, int uiColumnIndex, Consumer<ValueAndDataTypeHeaderMetaData> test, Class ... commands) {
        this.assertHeaderMetaDataTest(uiHeaderRowIndex, uiColumnIndex, test, this.compositeCommandCaptor, commands);
    }

    private void assertHeaderMetaDataTest(int uiHeaderRowIndex, int uiColumnIndex, Consumer<ValueAndDataTypeHeaderMetaData> test, ArgumentCaptor<? extends org.kie.workbench.common.stunner.core.command.Command> argumentCaptor, Class ... commands) {
        Mockito.reset((Object[])new SessionCommandManager[]{this.sessionCommandManager});
        test.accept(this.extractHeaderMetaData(uiHeaderRowIndex, uiColumnIndex));
        if (commands.length == 0) {
            ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.any(AbstractCanvasHandler.class)), (org.kie.workbench.common.stunner.core.command.Command)ArgumentMatchers.any(org.kie.workbench.common.stunner.core.command.Command.class));
        } else {
            ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)argumentCaptor.capture());
            GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)argumentCaptor.getValue(), commands);
        }
    }

    @Test
    public void testAsDMNModelInstrumentedBase() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        Assertions.assertThat((Object)this.extractHeaderMetaData(0, 1).asDMNModelInstrumentedBase()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((Object)this.extractHeaderMetaData(0, 2).asDMNModelInstrumentedBase()).isInstanceOf(InformationItemPrimary.class);
    }

    @Test
    public void testInputClauseHasNameWrapperForHeaderMetaData() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        DecisionTable dtable = this.expression.get();
        Assertions.assertThat((String)((InputClause)dtable.getInput().get(0)).getInputExpression().getText().getValue()).isEqualTo(((GridColumn.HeaderMetaData)((GridColumn)this.grid.getModel().getColumns().get(1)).getHeaderMetaData().get(0)).getTitle());
        this.extractHeaderMetaData(0, 1).setValue((Object)new Text(NAME_NEW));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        ((AbstractCanvasGraphCommand)((CompositeCommand)this.compositeCommandCaptor.getValue()).getCommands().get(0)).execute(this.canvasHandler);
        Assertions.assertThat((String)((InputClause)this.expression.get().getInput().get(0)).getInputExpression().getText().getValue()).isEqualTo(NAME_NEW);
    }

    @Test
    public void testOutputClauseHasNameWrapperForHeaderMetaData() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addOutputClause(3);
        DecisionTable dtable = this.expression.get();
        OutputClause outputClause = (OutputClause)dtable.getOutput().get(0);
        GridColumn.HeaderMetaData outputClauseHeaderMetaData = (GridColumn.HeaderMetaData)((GridColumn)this.grid.getModel().getColumns().get(2)).getHeaderMetaData().get(1);
        Assertions.assertThat((String)outputClause.getName()).isEqualTo(outputClauseHeaderMetaData.getTitle());
        Mockito.reset((Object[])new SessionCommandManager[]{this.sessionCommandManager});
        this.extractHeaderMetaData(1, 2).setValue((Object)new Name(NAME_NEW));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        ((AbstractCanvasGraphCommand)((CompositeCommand)this.compositeCommandCaptor.getValue()).getCommands().get(0)).execute(this.canvasHandler);
        Assertions.assertThat((String)outputClause.getName()).isEqualTo(NAME_NEW);
    }

    @Test
    public void testSelectRow() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectCell(0, 0, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectMultipleCells() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)((DecisionRule)this.expression.get().getRule().get(0)).getInputEntry().get(0));
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(0, 2, false, true);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectSingleCellWithHeaderSelected() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectHeaderCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)this.expression.get().getInput().get(0));
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(0, 1, false, true);
        this.assertDomainObjectSelection((DomainObject)((DecisionRule)this.expression.get().getRule().get(0)).getInputEntry().get(0));
    }

    @Test
    public void testSelectInputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)((DecisionRule)this.expression.get().getRule().get(0)).getInputEntry().get(0));
    }

    @Test
    public void testSelectOutputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectCell(0, 2, false, false);
        this.assertDomainObjectSelection((DomainObject)((DecisionRule)this.expression.get().getRule().get(0)).getOutputEntry().get(0));
    }

    @Test
    public void testSelectDescriptionColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectCell(0, 3, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderRowNumberColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectHeaderCell(0, 0, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderInputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectHeaderCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)this.expression.get().getInput().get(0));
    }

    @Test
    public void testSelectHeaderSingleOutputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectHeaderCell(0, 2, false, false);
        this.assertDomainObjectSelection((DomainObject)this.expression.get().getOutput().get(0));
    }

    @Test
    public void testSelectHeaderMultipleOutputClauseColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addOutputClause(2);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectHeaderCell(0, 2, false, false);
        this.assertDomainObjectSelection((DomainObject)this.hasExpression);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectHeaderCell(1, 2, false, false);
        this.assertDomainObjectSelection((DomainObject)this.expression.get().getOutput().get(0));
    }

    @Test
    public void testSelectHeaderMultipleOutputClauseColumnNestedContextEntry() {
        Context context = new Context();
        ContextEntry contextEntry = new ContextEntry();
        InformationItem variable = new InformationItem();
        contextEntry.setVariable(variable);
        context.getContextEntry().add(contextEntry);
        contextEntry.setExpression((Expression)this.expression.get());
        this.hasExpression.setExpression((Expression)context);
        this.grid = (DecisionTableGrid)Mockito.spy((Object)((DecisionTableGrid)this.definition.getEditor(this.parent, Optional.empty(), (HasExpression)contextEntry, this.makeHasNameForDecision(), false, 1).get()));
        this.addOutputClause(2);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectHeaderCell(0, 2, false, false);
        this.assertDomainObjectSelection((DomainObject)variable);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectHeaderCell(1, 2, false, false);
        this.assertDomainObjectSelection((DomainObject)this.expression.get().getOutput().get(0));
    }

    @Test
    public void testSelectHeaderDescriptionColumn() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectHeaderCell(0, 3, false, false);
        this.assertNOPDomainObjectSelection();
    }

    private void assertDomainObjectSelection(DomainObject domainObject) {
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)domainObject);
    }

    private void assertNOPDomainObjectSelection() {
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectFirstCell() {
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.grid.selectFirstCell();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).containsOnly((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1)});
    }

    @Test
    public void testMultipleInputClauseColumnHeaderEditorInstances() {
        ValueAndDataTypePopoverView.Presenter headerEditor2 = (ValueAndDataTypePopoverView.Presenter)Mockito.mock(ValueAndDataTypePopoverView.Presenter.class);
        Mockito.when((Object)((ValueAndDataTypePopoverView.Presenter)this.headerEditors.get())).thenReturn((Object)this.headerEditor, (Object[])new ValueAndDataTypePopoverView.Presenter[]{headerEditor2});
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addInputClause(2);
        Mockito.reset((Object[])new ValueAndDataTypePopoverView.Presenter[]{headerEditor2});
        GridColumn uiColumn1 = (GridColumn)this.grid.getModel().getColumns().get(1);
        this.assertInputClauseColumnHeaderEditor(uiColumn1, this.headerEditor);
        GridColumn uiColumn2 = (GridColumn)this.grid.getModel().getColumns().get(2);
        this.assertInputClauseColumnHeaderEditor(uiColumn2, headerEditor2);
    }

    private void assertInputClauseColumnHeaderEditor(GridColumn uiColumn, ValueAndDataTypePopoverView.Presenter headerEditor) {
        Assertions.assertThat((Object)uiColumn).isInstanceOf(InputClauseColumn.class);
        InputClauseColumn inputClauseColumn = (InputClauseColumn)uiColumn;
        GridColumn.HeaderMetaData inputClauseColumnHeaderMetaData = (GridColumn.HeaderMetaData)inputClauseColumn.getHeaderMetaData().get(0);
        Assertions.assertThat((Object)inputClauseColumnHeaderMetaData).isInstanceOf(InputClauseColumnHeaderMetaData.class);
        InputClauseColumnHeaderMetaData inputClauseColumnHeaderMetaData1 = (InputClauseColumnHeaderMetaData)inputClauseColumnHeaderMetaData;
        Assertions.assertThat((Optional)inputClauseColumnHeaderMetaData1.getEditor()).isPresent();
        inputClauseColumnHeaderMetaData1.edit(this.gridBodyCellEditContext);
        ((ValueAndDataTypePopoverView.Presenter)Mockito.verify((Object)headerEditor)).bind((Object)((HasValueAndTypeRef)ArgumentMatchers.any(HasValueAndTypeRef.class)), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testMultipleOutputClauseColumnHeaderEditorInstances() {
        ValueAndDataTypePopoverView.Presenter headerEditor2 = (ValueAndDataTypePopoverView.Presenter)Mockito.mock(ValueAndDataTypePopoverView.Presenter.class);
        Mockito.when((Object)((ValueAndDataTypePopoverView.Presenter)this.headerEditors.get())).thenReturn((Object)this.headerEditor, (Object[])new ValueAndDataTypePopoverView.Presenter[]{this.headerEditor, headerEditor2});
        this.setupGrid(this.makeHasNameForDecision(), 0);
        this.addOutputClause(3);
        Mockito.reset((Object[])new ValueAndDataTypePopoverView.Presenter[]{headerEditor2});
        GridColumn uiColumn1 = (GridColumn)this.grid.getModel().getColumns().get(2);
        this.assertOutputClauseColumnHeaderEditor(uiColumn1, this.headerEditor);
        GridColumn uiColumn2 = (GridColumn)this.grid.getModel().getColumns().get(3);
        this.assertOutputClauseColumnHeaderEditor(uiColumn2, headerEditor2);
    }

    private void assertOutputClauseColumnHeaderEditor(GridColumn uiColumn, ValueAndDataTypePopoverView.Presenter headerEditor) {
        Assertions.assertThat((Object)uiColumn).isInstanceOf(OutputClauseColumn.class);
        OutputClauseColumn outputClauseColumn = (OutputClauseColumn)uiColumn;
        GridColumn.HeaderMetaData outputClauseColumnHeaderMetaData = (GridColumn.HeaderMetaData)outputClauseColumn.getHeaderMetaData().get(1);
        Assertions.assertThat((Object)outputClauseColumnHeaderMetaData).isInstanceOf(OutputClauseColumnHeaderMetaData.class);
        OutputClauseColumnHeaderMetaData outputClauseColumnHeaderMetaData1 = (OutputClauseColumnHeaderMetaData)outputClauseColumnHeaderMetaData;
        Assertions.assertThat((Optional)outputClauseColumnHeaderMetaData1.getEditor()).isPresent();
        outputClauseColumnHeaderMetaData1.edit(this.gridBodyCellEditContext);
        ((ValueAndDataTypePopoverView.Presenter)Mockito.verify((Object)headerEditor)).bind((Object)((HasValueAndTypeRef)ArgumentMatchers.any(HasValueAndTypeRef.class)), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }
}

