/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters;

import com.google.gwt.user.client.Event;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParameterView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class ParametersPopoverViewImplTest {
    private static final String PARAMETER1_NAME = "parameter1";
    private static final String PARAMETER2_NAME = "parameter2";
    private static final String PARAMETER_NAME_NEW = "new name";
    private static final QName PARAMETER_TYPE_REF_NEW = new QName("", BuiltInType.DATE.getName());
    @Mock
    private Div parametersContainer;
    @Mock
    private Div addParameter;
    @Mock
    private ManagedInstance<ParameterView> parameterViews;
    @Mock
    private ParameterView parameterView1;
    @Mock
    private ParameterView parameterView2;
    @Mock
    private ParametersPopoverView.Presenter presenter;
    @Mock
    private HTMLElement element;
    @Mock
    private Div popoverElement;
    @Mock
    private Div popoverContentElement;
    @Mock
    private JQueryProducer.JQuery<Popover> jQueryProducer;
    @Mock
    private Popover popover;
    @Mock
    private Event event;
    private ParametersPopoverViewImpl view;

    @Before
    public void setup() {
        this.view = (ParametersPopoverViewImpl)Mockito.spy((Object)new ParametersPopoverViewImpl(this.parametersContainer, this.addParameter, this.parameterViews, this.popoverElement, this.popoverContentElement, this.jQueryProducer));
        Mockito.when((Object)((ParameterView)this.parameterViews.get())).thenReturn((Object)this.parameterView1, (Object[])new ParameterView[]{this.parameterView2});
        Mockito.when((Object)this.parameterView1.getElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.parameterView2.getElement()).thenReturn((Object)this.element);
        ((ParametersPopoverViewImpl)Mockito.doReturn((Object)this.element).when((Object)this.view)).getElement();
        Mockito.when((Object)((Popover)this.jQueryProducer.wrap((Element)this.element))).thenReturn((Object)this.popover);
        this.view.init(this.presenter);
    }

    @Test
    public void testSetParameters() {
        InformationItem parameter1 = new InformationItem();
        InformationItem parameter2 = new InformationItem();
        parameter1.getName().setValue(PARAMETER1_NAME);
        parameter2.getName().setValue(PARAMETER2_NAME);
        List<InformationItem> parameters = Arrays.asList(parameter1, parameter2);
        this.view.setParameters(parameters);
        ((ParameterView)Mockito.verify((Object)this.parameterView1)).setName((String)ArgumentMatchers.eq((Object)PARAMETER1_NAME));
        this.verifyRemoveClickHandler(parameter1, this.parameterView1);
        this.verifyParameterNameChangeHandler(parameter1, this.parameterView1);
        this.verifyParameterTypeRefChangeHandler(parameter1, this.parameterView1);
        ((ParameterView)Mockito.verify((Object)this.parameterView2)).setName((String)ArgumentMatchers.eq((Object)PARAMETER2_NAME));
        this.verifyRemoveClickHandler(parameter2, this.parameterView2);
        this.verifyParameterNameChangeHandler(parameter2, this.parameterView2);
        this.verifyParameterTypeRefChangeHandler(parameter2, this.parameterView2);
        ((Div)Mockito.verify((Object)this.parametersContainer, (VerificationMode)Mockito.times((int)2))).appendChild((Node)this.element);
    }

    private void verifyRemoveClickHandler(InformationItem parameter, ParameterView view) {
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((ParameterView)Mockito.verify((Object)view)).addRemoveClickHandler((Command)commandArgumentCaptor.capture());
        ((Command)commandArgumentCaptor.getValue()).execute();
        ((ParametersPopoverView.Presenter)Mockito.verify((Object)this.presenter)).removeParameter(parameter);
    }

    private void verifyParameterNameChangeHandler(InformationItem parameter, ParameterView view) {
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(ParameterizedCommand.class);
        ((ParameterView)Mockito.verify((Object)view)).addParameterNameChangeHandler((ParameterizedCommand)commandArgumentCaptor.capture());
        ((ParameterizedCommand)commandArgumentCaptor.getValue()).execute((Object)PARAMETER_NAME_NEW);
        ((ParametersPopoverView.Presenter)Mockito.verify((Object)this.presenter)).updateParameterName(parameter, PARAMETER_NAME_NEW);
    }

    private void verifyParameterTypeRefChangeHandler(InformationItem parameter, ParameterView view) {
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(ParameterizedCommand.class);
        ((ParameterView)Mockito.verify((Object)view)).addParameterTypeRefChangeHandler((ParameterizedCommand)commandArgumentCaptor.capture());
        ((ParameterizedCommand)commandArgumentCaptor.getValue()).execute((Object)PARAMETER_TYPE_REF_NEW);
        ((ParametersPopoverView.Presenter)Mockito.verify((Object)this.presenter)).updateParameterTypeRef(parameter, PARAMETER_TYPE_REF_NEW);
    }

    @Test
    public void testUpdateParameterName() {
        InformationItem parameter1 = new InformationItem();
        InformationItem parameter2 = new InformationItem();
        this.view.setParameters(Arrays.asList(parameter1, parameter2));
        this.view.updateParameterName(0, PARAMETER1_NAME);
        ((ParameterView)Mockito.verify((Object)this.parameterView1)).setName(PARAMETER1_NAME);
        this.view.updateParameterName(1, PARAMETER2_NAME);
        ((ParameterView)Mockito.verify((Object)this.parameterView2)).setName(PARAMETER2_NAME);
        Mockito.reset((Object[])new ParameterView[]{this.parameterView1, this.parameterView2});
        this.view.updateParameterName(-1, "cheese");
        ((ParameterView)Mockito.verify((Object)this.parameterView1, (VerificationMode)Mockito.never())).setName((String)Mockito.any());
        ((ParameterView)Mockito.verify((Object)this.parameterView2, (VerificationMode)Mockito.never())).setName((String)Mockito.any());
        this.view.updateParameterName(2, "cheese");
        ((ParameterView)Mockito.verify((Object)this.parameterView1, (VerificationMode)Mockito.never())).setName((String)Mockito.any());
        ((ParameterView)Mockito.verify((Object)this.parameterView2, (VerificationMode)Mockito.never())).setName((String)Mockito.any());
    }

    @Test
    public void testFocusParameter() {
        InformationItem parameter1 = new InformationItem();
        InformationItem parameter2 = new InformationItem();
        this.view.setParameters(Arrays.asList(parameter1, parameter2));
        this.view.focusParameter(0);
        ((ParameterView)Mockito.verify((Object)this.parameterView1)).focus();
        this.view.focusParameter(1);
        ((ParameterView)Mockito.verify((Object)this.parameterView2)).focus();
        Mockito.reset((Object[])new ParameterView[]{this.parameterView1, this.parameterView2});
        this.view.focusParameter(-1);
        ((ParameterView)Mockito.verify((Object)this.parameterView1, (VerificationMode)Mockito.never())).focus();
        ((ParameterView)Mockito.verify((Object)this.parameterView2, (VerificationMode)Mockito.never())).focus();
        Mockito.reset((Object[])new ParameterView[]{this.parameterView1, this.parameterView2});
        this.view.focusParameter(2);
        ((ParameterView)Mockito.verify((Object)this.parameterView1, (VerificationMode)Mockito.never())).focus();
        ((ParameterView)Mockito.verify((Object)this.parameterView2, (VerificationMode)Mockito.never())).focus();
    }

    @Test
    public void testShow() {
        this.view.show(Optional.empty());
        ((Popover)Mockito.verify((Object)this.popover)).show();
    }

    @Test
    public void testHideBeforeShown() {
        this.view.hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    public void testHideAfterShown() {
        this.view.show(Optional.empty());
        this.view.hide();
        ((Popover)Mockito.verify((Object)this.popover)).hide();
        ((Popover)Mockito.verify((Object)this.popover)).destroy();
    }

    @Test
    public void testOnClickAddParameter() {
        this.view.onClickAddParameter(this.event);
        ((ParametersPopoverView.Presenter)Mockito.verify((Object)this.presenter)).addParameter();
    }
}

