/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.BaseSupplementaryFunctionEditorDefinition;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseSupplementaryFunctionEditorDefinitionTest {
    @Mock
    private BaseSupplementaryFunctionEditorDefinition baseSupplementaryFunctionEditorDefinition;
    @Mock
    private HasExpression hasExpression;
    private Optional<String> nodeUUID;
    private Optional<Context> expression;

    @Before
    public void setup() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("var1");
        variables.add("var2");
        this.nodeUUID = Optional.of("uuid");
        this.expression = Optional.of(new Context());
        ((BaseSupplementaryFunctionEditorDefinition)Mockito.doCallRealMethod().when((Object)this.baseSupplementaryFunctionEditorDefinition)).createVariable((String)Mockito.any());
        ((BaseSupplementaryFunctionEditorDefinition)Mockito.doCallRealMethod().when((Object)this.baseSupplementaryFunctionEditorDefinition)).enrich(this.nodeUUID, this.hasExpression, this.expression);
        Mockito.when((Object)this.baseSupplementaryFunctionEditorDefinition.getVariableNames()).thenReturn(variables);
    }

    @Test
    public void testDefaultVariableType() {
        InformationItem variable = this.baseSupplementaryFunctionEditorDefinition.createVariable("variable");
        Assert.assertEquals((Object)variable.getTypeRef().getLocalPart(), (Object)BuiltInType.STRING.getName());
    }

    @Test
    public void testEnrich() {
        this.baseSupplementaryFunctionEditorDefinition.enrich(this.nodeUUID, this.hasExpression, this.expression);
        List entry = this.expression.get().getContextEntry();
        Assert.assertEquals((long)2L, (long)entry.size());
        this.checkIfIsBuiltInTypeString((ContextEntry)entry.get(0));
        this.checkIfIsBuiltInTypeString((ContextEntry)entry.get(1));
    }

    private void checkIfIsBuiltInTypeString(ContextEntry entry) {
        Assert.assertEquals((Object)BuiltInType.STRING.getName(), (Object)entry.getVariable().getTypeRef().getLocalPart());
    }
}

