/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationParameterColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class InvocationUIModelMapperTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private InvocationParameterColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    @Captor
    private ArgumentCaptor<GridCellTuple> parentCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private BaseGridData uiModel;
    private Invocation invocation;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private InvocationUIModelMapper mapper;

    public void setup(boolean isOnlyVisualChangeAllowedSupplier) {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        Mockito.when((Object)this.uiRowNumberColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiNameColumn.getIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.uiExpressionEditorColumn.getIndex()).thenReturn((Object)2);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditor.getExpression()).thenReturn(() -> Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        LiteralExpression invocationExpression = new LiteralExpression();
        invocationExpression.getText().setValue("invocation-expression");
        LiteralExpression bindingExpression = new LiteralExpression();
        bindingExpression.getText().setValue("binding-expression");
        Binding binding = new Binding();
        InformationItem parameter = new InformationItem();
        parameter.setName(new Name("p0"));
        binding.setParameter(parameter);
        binding.setExpression((Expression)bindingExpression);
        this.invocation = new Invocation();
        this.invocation.setExpression((Expression)invocationExpression);
        this.invocation.getBinding().add(binding);
        this.mapper = new InvocationUIModelMapper(this.gridWidget, () -> this.uiModel, () -> Optional.of(this.invocation), () -> isOnlyVisualChangeAllowedSupplier, this.expressionEditorDefinitionsSupplier, this.listSelector, 0);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.setup(false);
        this.mapper.fromDMNModel(0, 0);
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)RowSelectionStrategy.INSTANCE, (Object)this.uiModel.getCell(0, 0).getSelectionStrategy());
    }

    @Test
    public void testFromDMNModelBindingParameter() {
        this.setup(false);
        this.mapper.fromDMNModel(0, 1);
        Assert.assertEquals((Object)"p0", (Object)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(0, 1).getValue().getValue()).getName().getValue());
    }

    @Test
    public void testFromDMNModelBindingExpression() {
        this.setup(false);
        this.assertFromDMNModelBindingExpression(false);
    }

    @Test
    public void testFromDMNModelBindingExpressionWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.assertFromDMNModelBindingExpression(true);
    }

    private void assertFromDMNModelBindingExpression(boolean isOnlyVisualChangeAllowed) {
        this.mapper.fromDMNModel(0, 2);
        Assert.assertNotNull((Object)this.uiModel.getCell(0, 2));
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 2).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)this.uiModel.getCell(0, 2).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv.getValue()).get());
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)ArgumentMatchers.eq(Optional.empty()), (HasExpression)ArgumentMatchers.eq((Object)((Binding)this.invocation.getBinding().get(0))), (Optional)ArgumentMatchers.eq(Optional.of(((Binding)this.invocation.getBinding().get(0)).getParameter())), ArgumentMatchers.eq((boolean)isOnlyVisualChangeAllowed), ArgumentMatchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)2L, (long)parent.getColumnIndex());
        Assert.assertEquals((Object)this.gridWidget, (Object)parent.getGridWidget());
    }

    @Test
    public void testToDMNModelBindingParameter() {
        this.setup(false);
        this.cellValueSupplier = () -> Optional.of(new BaseGridCellValue((Object)"updated"));
        this.mapper.toDMNModel(0, 1, this.cellValueSupplier);
        Assert.assertEquals((Object)"updated", (Object)((Binding)this.invocation.getBinding().get(0)).getParameter().getName().getValue());
    }

    @Test
    public void testToDMNModelBindingExpression() {
        this.setup(false);
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        this.mapper.toDMNModel(0, 2, this.cellValueSupplier);
        Assert.assertEquals((Object)this.literalExpression, (Object)((Binding)this.invocation.getBinding().get(0)).getExpression());
    }
}

