/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.list;

import com.ait.lienzo.client.core.shape.ContainerNode;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.AddListRowCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.DeleteListRowCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridRowNumberColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ListGridTest {
    private static final int HEADER = 0;
    private static final int INSERT_ROW_ABOVE = 1;
    private static final int INSERT_ROW_BELOW = 2;
    private static final int DELETE_ROW = 3;
    private static final int DIVIDER = 4;
    private static final int CLEAR_EXPRESSION_TYPE = 5;
    private static final String NODE_UUID = "uuid";
    private static final String NAME = "name";
    private static final String NAME_NEW = "name-new";
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private Index index;
    @Mock
    private Element element;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ValueAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private GridColumn parentGridColumn;
    @Mock
    private GridCellTuple parent;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    @Mock
    private UndefinedExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private UndefinedExpressionGrid undefinedExpressionEditor;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Captor
    private ArgumentCaptor<CompositeCommand> compositeCommandCaptor;
    @Captor
    private ArgumentCaptor<AddListRowCommand> addListRowCommandCaptor;
    @Captor
    private ArgumentCaptor<DeleteListRowCommand> deleteListRowCommandCaptor;
    @Captor
    private ArgumentCaptor<ClearExpressionTypeCommand> clearExpressionTypeCommandCaptor;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCommandCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private Decision hasExpression = new Decision();
    private Optional<org.kie.workbench.common.dmn.api.definition.model.List> expression = Optional.empty();
    private Optional<HasName> hasName = Optional.empty();
    private ListEditorDefinition definition;
    private ListGrid grid;

    @Before
    public void setup() {
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
        Mockito.when((Object)this.parentGridData.getColumns()).thenReturn(Collections.singletonList(this.parentGridColumn));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.definition = new ListEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.expressionEditorDefinitionsSupplier, this.headerEditor, this.readOnlyProvider);
        Decision decision = new Decision();
        decision.setName(new Name(NAME));
        this.hasName = Optional.of(decision);
        this.expression = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.hasExpression, this.expression);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        Mockito.when((Object)this.undefinedExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.undefinedExpressionEditor));
        Mockito.when((Object)((AbstractCanvasHandler)this.session.getCanvasHandler())).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphCommandExecutionContext);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.gridLayer.getVisibleBounds()).thenReturn((Object)new BaseBounds(0.0, 0.0, 100.0, 200.0));
        Mockito.when((Object)this.gridLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.index);
        Mockito.when((Object)this.index.get((String)Mockito.any())).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getContent()).thenReturn(Mockito.mock(Definition.class));
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(ArgumentMatchers.any())).thenReturn((Object)NAME);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)ArgumentMatchers.any(Element.class), (String)Mockito.any(), ArgumentMatchers.any())).thenReturn((Object)((CanvasCommand)Mockito.mock(UpdateElementPropertyCommand.class)));
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format((String)Mockito.any(), new Object[0]);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation((String)Mockito.any());
    }

    private void setupGrid() {
        this.hasExpression.setExpression((Expression)this.expression.get());
        this.grid = (ListGrid)Mockito.spy((Object)((ListGrid)this.definition.getEditor(this.parent, Optional.of(NODE_UUID), (HasExpression)this.hasExpression, this.hasName, false, 0).get()));
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.gridWidget);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)1);
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid();
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof ListGridData));
        Assert.assertEquals((long)2L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(0) instanceof ContextGridRowNumberColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(1) instanceof ExpressionEditorColumn));
        Assert.assertEquals((long)1L, (long)uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertTrue((boolean)(uiModel.getCell(0, 1).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv0 = (ExpressionCellValue)uiModel.getCell(0, 1).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv0.getValue()).get());
    }

    @Test
    public void testInitialColumnWidthsFromDefinition() {
        this.setupGrid();
        this.assertComponentWidths(50.0, 200.0);
    }

    @Test
    public void testInitialColumnWidthsFromExpression() {
        List componentWidths = this.expression.get().getComponentWidths();
        componentWidths.set(0, 100.0);
        componentWidths.set(1, 200.0);
        this.setupGrid();
        this.assertComponentWidths(100.0, 200.0);
    }

    private void assertComponentWidths(double ... widths) {
        GridData uiModel = this.grid.getModel();
        IntStream.range(0, widths.length).forEach(i -> Assert.assertEquals((double)widths[i], (double)((GridColumn)uiModel.getColumns().get(i)).getWidth(), (double)0.0));
    }

    @Test
    public void testCacheable() {
        this.setupGrid();
        Assert.assertTrue((boolean)this.grid.isCacheable());
    }

    @Test
    public void testGetItemsRowNumberColumn() {
        this.setupGrid();
        this.assertDefaultListItems(this.grid.getItems(0, 0), true);
    }

    @Test
    public void testOnItemSelectedExpressionColumnUndefinedExpressionType() {
        this.setupGrid();
        this.grid.getModel().setCellValue(0, 1, (GridCellValue)new ExpressionCellValue(Optional.empty()));
        this.assertDefaultListItems(this.grid.getItems(0, 1), true);
    }

    @Test
    public void testOnItemSelectedExpressionColumnDefinedExpressionType() {
        this.setupGrid();
        List items = this.grid.getItems(0, 1);
        Assertions.assertThat((int)items.size()).isEqualTo(6);
        this.assertDefaultListItems(items.subList(0, 4), true);
        Assertions.assertThat((Object)((HasListSelectorControl.ListSelectorItem)items.get(4))).isInstanceOf(HasListSelectorControl.ListSelectorDividerItem.class);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(5), "ExpressionEditor.Clear", true);
        ((HasListSelectorControl.ListSelectorTextItem)items.get(5)).getCommand().execute();
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)ArgumentMatchers.any(ClearExpressionTypeCommand.class));
    }

    @Test
    public void testGetItemsWithCellSelectionsCoveringMultipleRows() {
        this.setupGrid();
        this.addListRow(0);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(1, 0);
        this.assertDefaultListItems(this.grid.getItems(0, 0), false);
    }

    @Test
    public void testGetItemsWithCellSelectionsCoveringMultipleColumns() {
        this.setupGrid();
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(0, 1);
        this.assertDefaultListItems(this.grid.getItems(0, 0), true);
    }

    @Test
    public void testOnItemSelectedExpressionColumnDefinedExpressionTypeWithCellSelectionsCoveringMultipleRows() {
        this.setupGrid();
        this.addListRow(0);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(1, 0);
        BaseExpressionGrid editor = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        this.grid.getModel().setCellValue(0, 1, (GridCellValue)new ExpressionCellValue(Optional.of(editor)));
        List items = this.grid.getItems(0, 1);
        Assertions.assertThat((int)items.size()).isEqualTo(6);
        this.assertDefaultListItems(items.subList(0, 4), false);
        Assertions.assertThat((Object)((HasListSelectorControl.ListSelectorItem)items.get(4))).isInstanceOf(HasListSelectorControl.ListSelectorDividerItem.class);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(5), "ExpressionEditor.Clear", false);
    }

    private void assertDefaultListItems(List<HasListSelectorControl.ListSelectorItem> items, boolean enabled) {
        Assertions.assertThat((int)items.size()).isEqualTo(4);
        this.assertListSelectorHeaderItem(items.get(0), "ListEditor.HeaderRows");
        this.assertListSelectorTextItem(items.get(1), "ListEditor.InsertRowAbove", enabled);
        this.assertListSelectorTextItem(items.get(2), "ListEditor.InsertRowBelow", enabled);
        this.assertListSelectorTextItem(items.get(3), "ListEditor.DeleteRow", enabled && this.grid.getModel().getRowCount() > 1);
    }

    private void assertListSelectorHeaderItem(HasListSelectorControl.ListSelectorItem item, String text) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorHeaderItem.class);
        HasListSelectorControl.ListSelectorHeaderItem hi = (HasListSelectorControl.ListSelectorHeaderItem)item;
        Assertions.assertThat((String)hi.getText()).isEqualTo(text);
    }

    private void assertListSelectorTextItem(HasListSelectorControl.ListSelectorItem item, String text, boolean enabled) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorTextItem.class);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
        Assertions.assertThat((String)ti.getText()).isEqualTo(text);
        Assertions.assertThat((boolean)ti.isEnabled()).isEqualTo(enabled);
    }

    @Test
    public void testOnItemSelected() {
        this.setupGrid();
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testOnItemSelectedInsertRowAbove() {
        this.setupGrid();
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(1);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((ListGrid)Mockito.verify((Object)this.grid)).addRow(ArgumentMatchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedInsertRowBelow() {
        this.setupGrid();
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(2);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((ListGrid)Mockito.verify((Object)this.grid)).addRow(ArgumentMatchers.eq((int)1));
    }

    @Test
    public void testOnItemSelectedDeleteRow() {
        this.setupGrid();
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(3);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((ListGrid)Mockito.verify((Object)this.grid)).deleteRow(ArgumentMatchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedDeleteRowEnabled() {
        this.setupGrid();
        this.assertDeleteRowEnabled(0, false);
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.assertDeleteRowEnabled(0, true);
        this.assertDeleteRowEnabled(1, true);
    }

    private void assertDeleteRowEnabled(int uiRowIndex, boolean enabled) {
        List items = this.grid.getItems(uiRowIndex, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(3);
        Assertions.assertThat((boolean)ti.isEnabled()).isEqualTo(enabled);
    }

    @Test
    public void testAddListRow() {
        this.setupGrid();
        this.addListRow(0);
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(ArgumentMatchers.eq((double)(this.grid.getWidth() + this.grid.getPadding() * 2.0)), (Function)ArgumentMatchers.eq((Object)BaseExpressionGrid.RESIZE_EXISTING));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    private void addListRow(int index) {
        this.grid.addRow(index);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.addListRowCommandCaptor.capture());
        AddListRowCommand addContextEntryCommand = (AddListRowCommand)this.addListRowCommandCaptor.getValue();
        addContextEntryCommand.execute(this.canvasHandler);
    }

    @Test
    public void testDeleteListRow() {
        this.setupGrid();
        this.grid.deleteRow(0);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.deleteListRowCommandCaptor.capture());
        DeleteListRowCommand deleteContextEntryCommand = (DeleteListRowCommand)this.deleteListRowCommandCaptor.getValue();
        deleteContextEntryCommand.execute(this.canvasHandler);
        ((GridCellTuple)Mockito.verify((Object)this.parent)).onResize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testClearExpressionType() {
        this.setupGrid();
        ClearExpressionTypeCommand clearExpressionTypeCommand = this.clearRowExpression(0);
        ((ListGrid)Mockito.verify((Object)this.grid)).resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.undefinedExpressionEditor);
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.undefinedExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue()).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        Mockito.reset((Object[])new ContainerNode[]{this.grid, this.gridLayer});
        clearExpressionTypeCommand.undo(this.canvasHandler);
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(1)).getWidth()).isEqualTo(200.0);
        ((ListGrid)Mockito.verify((Object)this.grid)).resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((ListGrid)Mockito.verify((Object)this.grid)).selectExpressionEditorFirstCell(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.literalExpressionEditor);
        ((BaseExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        Assertions.assertThat((List)this.redrawCommandCaptor.getAllValues()).hasSize(2);
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getAllValues().get(1)).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    private ClearExpressionTypeCommand clearRowExpression(int index) {
        this.grid.clearExpressionType(index);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.clearExpressionTypeCommandCaptor.capture());
        ClearExpressionTypeCommand clearExpressionTypeCommand = (ClearExpressionTypeCommand)this.clearExpressionTypeCommandCaptor.getValue();
        clearExpressionTypeCommand.execute(this.canvasHandler);
        return clearExpressionTypeCommand;
    }

    @Test
    public void testSelectRow() {
        this.setupGrid();
        this.grid.selectCell(0, 0, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectMultipleRows() {
        this.setupGrid();
        this.addListRow(0);
        this.grid.selectCell(0, 0, false, false);
        this.assertNOPDomainObjectSelection();
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(1, 0, false, true);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectDefinedExpression() {
        this.setupGrid();
        this.grid.selectCell(0, 1, false, false);
        this.assertDomainObjectSelection(((HasExpression)this.expression.get().getExpression().get(0)).getExpression());
    }

    @Test
    public void testSelectUndefinedExpression() {
        this.setupGrid();
        this.clearRowExpression(0);
        this.grid.selectCell(0, 1, false, false);
        this.assertNOPDomainObjectSelection();
    }

    private void assertDomainObjectSelection(Expression domainObject) {
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)domainObject);
    }

    private void assertNOPDomainObjectSelection() {
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectFirstCell() {
        this.setupGrid();
        this.grid.selectFirstCell();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).containsOnly((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1)});
    }
}

