/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RelationGridDataTest {
    @Mock
    private GridRow gridRow;
    @Mock
    private GridColumn gridColumn1;
    @Mock
    private GridColumn gridColumn2;
    @Mock
    private GridColumn gridColumn3;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private ClientSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Command canvasOperation;
    private DMNGridData delegate;
    private RelationGridData uiModel;
    private Optional<Relation> expression = Optional.of(new Relation());

    @Before
    public void setup() {
        this.delegate = (DMNGridData)Mockito.spy((Object)new DMNGridData());
        this.uiModel = new RelationGridData(this.delegate, this.sessionManager, this.sessionCommandManager, () -> this.expression, this.canvasOperation);
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((ClientSession)Mockito.doReturn((Object)this.canvasHandler).when((Object)this.session)).getCanvasHandler();
    }

    @Test
    public void testMoveRowTo() {
        this.uiModel.moveRowTo(0, this.gridRow);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)Mockito.any());
    }

    @Test
    public void testMoveRowsTo() {
        this.uiModel.moveRowsTo(0, Collections.singletonList(this.gridRow));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)Mockito.any());
    }

    @Test
    public void testMoveColumnTo() {
        this.uiModel.moveColumnTo(0, this.gridColumn1);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)Mockito.any());
    }

    @Test
    public void testMoveColumnsTo() {
        this.uiModel.moveColumnsTo(0, Collections.singletonList(this.gridColumn1));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)Mockito.any());
    }

    @Test
    public void testAppendColumn() {
        this.uiModel.appendColumn(this.gridColumn1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).appendColumn((GridColumn)ArgumentMatchers.eq((Object)this.gridColumn1));
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testAppendColumns() {
        this.uiModel.appendColumn(this.gridColumn1);
        Mockito.reset((Object[])new GridColumn[]{this.gridColumn1});
        this.uiModel.appendColumn(this.gridColumn2);
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
        ((GridColumn)Mockito.verify((Object)this.gridColumn2)).setResizable(ArgumentMatchers.eq((boolean)false));
        Mockito.reset((Object[])new GridColumn[]{this.gridColumn1, this.gridColumn2});
        this.uiModel.appendColumn(this.gridColumn3);
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
        ((GridColumn)Mockito.verify((Object)this.gridColumn2)).setResizable(ArgumentMatchers.eq((boolean)true));
        ((GridColumn)Mockito.verify((Object)this.gridColumn3)).setResizable(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testInsertColumn() {
        this.uiModel.insertColumn(0, this.gridColumn1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).insertColumn(ArgumentMatchers.eq((int)0), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumn1));
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testInsertColumnsInOrder() {
        this.uiModel.insertColumn(0, this.gridColumn1);
        Mockito.reset((Object[])new GridColumn[]{this.gridColumn1});
        this.uiModel.insertColumn(1, this.gridColumn2);
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
        ((GridColumn)Mockito.verify((Object)this.gridColumn2)).setResizable(ArgumentMatchers.eq((boolean)false));
        Mockito.reset((Object[])new GridColumn[]{this.gridColumn1, this.gridColumn2});
        this.uiModel.insertColumn(2, this.gridColumn3);
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
        ((GridColumn)Mockito.verify((Object)this.gridColumn2)).setResizable(ArgumentMatchers.eq((boolean)true));
        ((GridColumn)Mockito.verify((Object)this.gridColumn3)).setResizable(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testInsertColumnsNotInOrder() {
        this.uiModel.insertColumn(0, this.gridColumn1);
        Mockito.reset((Object[])new GridColumn[]{this.gridColumn1});
        this.uiModel.insertColumn(0, this.gridColumn2);
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
        ((GridColumn)Mockito.verify((Object)this.gridColumn2)).setResizable(ArgumentMatchers.eq((boolean)false));
        Mockito.reset((Object[])new GridColumn[]{this.gridColumn1, this.gridColumn2});
        this.uiModel.insertColumn(0, this.gridColumn3);
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
        ((GridColumn)Mockito.verify((Object)this.gridColumn2)).setResizable(ArgumentMatchers.eq((boolean)true));
        ((GridColumn)Mockito.verify((Object)this.gridColumn3)).setResizable(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testDeleteColumn() {
        this.uiModel.appendColumn(this.gridColumn1);
        this.uiModel.appendColumn(this.gridColumn2);
        Mockito.reset((Object[])new GridColumn[]{this.gridColumn1});
        this.uiModel.deleteColumn(this.gridColumn2);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).deleteColumn((GridColumn)ArgumentMatchers.eq((Object)this.gridColumn2));
        ((GridColumn)Mockito.verify((Object)this.gridColumn1)).setResizable(ArgumentMatchers.eq((boolean)false));
    }
}

