/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.expressions.types.undefined.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.selector.UndefinedExpressionSelectorPopoverView;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCacheImpl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.DelegatingGridWidgetCellSelectorMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.DelegatingGridWidgetEditCellMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.ManagedSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class UndefinedExpressionGridTest {
    private static final String NODE_UUID = "uuid";
    private static final int PARENT_ROW_INDEX = 0;
    private static final int PARENT_COLUMN_INDEX = 1;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNEditorSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private UndefinedExpressionSelectorPopoverView.Presenter undefinedExpressionSelector;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private GridCellTuple parent;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridUiModel;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private NodeMouseClickEvent mouseClickEvent;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private ManagedSession managedSession;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Captor
    private ArgumentCaptor<SetCellValueCommand> setCellValueCommandArgumentCaptor;
    @Captor
    private ArgumentCaptor<RefreshFormPropertiesEvent> refreshFormPropertiesArgumentCaptor;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCommandArgumentCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionArgumentEventCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private Optional<Expression> expression = Optional.empty();
    private Optional<HasName> hasName = Optional.empty();
    private ExpressionGridCache expressionGridCache;
    private UndefinedExpressionEditorDefinition definition;
    private UndefinedExpressionGrid grid;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.expressionGridCache = (ExpressionGridCache)Mockito.spy((Object)new ExpressionGridCacheImpl());
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getExpressionGridCache()).thenReturn((Object)this.expressionGridCache);
        this.definition = new UndefinedExpressionEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.undefinedExpressionSelector, this.expressionEditorDefinitionsSupplier, this.readOnlyProvider);
        this.expression = this.definition.getModelClass();
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getType()).thenReturn((Object)ExpressionType.LITERAL_EXPRESSION);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getName()).thenReturn((Object)LiteralExpression.class.getSimpleName());
        ((BaseExpressionGrid)Mockito.doCallRealMethod().when((Object)this.literalExpressionEditor)).selectFirstCell();
        Mockito.when((Object)this.literalExpressionEditor.getLayer()).thenReturn((Object)this.gridLayer);
        BaseGridData literalExpressionUiModel = new BaseGridData();
        literalExpressionUiModel.appendColumn((GridColumn)Mockito.mock(GridColumn.class));
        literalExpressionUiModel.appendRow((GridRow)Mockito.mock(GridRow.class));
        Mockito.when((Object)this.literalExpressionEditor.getModel()).thenReturn((Object)literalExpressionUiModel);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridUiModel);
        this.setupParent();
    }

    private void setupParent() {
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)1);
    }

    private void setupGrid(int nesting) {
        this.grid = (UndefinedExpressionGrid)Mockito.spy((Object)((UndefinedExpressionGrid)this.definition.getEditor(this.parent, nesting == 0 ? Optional.of(NODE_UUID) : Optional.empty(), this.hasExpression, this.hasName, false, nesting).get()));
    }

    @Test
    public void testMouseClickEventHandlers() {
        this.setupGrid(0);
        List handlers = this.grid.getNodeMouseClickEventHandlers(this.selectionManager);
        Assertions.assertThat((List)handlers).hasSize(2);
        Assertions.assertThat((Object)((NodeMouseEventHandler)handlers.get(0))).isInstanceOf(DelegatingGridWidgetCellSelectorMouseEventHandler.class);
        Assertions.assertThat((Object)((NodeMouseEventHandler)handlers.get(1))).isInstanceOf(DelegatingGridWidgetEditCellMouseEventHandler.class);
    }

    @Test
    public void testMouseDoubleClickEventHandlers() {
        this.setupGrid(0);
        List handlers = this.grid.getNodeMouseDoubleClickEventHandlers(this.selectionManager, (GridPinnedModeManager)this.gridLayer);
        Assertions.assertThat((List)handlers).isEmpty();
    }

    @Test
    public void testSelectFirstCellWhenNested() {
        this.setupGrid(1);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        this.grid.selectFirstCell();
        Assertions.assertThat((int)this.grid.getModel().getSelectedCells().size()).isEqualTo(0);
        ((GridData)Mockito.verify((Object)this.parentGridUiModel)).selectCell(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select(this.parentGridWidget);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectFirstCellWhenNotNested() {
        this.setupGrid(0);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        this.grid.selectFirstCell();
        List selectedCells = this.grid.getModel().getSelectedCells();
        Assertions.assertThat((int)selectedCells.size()).isEqualTo(1);
        Assertions.assertThat((int)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex()).isEqualTo(0);
        Assertions.assertThat((int)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex()).isEqualTo(0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.grid);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)decision);
    }

    @Test
    public void testResizeBasedOnCellExpressionEditor() {
        this.setupGrid(0);
        this.grid.resize(BaseExpressionGrid.RESIZE_EXISTING);
        this.assertResize(BaseExpressionGrid.RESIZE_EXISTING);
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid(0);
        GridData uiModel = this.grid.getModel();
        Assertions.assertThat((Object)uiModel).isInstanceOf(DMNGridData.class);
        Assertions.assertThat((int)uiModel.getColumnCount()).isEqualTo(1);
        Assertions.assertThat((Object)((GridColumn)uiModel.getColumns().get(0))).isInstanceOf(UndefinedExpressionColumn.class);
        Assertions.assertThat((int)uiModel.getRowCount()).isEqualTo(1);
        Assertions.assertThat((Object)uiModel.getCell(0, 0)).isNotNull();
        Assertions.assertThat((Object)uiModel.getCell(0, 0)).isInstanceOf(UndefinedExpressionCell.class);
    }

    @Test
    public void testCacheable() {
        this.setupGrid(0);
        Assert.assertFalse((boolean)this.grid.isCacheable());
    }

    @Test
    public void testPaddingWithParent() {
        this.setupGrid(0);
        ((UndefinedExpressionGrid)Mockito.doReturn(Optional.of((BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class))).when((Object)this.grid)).findParentGrid();
        Assertions.assertThat((double)this.grid.getPadding()).isEqualTo(0.0);
    }

    @Test
    public void testPaddingWithNoParent() {
        this.setupGrid(0);
        ((UndefinedExpressionGrid)Mockito.doReturn(Optional.empty()).when((Object)this.grid)).findParentGrid();
        Assertions.assertThat((double)this.grid.getPadding()).isEqualTo(0.0);
    }

    @Test
    public void testGetItemsWithParentWithoutCellControls() {
        this.setupGrid(0);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        BaseExpressionGrid parentGridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)parentGridWidget);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGridWidget));
        Mockito.when((Object)parentGridWidget.getModel()).thenReturn((Object)parentGridData);
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isEmpty();
    }

    @Test
    public void testGetItemsWithParentThatDoesSupportCellControls() {
        this.setupGrid(0);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        ContextGrid parentGridWidget = (ContextGrid)Mockito.mock(ContextGrid.class);
        HasListSelectorControl.ListSelectorItem listSelectorItem = (HasListSelectorControl.ListSelectorItem)Mockito.mock(HasListSelectorControl.ListSelectorItem.class);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)parentGridWidget);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGridWidget));
        Mockito.when((Object)parentGridWidget.getModel()).thenReturn((Object)parentGridData);
        Mockito.when((Object)parentGridWidget.getItems(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(Collections.singletonList(listSelectorItem));
        Mockito.when((Object)parentGridData.getCell(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)((GridCell)Mockito.mock(LiteralExpressionCell.class)));
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isNotEmpty();
        Assertions.assertThat((int)items.size()).isEqualTo(1);
        Assertions.assertThat((Object)((HasListSelectorControl.ListSelectorItem)items.get(0))).isSameAs((Object)listSelectorItem);
    }

    @Test
    public void testGetItemsWithParentThatDoesSupportCellControlsButCellDoesNot() {
        this.setupGrid(0);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        ContextGrid parentGridWidget = (ContextGrid)Mockito.mock(ContextGrid.class);
        HasListSelectorControl.ListSelectorItem listSelectorItem = (HasListSelectorControl.ListSelectorItem)Mockito.mock(HasListSelectorControl.ListSelectorItem.class);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)parentGridWidget);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGridWidget));
        Mockito.when((Object)parentGridWidget.getModel()).thenReturn((Object)parentGridData);
        Mockito.when((Object)parentGridWidget.getItems(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(Collections.singletonList(listSelectorItem));
        Mockito.when((Object)parentGridData.getCell(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)((GridCell)Mockito.mock(BaseGridCell.class)));
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isEmpty();
    }

    @Test
    public void testGetItemsWithParentThatDoesNotSupportCellControls() {
        this.setupGrid(0);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        BaseExpressionGrid parentGridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)parentGridWidget);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGridWidget));
        Mockito.when((Object)parentGridWidget.getModel()).thenReturn((Object)parentGridData);
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isEmpty();
    }

    @Test
    public void testGetItemsEmpty() {
        this.setupGrid(0);
        Mockito.reset((Object[])new Supplier[]{this.expressionEditorDefinitionsSupplier});
        ((Supplier)Mockito.doReturn((Object)new ExpressionEditorDefinitions()).when(this.expressionEditorDefinitionsSupplier)).get();
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((int)items.size()).isEqualTo(0);
    }

    @Test
    public void testOnItemSelectedDivider() {
        this.setupGrid(0);
        HasListSelectorControl.ListSelectorDividerItem dItem = (HasListSelectorControl.ListSelectorDividerItem)Mockito.mock(HasListSelectorControl.ListSelectorDividerItem.class);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)dItem);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).hide();
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.grid, (VerificationMode)Mockito.never())).onExpressionTypeChanged((ExpressionType)ArgumentMatchers.any(ExpressionType.class));
    }

    @Test
    public void testOnItemSelected() {
        this.setupGrid(0);
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testOnExpressionTypeChangedWhenNested() {
        this.assertOnExpressionTypeChanged(1);
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache, (VerificationMode)Mockito.never())).getExpressionGrid((String)Mockito.any());
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testOnExpressionTypeChangedWhenNotNested() {
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        this.assertOnExpressionTypeChanged(0);
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache)).getExpressionGrid((String)ArgumentMatchers.eq((Object)NODE_UUID));
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionArgumentEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)decision);
    }

    private void assertResize(Function<BaseExpressionGrid, Double> expectedResizer) {
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(ArgumentMatchers.eq((double)this.grid.getWidth()), (Function)ArgumentMatchers.eq(expectedResizer));
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((GridCellTuple)Mockito.verify((Object)this.parent)).onResize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandArgumentCaptor.capture());
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandArgumentCaptor.getValue()).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    private void assertOnExpressionTypeChanged(int nesting) {
        this.setupGrid(nesting);
        this.grid.onExpressionTypeChanged(ExpressionType.LITERAL_EXPRESSION);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)this.setCellValueCommandArgumentCaptor.capture());
        SetCellValueCommand setCellValueCommand = (SetCellValueCommand)this.setCellValueCommandArgumentCaptor.getValue();
        setCellValueCommand.execute(this.canvasHandler);
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)ArgumentMatchers.eq((Object)this.parent), (Optional)ArgumentMatchers.eq(nesting == 0 ? Optional.of(NODE_UUID) : Optional.empty()), (HasExpression)ArgumentMatchers.eq((Object)this.hasExpression), (Optional)ArgumentMatchers.eq(this.hasName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)nesting));
        this.assertResize(BaseExpressionGrid.RESIZE_EXISTING);
        ((BaseExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor)).selectCell(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        ((BaseExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor)).selectFirstCell();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).setFocus(true);
        Mockito.reset((Object[])new Object[]{this.gridPanel, this.gridLayer, this.parent});
        this.setupParent();
        setCellValueCommand.undo(this.canvasHandler);
        this.assertResize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.grid);
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.grid)).selectCell(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
    }
}

