/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.util;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.expressions.util.NameUtils;

public class NameUtilsTest {
    @Test
    public void testNull() {
        Assertions.assertThat((String)NameUtils.normaliseName(null)).isEmpty();
    }

    @Test
    public void testEmpty() {
        Assertions.assertThat((String)NameUtils.normaliseName((String)"")).isEmpty();
    }

    @Test
    public void testLeadingWhitespace() {
        Assertions.assertThat((String)NameUtils.normaliseName((String)"  hello")).isEqualTo("hello");
    }

    @Test
    public void testTrailingWhitespace() {
        Assertions.assertThat((String)NameUtils.normaliseName((String)"hello   ")).isEqualTo("hello");
    }

    @Test
    public void testCompactWhitespace() {
        Assertions.assertThat((String)NameUtils.normaliseName((String)"hello   world")).isEqualTo("hello world");
    }

    @Test
    public void testCompleteNormalisation() {
        Assertions.assertThat((String)NameUtils.normaliseName((String)"  hello   world  ")).isEqualTo("hello world");
    }
}

