/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.util;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwtmockito.GwtMock;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.util.RendererUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.ValueAndDataTypeHeaderMetaData;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RendererUtilsTest {
    private static final String VALUE = "some text value";
    private static final String PLACE_HOLDER = "place holder text";
    private static final double WIDTH = 200.0;
    private static final double HEIGHT = 80.0;
    private static final String TITLE = "title";
    private static final QName TYPE_REF = new QName();
    private static final int BLOCK_WIDTH = 100;
    private static final double ROW_HEIGHT = 32.0;
    private Text text;
    @Mock
    private GridRenderer gridRenderer;
    @Mock
    private GridRendererTheme gridTheme;
    @Mock
    private GridBodyCellRenderContext cellContext;
    @Mock
    private LiteralExpressionColumn uiColumn;
    @Mock
    private GridData uiModel;
    @Mock
    private Text headerText1;
    @Mock
    private Text headerText2;
    @Mock
    private Text placeHolderText;
    @Mock
    private Transform transform;
    @Mock
    private EditableHeaderMetaData headerMetaData;
    @GwtMock
    private Group headerGroup;
    private GridHeaderColumnRenderContext headerContext;
    private GridBodyCellRenderContext bodyContext;

    @Before
    public void setUp() throws Exception {
        this.text = (Text)Mockito.spy((Object)new Text(""));
        this.headerContext = new GridHeaderColumnRenderContext(0.0, Collections.singletonList(this.uiColumn), Collections.singletonList(this.uiColumn), 0, this.uiModel, this.gridRenderer);
        this.bodyContext = new GridBodyCellRenderContext(0.0, 0.0, 100.0, 32.0, 0.0, 0.0, 0, 0, false, this.transform, this.gridRenderer);
        Mockito.when((Object)this.cellContext.getRenderer()).thenReturn((Object)this.gridRenderer);
        Mockito.when((Object)this.gridRenderer.getTheme()).thenReturn((Object)this.gridTheme);
        Mockito.when((Object)this.gridTheme.getBodyText()).thenReturn((Object)this.text);
        Mockito.when((Object)this.cellContext.getCellWidth()).thenReturn((Object)200.0);
        Mockito.when((Object)this.cellContext.getCellHeight()).thenReturn((Object)80.0);
        Mockito.when((Object)this.gridTheme.getHeaderText()).thenReturn((Object)this.headerText1, (Object[])new Text[]{this.headerText2});
        Mockito.when((Object)this.gridTheme.getPlaceholderText()).thenReturn((Object)this.placeHolderText);
        Mockito.when((Object)this.headerText1.asNode()).thenReturn((Object)((Node)Mockito.mock(Node.class)));
        Mockito.when((Object)this.headerText2.asNode()).thenReturn((Object)((Node)Mockito.mock(Node.class)));
        Mockito.when((Object)this.placeHolderText.asNode()).thenReturn((Object)((Node)Mockito.mock(Node.class)));
    }

    @Test
    public void testRenderCenteredText() throws Exception {
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)VALUE));
        RendererUtils.getCenteredCellText((GridBodyCellRenderContext)this.cellContext, (GridCell)cell);
        this.assertCenteredRendering(this.text);
        this.assertNotRenderedPlaceHolder(this.placeHolderText);
    }

    @Test
    public void testRenderCenteredEmptyTextWithPlaceHolder() throws Exception {
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue(null, PLACE_HOLDER));
        RendererUtils.getCenteredCellText((GridBodyCellRenderContext)this.cellContext, (GridCell)cell);
        this.assertCenteredRenderingPlaceholder(this.placeHolderText);
    }

    @Test
    public void testRenderExpressionCellText() throws Exception {
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)VALUE));
        RendererUtils.getExpressionCellText((GridBodyCellRenderContext)this.cellContext, (GridCell)cell);
        this.assertExpressionRendering();
    }

    @Test
    public void testRenderExpressionHeaderText() throws Exception {
        Mockito.when((Object)this.headerMetaData.getTitle()).thenReturn((Object)VALUE);
        RendererUtils.getExpressionHeaderText((EditableHeaderMetaData)this.headerMetaData, (GridHeaderColumnRenderContext)this.headerContext);
        this.assertExpressionRendering();
    }

    @Test
    public void testRenderHeaderContentWithNameAndDataTypeHeaderMetaData() {
        ValueAndDataTypeHeaderMetaData metaData = (ValueAndDataTypeHeaderMetaData)Mockito.mock(ValueAndDataTypeHeaderMetaData.class);
        Mockito.when((Object)metaData.getTitle()).thenReturn((Object)TITLE);
        Mockito.when((Object)metaData.getTypeRef()).thenReturn((Object)TYPE_REF);
        RendererUtils.getValueAndDataTypeHeaderText((ValueAndDataTypeHeaderMetaData)metaData, (GridHeaderColumnRenderContext)this.headerContext, (double)100.0, (double)32.0);
        this.assertHasNameAndDataTypeRendering();
    }

    @Test
    public void testRenderHeaderContentWithInformationItemCell() {
        InformationItemCell.HasNameAndDataTypeCell informationItemCell = (InformationItemCell.HasNameAndDataTypeCell)Mockito.mock(InformationItemCell.HasNameAndDataTypeCell.class);
        Name name = new Name(TITLE);
        Mockito.when((Object)informationItemCell.getName()).thenReturn((Object)name);
        Mockito.when((Object)informationItemCell.getTypeRef()).thenReturn((Object)TYPE_REF);
        Mockito.when((Object)informationItemCell.hasData()).thenReturn((Object)true);
        RendererUtils.getNameAndDataTypeCellText((InformationItemCell.HasNameAndDataTypeCell)informationItemCell, (GridBodyCellRenderContext)this.bodyContext);
        this.assertHasNameAndDataTypeRendering();
    }

    @Test
    public void testRenderEditableHeaderText() {
        Mockito.when((Object)this.headerMetaData.getTitle()).thenReturn((Object)VALUE);
        RendererUtils.getEditableHeaderText((EditableHeaderMetaData)this.headerMetaData, (GridHeaderColumnRenderContext)this.headerContext, (double)200.0, (double)80.0);
        this.assertCenteredRendering(this.headerText1);
    }

    @Test
    public void testRenderEditableHeaderPlaceHolderText() {
        Mockito.when((Object)this.headerMetaData.getPlaceHolder()).thenReturn(Optional.of(VALUE));
        RendererUtils.getEditableHeaderPlaceHolderText((EditableHeaderMetaData)this.headerMetaData, (GridHeaderColumnRenderContext)this.headerContext, (double)200.0, (double)80.0);
        this.assertCenteredRendering(this.placeHolderText);
    }

    @Test
    public void testRenderEditableHeaderPlaceHolderTextWhenEmpty() {
        Mockito.when((Object)this.headerMetaData.getPlaceHolder()).thenReturn(Optional.empty());
        RendererUtils.getEditableHeaderPlaceHolderText((EditableHeaderMetaData)this.headerMetaData, (GridHeaderColumnRenderContext)this.headerContext, (double)200.0, (double)80.0);
        ((Group)Mockito.verify((Object)this.headerGroup, (VerificationMode)Mockito.never())).add((IPrimitive)ArgumentMatchers.any(IPrimitive.class));
    }

    private void assertNotRenderedPlaceHolder(Text placeHolderText) {
        ((Text)Mockito.verify((Object)placeHolderText, (VerificationMode)Mockito.never())).setText(PLACE_HOLDER);
    }

    private void assertCenteredRendering(Text text) {
        ((Text)Mockito.verify((Object)text)).setText(VALUE);
        ((Text)Mockito.verify((Object)text)).setListening(false);
        ((Text)Mockito.verify((Object)text)).setX(100.0);
        ((Text)Mockito.verify((Object)text)).setY(40.0);
    }

    private void assertCenteredRenderingPlaceholder(Text text) {
        ((Text)Mockito.verify((Object)text)).setText(PLACE_HOLDER);
        ((Text)Mockito.verify((Object)text)).setListening(false);
        ((Text)Mockito.verify((Object)text)).setX(100.0);
        ((Text)Mockito.verify((Object)text)).setY(40.0);
    }

    private void assertExpressionRendering() {
        ((Text)Mockito.verify((Object)this.text)).setText(VALUE);
        ((Text)Mockito.verify((Object)this.text)).setListening(false);
        ((Text)Mockito.verify((Object)this.text)).setX(5.0);
        ((Text)Mockito.verify((Object)this.text)).setY(5.0);
        ((Text)Mockito.verify((Object)this.text)).setFontFamily("Courier New");
        ((Text)Mockito.verify((Object)this.text)).setTextAlign(TextAlign.LEFT);
    }

    private void assertHasNameAndDataTypeRendering() {
        ((Text)Mockito.verify((Object)this.headerText1)).setText((String)ArgumentMatchers.eq((Object)TITLE));
        ((Text)Mockito.verify((Object)this.headerText1)).setX(50.0);
        ((Text)Mockito.verify((Object)this.headerText1)).setY(8.0);
        ((Text)Mockito.verify((Object)this.headerText2)).setText((String)ArgumentMatchers.eq((Object)("(" + TYPE_REF + ")")));
        ((Text)Mockito.verify((Object)this.headerText2)).setX(50.0);
        ((Text)Mockito.verify((Object)this.headerText2)).setY(24.0);
        ((Text)Mockito.verify((Object)this.headerText2)).setFontStyle("italic");
        ((Text)Mockito.verify((Object)this.headerText2)).setFontSize(8.0);
        ((Group)Mockito.verify((Object)this.headerGroup)).add((IPrimitive)this.headerText1);
        ((Group)Mockito.verify((Object)this.headerGroup)).add((IPrimitive)this.headerText2);
    }
}

