/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.util;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.util.TypeRefUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TypeRefUtilsTest {
    private static final QName TYPE_REF = new QName();
    @Mock
    private HasExpression hasExpression;
    @Mock
    private Decision decision;
    @Mock
    private InformationItemPrimary decisionVariable;
    @Mock
    private DecisionTable expression;

    @Test
    public void testGetTypeRefOfExpression() {
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)((DMNModelInstrumentedBase)Mockito.mock(DMNModelInstrumentedBase.class)));
        Mockito.when((Object)this.expression.getTypeRef()).thenReturn((Object)TYPE_REF);
        Assertions.assertThat((Object)TypeRefUtils.getTypeRefOfExpression((Expression)this.expression, (HasExpression)this.hasExpression).getTypeRef()).isEqualTo((Object)TYPE_REF);
    }

    @Test
    public void testGetTypeRefOfExpressionWhenHasExpressionHasVariable() {
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)this.decision);
        Mockito.when((Object)this.decision.getVariable()).thenReturn((Object)this.decisionVariable);
        Mockito.when((Object)this.decisionVariable.getTypeRef()).thenReturn((Object)TYPE_REF);
        Assertions.assertThat((Object)TypeRefUtils.getTypeRefOfExpression((Expression)this.expression, (HasExpression)this.hasExpression).getTypeRef()).isEqualTo((Object)TYPE_REF);
    }
}

