/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.ImportFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ImportFactoryTest {
    @Mock
    private IncludedModelsIndex modelsIndex;
    private ImportFactory factory;

    @Before
    public void setup() {
        this.factory = new ImportFactory(this.modelsIndex);
    }

    @Test
    public void testMakeDMNImport() {
        DMNIncludedModelActiveRecord record = new DMNIncludedModelActiveRecord(null);
        String expectedImportType = DMNImportTypes.DMN.getDefaultNamespace();
        String nameValue = "name";
        String path = "/src/main/kie/dmn";
        Name expectedName = new Name("name");
        LocationURI expectedLocationURI = new LocationURI("/src/main/kie/dmn");
        String expectedNamespace = "://namespace";
        int expectedDrgElementsCount = 2;
        int expectedItemDefinitionsCount = 3;
        record.setName("name");
        record.setPath("/src/main/kie/dmn");
        record.setNamespace("://namespace");
        record.setImportType(DMNImportTypes.DMN.getDefaultNamespace());
        record.setDrgElementsCount(Integer.valueOf(2));
        record.setDataTypesCount(Integer.valueOf(3));
        Import actualImport = this.factory.makeImport((BaseIncludedModelActiveRecord)record);
        Assert.assertTrue((boolean)(actualImport instanceof ImportDMN));
        ImportDMN dmnImport = (ImportDMN)actualImport;
        Assert.assertEquals((Object)expectedImportType, (Object)actualImport.getImportType());
        Assert.assertEquals((Object)expectedName, (Object)actualImport.getName());
        Assert.assertEquals((Object)expectedLocationURI, (Object)actualImport.getLocationURI());
        Assert.assertEquals((Object)"://namespace", (Object)actualImport.getNamespace());
        Assert.assertEquals((Object)expectedImportType, (Object)actualImport.getImportType());
        Assert.assertEquals((long)2L, (long)dmnImport.getDrgElementsCount());
        Assert.assertEquals((long)3L, (long)dmnImport.getItemDefinitionsCount());
    }

    @Test
    public void testMakePMMLImport() {
        PMMLIncludedModelActiveRecord record = new PMMLIncludedModelActiveRecord(null);
        String expectedImportType = DMNImportTypes.PMML.getDefaultNamespace();
        String expectedNameValue = "name";
        String path = "/src/main/kie/pmml";
        Name expectedName = new Name("name");
        LocationURI expectedLocationURI = new LocationURI("/src/main/kie/pmml");
        int expectedModelCount = 2;
        record.setPath("/src/main/kie/pmml");
        record.setName("name");
        record.setNamespace("name");
        record.setImportType(DMNImportTypes.PMML.getDefaultNamespace());
        record.setModelCount(Integer.valueOf(2));
        Import actualImport = this.factory.makeImport((BaseIncludedModelActiveRecord)record);
        Assert.assertTrue((boolean)(actualImport instanceof ImportPMML));
        ImportPMML pmmlImport = (ImportPMML)actualImport;
        Assert.assertEquals((Object)expectedImportType, (Object)actualImport.getImportType());
        Assert.assertEquals((Object)expectedName, (Object)actualImport.getName());
        Assert.assertEquals((Object)expectedLocationURI, (Object)actualImport.getLocationURI());
        Assert.assertEquals((Object)"name", (Object)actualImport.getNamespace());
        Assert.assertEquals((Object)expectedImportType, (Object)actualImport.getImportType());
        Assert.assertEquals((long)2L, (long)pmmlImport.getModelCount());
    }

    @Test
    public void testName() {
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Import import3 = (Import)Mockito.mock(Import.class);
        List<Import> imports = Arrays.asList(import1, import2, import3);
        DMNIncludedModelActiveRecord record = new DMNIncludedModelActiveRecord(null);
        Mockito.when((Object)import1.getName()).thenReturn((Object)new Name("foo"));
        Mockito.when((Object)import2.getName()).thenReturn((Object)new Name("bar"));
        Mockito.when((Object)import3.getName()).thenReturn((Object)new Name("foo bar"));
        Mockito.when((Object)this.modelsIndex.getIndexedImports()).thenReturn(imports);
        record.setName("bla");
        Name name = this.factory.name((BaseIncludedModelActiveRecord)record);
        String expected = "bla";
        String actual = name.getValue();
        Assert.assertEquals((Object)"bla", (Object)actual);
    }

    @Test
    public void testNameWithExistingName() {
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Import import3 = (Import)Mockito.mock(Import.class);
        List<Import> imports = Arrays.asList(import1, import2, import3);
        DMNIncludedModelActiveRecord record = new DMNIncludedModelActiveRecord(null);
        Mockito.when((Object)import1.getName()).thenReturn((Object)new Name("foo"));
        Mockito.when((Object)import2.getName()).thenReturn((Object)new Name("bar"));
        Mockito.when((Object)import3.getName()).thenReturn((Object)new Name("foo bar"));
        Mockito.when((Object)this.modelsIndex.getIndexedImports()).thenReturn(imports);
        record.setName("foo");
        Name name = this.factory.name((BaseIncludedModelActiveRecord)record);
        String expected = "foo - 2";
        String actual = name.getValue();
        Assert.assertEquals((Object)"foo - 2", (Object)actual);
    }
}

