/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.search.DMNGraphSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasFocusedShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGraphSubIndexTest {
    @Mock
    private DMNGraphUtils graphUtils;
    @Mock
    private EventSourceMock<CanvasSelectionEvent> canvasSelectionEvent;
    @Mock
    private EventSourceMock<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent;
    @Mock
    private EventSourceMock<CanvasClearSelectionEvent> canvasClearSelectionEventEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    @Mock
    private Node node3;
    @Mock
    private Node node4;
    @Mock
    private Node node5;
    @Mock
    private Node node6;
    @Mock
    private Definition definition1;
    @Mock
    private Definition definition2;
    @Mock
    private Definition definition3;
    @Mock
    private Definition definition4;
    @Mock
    private Definition definition5;
    @Mock
    private DRGElement drgElement1;
    @Mock
    private DRGElement drgElement2;
    @Mock
    private DRGElement drgElement3;
    @Mock
    private TextAnnotation textAnnotation1;
    @Mock
    private TextAnnotation textAnnotation2;
    @Mock
    private CanvasHandler canvasHandler;
    private String drgElement1String = "DRG Element 1";
    private String drgElement2String = "DRG Element 2";
    private String drgElement3String = "DRG Element 3";
    private String textAnnotation1String = "Text Annotation 1";
    private String textAnnotation2String = "Text Annotation 2";
    private String uuid1 = "1111-1111";
    private String uuid2 = "2222-2222";
    private String uuid3 = "3333-3333";
    private String uuid4 = "4444-4444";
    private String uuid5 = "5555-5555";
    private String uuid6 = "6666-6666";
    private DMNGraphSubIndex index;

    @Before
    public void setup() {
        this.index = new DMNGraphSubIndex(this.graphUtils, this.canvasSelectionEvent, this.canvasFocusedSelectionEvent, this.canvasClearSelectionEventEvent, this.domainObjectSelectionEvent);
        Mockito.when((Object)this.node1.getUUID()).thenReturn((Object)this.uuid1);
        Mockito.when((Object)this.node2.getUUID()).thenReturn((Object)this.uuid2);
        Mockito.when((Object)this.node3.getUUID()).thenReturn((Object)this.uuid3);
        Mockito.when((Object)this.node4.getUUID()).thenReturn((Object)this.uuid4);
        Mockito.when((Object)this.node5.getUUID()).thenReturn((Object)this.uuid5);
        Mockito.when((Object)this.node6.getUUID()).thenReturn((Object)this.uuid6);
        Mockito.when((Object)this.node1.getContent()).thenReturn((Object)this.definition1);
        Mockito.when((Object)this.node2.getContent()).thenReturn((Object)this.definition2);
        Mockito.when((Object)this.node3.getContent()).thenReturn((Object)this.definition3);
        Mockito.when((Object)this.node4.getContent()).thenReturn((Object)this.definition4);
        Mockito.when((Object)this.node5.getContent()).thenReturn((Object)this.definition5);
        Mockito.when((Object)this.definition1.getDefinition()).thenReturn((Object)this.drgElement1);
        Mockito.when((Object)this.definition2.getDefinition()).thenReturn((Object)this.drgElement2);
        Mockito.when((Object)this.definition3.getDefinition()).thenReturn((Object)this.drgElement3);
        Mockito.when((Object)this.definition4.getDefinition()).thenReturn((Object)this.textAnnotation1);
        Mockito.when((Object)this.definition5.getDefinition()).thenReturn((Object)this.textAnnotation2);
        Mockito.when((Object)this.drgElement1.getName()).thenReturn((Object)new Name(this.drgElement1String));
        Mockito.when((Object)this.drgElement2.getName()).thenReturn((Object)new Name(this.drgElement2String));
        Mockito.when((Object)this.drgElement3.getName()).thenReturn((Object)new Name(this.drgElement3String));
        Mockito.when((Object)this.textAnnotation1.getText()).thenReturn((Object)new Text(this.textAnnotation1String));
        Mockito.when((Object)this.textAnnotation2.getText()).thenReturn((Object)new Text(this.textAnnotation2String));
        Mockito.when((Object)this.graphUtils.getNodeStream()).thenReturn(Stream.of(this.node1, this.node2, this.node3, this.node4, this.node5, this.node6));
        Mockito.when((Object)this.graphUtils.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
    }

    @Test
    public void testGetSearchableElements() {
        List elements = this.index.getSearchableElements().stream().sorted(Comparator.comparing(DMNSearchableElement::getText)).collect(Collectors.toList());
        Assert.assertEquals((long)5L, (long)elements.size());
        Assert.assertEquals((Object)this.drgElement1String, (Object)((DMNSearchableElement)elements.get(0)).getText());
        Assert.assertEquals((Object)this.drgElement2String, (Object)((DMNSearchableElement)elements.get(1)).getText());
        Assert.assertEquals((Object)this.drgElement3String, (Object)((DMNSearchableElement)elements.get(2)).getText());
        Assert.assertEquals((Object)this.textAnnotation1String, (Object)((DMNSearchableElement)elements.get(3)).getText());
        Assert.assertEquals((Object)this.textAnnotation2String, (Object)((DMNSearchableElement)elements.get(4)).getText());
        ((DMNSearchableElement)elements.get(0)).onFound().execute();
        ((DMNSearchableElement)elements.get(1)).onFound().execute();
        ((DMNSearchableElement)elements.get(2)).onFound().execute();
        ((DMNSearchableElement)elements.get(3)).onFound().execute();
        ((DMNSearchableElement)elements.get(4)).onFound().execute();
        ((EventSourceMock)Mockito.verify(this.canvasSelectionEvent, (VerificationMode)Mockito.times((int)5))).fire((Object)((CanvasSelectionEvent)ArgumentMatchers.any(CanvasSelectionEvent.class)));
        ((EventSourceMock)Mockito.verify(this.canvasFocusedSelectionEvent, (VerificationMode)Mockito.times((int)5))).fire((Object)((CanvasFocusedShapeEvent)ArgumentMatchers.any(CanvasFocusedShapeEvent.class)));
    }

    @Test
    public void testOnNoResultsFound() {
        this.index.onNoResultsFound();
        ((EventSourceMock)Mockito.verify(this.canvasClearSelectionEventEvent)).fire((Object)((CanvasClearSelectionEvent)ArgumentMatchers.any(CanvasClearSelectionEvent.class)));
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)ArgumentMatchers.any(DomainObjectSelectionEvent.class)));
    }
}

