/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.mockito.Mockito;

public class HiddenHelperTest {
    @Test
    public void testHide() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HiddenHelper.hide((Element)element);
        ((DOMTokenList)Mockito.verify((Object)classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testShow() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HiddenHelper.show((Element)element);
        ((DOMTokenList)Mockito.verify((Object)classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testIsHiddenWhenElementIsHidden() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains("hidden")).thenReturn((Object)true);
        Assert.assertTrue((boolean)HiddenHelper.isHidden((Element)element));
    }

    @Test
    public void testIsHiddenWhenElementIsNotHidden() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains("hidden")).thenReturn((Object)false);
        Assert.assertFalse((boolean)HiddenHelper.isHidden((Element)element));
    }
}

