/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.Node;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.client.editors.types.imported.ImportDataObjectModal;
import org.kie.workbench.common.dmn.client.editors.types.imported.ImportDataObjectModalView;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeList;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ImportDataObjectModalViewTest {
    private ImportDataObjectModalView view;
    @Mock
    private HTMLDivElement header;
    @Mock
    private HTMLDivElement body;
    @Mock
    private HTMLDivElement footer;
    @Mock
    private TreeList treeList;
    @Mock
    private HTMLElement noteText;
    @Mock
    private HTMLLabelElement noteLabel;
    @Mock
    private HTMLDivElement itemsContainer;
    @Mock
    private HTMLAnchorElement clearSelection;
    @Mock
    private ManagedInstance<TreeListItem> items;
    @Mock
    private HTMLButtonElement buttonImport;
    @Mock
    private HTMLButtonElement buttonCancel;
    @Mock
    private ImportDataObjectModal presenter;
    @Mock
    private Node treeListElement;
    @Mock
    private HTMLDivElement warningContainer;
    @Captor
    private ArgumentCaptor<List<TreeListItem>> itemsCaptor;
    @Captor
    private ArgumentCaptor<List<DataObject>> dataObjectsCaptor;

    @Before
    public void setup() {
        this.view = (ImportDataObjectModalView)Mockito.spy((Object)new ImportDataObjectModalView(this.header, this.body, this.footer, this.treeList, this.noteText, this.noteLabel, this.itemsContainer, this.clearSelection, this.items, this.buttonImport, this.buttonCancel, this.warningContainer));
        this.view.init(this.presenter);
        Mockito.when((Object)this.treeList.getElement()).thenReturn((Object)this.treeListElement);
    }

    @Test
    public void testGetHeader() {
        String text = "The text";
        this.header.textContent = "The text";
        String actual = this.view.getHeader();
        Assert.assertEquals((Object)actual, (Object)"The text");
    }

    @Test
    public void testOnButtonCancelClicked() {
        this.view.onButtonCancelClicked(null);
        ((ImportDataObjectModal)Mockito.verify((Object)this.presenter)).hide();
    }

    @Test
    public void testOnButtonImportClicked() {
        List selectedItems = (List)Mockito.mock(List.class);
        ((ImportDataObjectModalView)Mockito.doReturn((Object)selectedItems).when((Object)this.view)).getSelectedItems();
        this.view.onButtonImportClicked(null);
        ((ImportDataObjectModal)Mockito.verify((Object)this.presenter)).hide(selectedItems);
    }

    @Test
    public void testGetSelectedItems() {
        TreeListItem listItem1 = (TreeListItem)Mockito.mock(TreeListItem.class);
        DataObject dataObject1 = (DataObject)Mockito.mock(DataObject.class);
        TreeListItem listItem2 = (TreeListItem)Mockito.mock(TreeListItem.class);
        DataObject dataObject2 = (DataObject)Mockito.mock(DataObject.class);
        Mockito.when((Object)listItem1.getDataSource()).thenReturn((Object)dataObject1);
        Mockito.when((Object)listItem2.getDataSource()).thenReturn((Object)dataObject2);
        List<TreeListItem> selectedItems = Arrays.asList(listItem1, listItem2);
        Mockito.when((Object)this.treeList.getSelectedItems()).thenReturn(selectedItems);
        List actual = this.view.getSelectedItems();
        Assert.assertEquals((long)2L, (long)actual.size());
        Assert.assertTrue((boolean)actual.contains(dataObject1));
        Assert.assertTrue((boolean)actual.contains(dataObject2));
    }

    @Test
    public void testOnClearSelectionClicked() {
        this.view.onClearSelectionClicked(null);
        ((ImportDataObjectModalView)Mockito.doNothing().when((Object)this.view)).refresh();
        ((TreeList)Mockito.verify((Object)this.treeList)).refresh();
        ((ImportDataObjectModalView)Mockito.verify((Object)this.view)).refresh();
    }

    @Test
    public void testAddItems() {
        String d1Name = "ClassOne";
        String d2Name = "ClassTwo";
        String d3Name = "ClassThree";
        DataObject d1 = new DataObject("ClassOne");
        DataObject d2 = new DataObject("ClassTwo");
        DataObject d3 = new DataObject("ClassThree");
        List<DataObject> dataObjects = Arrays.asList(d1, d2, d3);
        TreeListItem list1 = (TreeListItem)Mockito.mock(TreeListItem.class);
        TreeListItem list2 = (TreeListItem)Mockito.mock(TreeListItem.class);
        TreeListItem list3 = (TreeListItem)Mockito.mock(TreeListItem.class);
        ((ImportDataObjectModalView)Mockito.doReturn((Object)list1).when((Object)this.view)).createTreeListItem(d1);
        ((ImportDataObjectModalView)Mockito.doReturn((Object)list2).when((Object)this.view)).createTreeListItem(d2);
        ((ImportDataObjectModalView)Mockito.doReturn((Object)list3).when((Object)this.view)).createTreeListItem(d3);
        this.view.addItems(dataObjects);
        ((HTMLDivElement)Mockito.verify((Object)this.itemsContainer)).appendChild(this.treeListElement);
        ((TreeList)Mockito.verify((Object)this.treeList)).populate((List)this.itemsCaptor.capture());
        List dataObjectItems = (List)this.itemsCaptor.getValue();
        Assert.assertEquals((long)3L, (long)dataObjectItems.size());
        Assert.assertTrue((boolean)dataObjectItems.contains(list1));
        Assert.assertTrue((boolean)dataObjectItems.contains(list2));
        Assert.assertTrue((boolean)dataObjectItems.contains(list3));
    }

    @Test
    public void testCreateTreeListItem() {
        TreeListItem item = (TreeListItem)Mockito.mock(TreeListItem.class);
        Mockito.when((Object)((TreeListItem)this.items.get())).thenReturn((Object)item);
        String myClass = "my class";
        DataObject data = new DataObject("my class");
        TreeListItem actual = this.view.createTreeListItem(data);
        Assert.assertEquals((Object)item, (Object)actual);
        ((TreeListItem)Mockito.verify((Object)item)).setDescription("my class");
    }

    @Test
    public void testRefresh() {
        ((ImportDataObjectModalView)Mockito.doNothing().when((Object)this.view)).removeTreeList();
        this.view.refresh();
        ((TreeList)Mockito.verify((Object)this.treeList)).refresh();
        ((HTMLDivElement)Mockito.verify((Object)this.itemsContainer)).appendChild(this.treeListElement);
    }

    @Test
    public void testClear() {
        ((ImportDataObjectModalView)Mockito.doNothing().when((Object)this.view)).removeTreeList();
        this.view.clear();
        ((ImportDataObjectModalView)Mockito.verify((Object)this.view)).removeTreeList();
        ((TreeList)Mockito.verify((Object)this.treeList)).clear();
    }

    @Test
    public void testRemoveTreeList() {
        Mockito.when((Object)this.itemsContainer.contains(this.treeListElement)).thenReturn((Object)true);
        this.view.removeTreeList();
        ((HTMLDivElement)Mockito.verify((Object)this.itemsContainer)).removeChild(this.treeListElement);
    }

    @Test
    public void testRemoveTreeListWhenIsNotPresent() {
        Mockito.when((Object)this.itemsContainer.contains(this.treeListElement)).thenReturn((Object)false);
        this.view.removeTreeList();
        ((HTMLDivElement)Mockito.verify((Object)this.itemsContainer, (VerificationMode)Mockito.never())).removeChild(this.treeListElement);
    }

    @Test
    public void testSetup() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((ImportDataObjectModalView)Mockito.doReturn((Object)consumer).when((Object)this.view)).getOnSelectionChanged();
        this.view.setup();
        ((TreeList)Mockito.verify((Object)this.treeList)).setOnSelectionChanged(consumer);
    }

    @Test
    public void testOnSelectionChanged() {
        DataObject do1 = (DataObject)Mockito.mock(DataObject.class);
        DataObject do2 = (DataObject)Mockito.mock(DataObject.class);
        DataObject do3 = (DataObject)Mockito.mock(DataObject.class);
        TreeListItem treeListItem1 = (TreeListItem)Mockito.mock(TreeListItem.class);
        TreeListItem treeListItem2 = (TreeListItem)Mockito.mock(TreeListItem.class);
        TreeListItem treeListItem3 = (TreeListItem)Mockito.mock(TreeListItem.class);
        Mockito.when((Object)treeListItem1.getDataSource()).thenReturn((Object)do1);
        Mockito.when((Object)treeListItem2.getDataSource()).thenReturn((Object)do2);
        Mockito.when((Object)treeListItem3.getDataSource()).thenReturn((Object)do3);
        this.view.onSelectionChanged(Arrays.asList(treeListItem1, treeListItem2, treeListItem3));
        ((ImportDataObjectModal)Mockito.verify((Object)this.presenter)).onDataObjectSelectionChanged((List)this.dataObjectsCaptor.capture());
        List values = (List)this.dataObjectsCaptor.getValue();
        Assert.assertEquals((long)3L, (long)values.size());
        Assertions.assertThat((List)values).containsExactly((Object[])new DataObject[]{do1, do2, do3});
    }

    @Test
    public void testShowDataTypeWithSameNameWarning() {
        this.warningContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showDataTypeWithSameNameWarning();
        ((DOMTokenList)Mockito.verify((Object)this.warningContainer.classList)).add(new String[]{"opened"});
    }

    @Test
    public void testHideDataTypeWithSameNameWarning() {
        this.warningContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideDataTypeWithSameNameWarning();
        ((DOMTokenList)Mockito.verify((Object)this.warningContainer.classList)).remove(new String[]{"opened"});
    }
}

