/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported.treelist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListSubItem;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class TreeListItemTest {
    @Mock
    private TreeListItem.View view;
    @Mock
    private HTMLElement viewElement;
    private TreeListItem treeListItem;

    @Before
    public void setup() {
        this.treeListItem = (TreeListItem)Mockito.spy((Object)new TreeListItem(this.view));
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)this.viewElement);
    }

    @Test
    public void testSetup() {
        this.treeListItem.setup();
        ((TreeListItem.View)Mockito.verify((Object)this.view)).init((Object)this.treeListItem);
    }

    @Test
    public void testGetElement() {
        Node actual = this.treeListItem.getElement();
        Assert.assertEquals((Object)this.viewElement, (Object)actual);
    }

    @Test
    public void testGetSetDescription() {
        String description = "Description.";
        this.treeListItem.setDescription("Description.");
        String actual = this.treeListItem.getDescription();
        Assert.assertEquals((Object)"Description.", (Object)actual);
    }

    @Test
    public void testAddSubItem() {
        TreeListSubItem subItem = (TreeListSubItem)Mockito.mock(TreeListSubItem.class);
        this.treeListItem.addSubItem(subItem);
    }

    @Test
    public void testUpdateView() {
        this.treeListItem.updateView();
        ((TreeListItem.View)Mockito.verify((Object)this.view)).populate(this.treeListItem);
    }

    @Test
    public void testGetSetIsSelected() {
        ((TreeListItem)Mockito.doNothing().when((Object)this.treeListItem)).callOnIsSelectedChanged();
        this.treeListItem.setIsSelected(true);
        Assert.assertTrue((boolean)this.treeListItem.getIsSelected());
        this.treeListItem.setIsSelected(false);
        Assert.assertFalse((boolean)this.treeListItem.getIsSelected());
        ((TreeListItem)Mockito.verify((Object)this.treeListItem, (VerificationMode)Mockito.times((int)2))).callOnIsSelectedChanged();
    }

    @Test
    public void testCallOnIsSelectedChanged() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((TreeListItem)Mockito.doReturn((Object)consumer).when((Object)this.treeListItem)).getOnIsSelectedChanged();
        this.treeListItem.callOnIsSelectedChanged();
        ((Consumer)Mockito.verify((Object)consumer)).accept(this.treeListItem);
    }

    @Test
    public void testCallOnIsSelectedChangedWhenConsumerIsNotSet() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((TreeListItem)Mockito.doReturn(null).when((Object)this.treeListItem)).getOnIsSelectedChanged();
        this.treeListItem.callOnIsSelectedChanged();
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(this.treeListItem);
    }
}

