/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLOptGroupElement;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Lists;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelectView;
import org.kie.workbench.common.dmn.client.editors.types.listview.tooltip.StructureTypesTooltip;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerTarget;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSelectViewTest {
    @Mock
    private HTMLDivElement typeText;
    @Mock
    private HTMLSelectElement typeSelect;
    @Mock
    private HTMLOptGroupElement typeSelectOptGroup;
    @Mock
    private HTMLOptionElement typeSelectOption;
    @Mock
    private DataTypeSelect presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private StructureTypesTooltip structureTypesTooltip;
    @Captor
    private ArgumentCaptor<DataType> dataTypeCaptor;
    private DataTypeUtils dataTypeUtils;
    private DataTypeSelectView view;

    @Before
    public void setup() {
        this.view = (DataTypeSelectView)Mockito.spy((Object)new DataTypeSelectView(this.typeText, this.typeSelect, this.typeSelectOptGroup, this.typeSelectOption, null, this.translationService, this.structureTypesTooltip));
        this.dataTypeUtils = new DataTypeUtils(this.dataTypeStore, this.dataTypeManager, this.dmnGraphUtils);
        this.view.init(this.presenter);
    }

    @Test
    public void testSetupDropdown() {
        ((DataTypeSelectView)Mockito.doCallRealMethod().when((Object)this.view)).setupDropdown();
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).setupDropdownItems();
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).setupSelectPicker();
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).hideSelectPicker();
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).setupSelectPickerOnChangeHandler();
        this.view.setupDropdown();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).setupDropdownItems();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).setupSelectPicker();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).hideSelectPicker();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).setupSelectPickerOnChangeHandler();
    }

    @Test
    public void testSetupDropdownItems() {
        HTMLOptGroupElement groupElementStructure = (HTMLOptGroupElement)Mockito.mock(HTMLOptGroupElement.class);
        HTMLOptGroupElement groupElementCustom = (HTMLOptGroupElement)Mockito.mock(HTMLOptGroupElement.class);
        HTMLOptGroupElement groupElementDefault = (HTMLOptGroupElement)Mockito.mock(HTMLOptGroupElement.class);
        ArrayList defaultDataTypes = new ArrayList();
        ArrayList customDataTypes = new ArrayList();
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.translationService.format("DataTypeSelectView.DefaultTitle", new Object[0])).thenReturn((Object)"Default");
        Mockito.when((Object)this.translationService.format("DataTypeSelectView.CustomTitle", new Object[0])).thenReturn((Object)"Custom");
        Mockito.when((Object)this.presenter.getDefaultDataTypes()).thenReturn(defaultDataTypes);
        Mockito.when((Object)this.presenter.getCustomDataTypes()).thenReturn(customDataTypes);
        ((DataTypeSelectView)Mockito.doReturn((Object)groupElementStructure).when((Object)this.view)).makeOptionStructureGroup();
        ((DataTypeSelectView)Mockito.doReturn((Object)groupElementDefault).when((Object)this.view)).makeOptionGroup((String)ArgumentMatchers.eq((Object)"Default"), (List)ArgumentMatchers.eq(defaultDataTypes), (Function)ArgumentMatchers.any());
        ((DataTypeSelectView)Mockito.doReturn((Object)groupElementCustom).when((Object)this.view)).makeOptionGroup((String)ArgumentMatchers.eq((Object)"Custom"), (List)ArgumentMatchers.eq(customDataTypes), (Function)ArgumentMatchers.any());
        this.typeSelect.firstChild = element;
        Mockito.when((Object)this.typeSelect.removeChild((Node)element)).then(a -> {
            this.typeSelect.firstChild = null;
            return element;
        });
        this.view.setupDropdownItems();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.typeSelect, element, groupElementStructure, groupElementDefault, groupElementCustom});
        ((HTMLSelectElement)inOrder.verify((Object)this.typeSelect)).removeChild((Node)element);
        ((HTMLSelectElement)inOrder.verify((Object)this.typeSelect)).appendChild((Node)groupElementStructure);
        ((HTMLSelectElement)inOrder.verify((Object)this.typeSelect)).appendChild((Node)groupElementDefault);
        ((HTMLSelectElement)inOrder.verify((Object)this.typeSelect)).appendChild((Node)groupElementCustom);
    }

    @Test
    public void testMakeOptionGroup() {
        String dataTypeName = "name";
        String groupTitle = "Title";
        DataType dataType = this.makeDataType("name");
        List<DataType> dataTypes = Collections.singletonList(dataType);
        HTMLOptGroupElement expectedGroupElement = (HTMLOptGroupElement)Mockito.mock(HTMLOptGroupElement.class);
        HTMLOptionElement optionElement = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        ((DataTypeSelectView)Mockito.doReturn((Object)expectedGroupElement).when((Object)this.view)).makeHTMLOptGroupElement();
        ((DataTypeSelectView)Mockito.doReturn((Object)optionElement).when((Object)this.view)).makeOption((DataType)ArgumentMatchers.eq((Object)dataType), (Function)ArgumentMatchers.any(Function.class));
        HTMLOptGroupElement actualGroupElement = this.view.makeOptionGroup("Title", dataTypes, DataType::getName);
        ((HTMLOptGroupElement)Mockito.verify((Object)expectedGroupElement)).appendChild((Node)optionElement);
        Assert.assertEquals((Object)expectedGroupElement, (Object)actualGroupElement);
        Assert.assertEquals((Object)"Title", (Object)actualGroupElement.label);
    }

    @Test
    public void testOptionGroupSorting() {
        HTMLOptGroupElement groupElement = (HTMLOptGroupElement)Mockito.mock(HTMLOptGroupElement.class);
        HTMLOptionElement optionElement = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        DataType customDataType1 = this.makeDataType("b");
        DataType customDataType2 = this.makeDataType("a");
        List customDataTypes = new Lists.Builder().add((Object)customDataType1).add((Object)customDataType2).build();
        ((DataTypeSelectView)Mockito.doReturn((Object)groupElement).when((Object)this.view)).makeHTMLOptGroupElement();
        ((DataTypeSelectView)Mockito.doReturn((Object)optionElement).when((Object)this.view)).makeHTMLOptionElement();
        Mockito.when((Object)this.translationService.format("DataTypeSelectView.DefaultTitle", new Object[0])).thenReturn((Object)"Default");
        Mockito.when((Object)this.translationService.format("DataTypeSelectView.CustomTitle", new Object[0])).thenReturn((Object)"Custom");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn((Object)customDataTypes);
        ((DataTypeManager)Mockito.doAnswer(i -> {
            BuiltInType bit = (BuiltInType)i.getArguments()[0];
            DataTypeManager dtm = (DataTypeManager)Mockito.mock(DataTypeManager.class);
            DataType dt = this.makeDataType(bit.getName());
            Mockito.when((Object)dtm.get()).thenReturn((Object)dt);
            return dtm;
        }).when((Object)this.dataTypeManager)).from((BuiltInType)ArgumentMatchers.any(BuiltInType.class));
        ((DataTypeSelect)Mockito.doAnswer(i -> this.dataTypeUtils.defaultDataTypes()).when((Object)this.presenter)).getDefaultDataTypes();
        ((DataTypeSelect)Mockito.doAnswer(i -> this.dataTypeUtils.customDataTypes()).when((Object)this.presenter)).getCustomDataTypes();
        this.view.setupDropdownItems();
        int visibleItems = BuiltInType.values().length - 1;
        ((DataTypeSelectView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)(visibleItems + customDataTypes.size())))).makeOption((DataType)this.dataTypeCaptor.capture(), (Function)ArgumentMatchers.any(Function.class));
        List dataTypes = this.dataTypeCaptor.getAllValues();
        Assert.assertEquals((Object)"Any", (Object)((DataType)dataTypes.get(0)).getType());
        Assert.assertEquals((Object)"boolean", (Object)((DataType)dataTypes.get(1)).getType());
        Assert.assertEquals((Object)"context", (Object)((DataType)dataTypes.get(2)).getType());
        Assert.assertEquals((Object)"date", (Object)((DataType)dataTypes.get(3)).getType());
        Assert.assertEquals((Object)"date and time", (Object)((DataType)dataTypes.get(4)).getType());
        Assert.assertEquals((Object)"days and time duration", (Object)((DataType)dataTypes.get(5)).getType());
        Assert.assertEquals((Object)"number", (Object)((DataType)dataTypes.get(6)).getType());
        Assert.assertEquals((Object)"string", (Object)((DataType)dataTypes.get(7)).getType());
        Assert.assertEquals((Object)"time", (Object)((DataType)dataTypes.get(8)).getType());
        Assert.assertEquals((Object)"years and months duration", (Object)((DataType)dataTypes.get(9)).getType());
        int customDataTypesOffset = visibleItems;
        Assert.assertEquals((Object)"a", (Object)((DataType)dataTypes.get(customDataTypesOffset)).getType());
        Assert.assertEquals((Object)"b", (Object)((DataType)dataTypes.get(customDataTypesOffset + 1)).getType());
    }

    @Test
    public void testMakeOption() {
        String value = "value";
        DataType dataType = this.makeDataType("value");
        HTMLOptionElement htmlOptionElement = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        ((DataTypeSelectView)Mockito.doReturn((Object)htmlOptionElement).when((Object)this.view)).makeHTMLOptionElement();
        HTMLOptionElement option = this.view.makeOption(dataType, DataType::getName);
        Assert.assertEquals((Object)"value", (Object)option.text);
        Assert.assertEquals((Object)"value", (Object)option.value);
    }

    @Test
    public void testSetDataTypeWhenItsNotBuiltInType() {
        String expectedType = "type";
        DataType dataType = this.makeDataType("type");
        this.view.setDataType(dataType);
        String actualType = this.view.getValue();
        String actualTypeText = this.typeText.textContent;
        Assert.assertEquals((Object)"type", (Object)actualType);
        Assert.assertEquals((Object)"type", (Object)actualTypeText);
        ((HTMLDivElement)Mockito.verify((Object)this.typeText)).setAttribute("data-is-built-in-type", false);
    }

    @Test
    public void testSetDataTypeWhenItsBuiltInType() {
        String expectedType = "string";
        DataType dataType = this.makeDataType("string");
        this.view.setDataType(dataType);
        String actualType = this.view.getValue();
        String actualTypeText = this.typeText.textContent;
        Assert.assertEquals((Object)"string", (Object)actualType);
        Assert.assertEquals((Object)"string", (Object)actualTypeText);
        ((HTMLDivElement)Mockito.verify((Object)this.typeText)).setAttribute("data-is-built-in-type", true);
    }

    @Test
    public void testOnTypeTextClickWhenItsNotBuiltInType() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        String type = "tPerson";
        DataType dataType = this.makeDataType("tPerson");
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.presenter.getDataType()).thenReturn((Object)dataType);
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.onTypeTextClick(event);
        ((StructureTypesTooltip)Mockito.verify((Object)this.structureTypesTooltip)).show(element, "tPerson");
        ((ClickEvent)Mockito.verify((Object)event)).preventDefault();
        ((ClickEvent)Mockito.verify((Object)event)).stopPropagation();
    }

    @Test
    public void testOnTypeTextClickWhenItsBuiltInType() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        String type = "string";
        DataType dataType = this.makeDataType("string");
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.presenter.getDataType()).thenReturn((Object)dataType);
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.onTypeTextClick(event);
        ((StructureTypesTooltip)Mockito.verify((Object)this.structureTypesTooltip, (VerificationMode)Mockito.never())).show((HTMLElement)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        ((ClickEvent)Mockito.verify((Object)event)).preventDefault();
        ((ClickEvent)Mockito.verify((Object)event)).stopPropagation();
    }

    @Test
    public void testOnSelectChangeWhenOtherValueIsSet() {
        JQuerySelectPickerEvent event = (JQuerySelectPickerEvent)Mockito.mock(JQuerySelectPickerEvent.class);
        JQuerySelectPickerTarget target = (JQuerySelectPickerTarget)Mockito.mock(JQuerySelectPickerTarget.class);
        String newValue = "newValue";
        String oldValue = "oldValue";
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).setPickerValue("newValue");
        ((DataTypeSelectView)Mockito.doReturn((Object)"oldValue").when((Object)this.view)).getValue();
        event.target = target;
        target.value = "newValue";
        this.view.onSelectChange(event);
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).setPickerValue("newValue");
        ((DataTypeSelect)Mockito.verify((Object)this.presenter)).clearDataTypesList();
    }

    @Test
    public void testOnSelectChangeWhenTheSameValueIsSet() {
        JQuerySelectPickerEvent event = (JQuerySelectPickerEvent)Mockito.mock(JQuerySelectPickerEvent.class);
        JQuerySelectPickerTarget target = (JQuerySelectPickerTarget)Mockito.mock(JQuerySelectPickerTarget.class);
        String newValue = "value";
        String oldValue = "value";
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).setPickerValue("value");
        ((DataTypeSelectView)Mockito.doReturn((Object)"value").when((Object)this.view)).getValue();
        event.target = target;
        target.value = "value";
        this.view.onSelectChange(event);
        ((DataTypeSelectView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setPickerValue("value");
        ((DataTypeSelect)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).clearDataTypesList();
    }

    @Test
    public void testSetPickerValue() {
        Element element = (Element)Mockito.mock(Element.class);
        String value = "value";
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getSelectPicker();
        this.view.setPickerValue("value");
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).setPickerValue(element, "value");
    }

    @Test
    public void testSetupSelectPickerOnChangeHandler() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getSelectPicker();
        this.view.setupSelectPickerOnChangeHandler();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).setupOnChangeHandler(element);
    }

    @Test
    public void testHideSelectPicker() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getSelectPicker();
        this.view.hideSelectPicker();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).triggerPickerAction(element, "destroy");
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).triggerPickerAction(element, "hide");
    }

    @Test
    public void testShowSelectPicker() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getSelectPicker();
        this.view.showSelectPicker();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).triggerPickerAction(element, "show");
    }

    @Test
    public void testSetupSelectPicker() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getSelectPicker();
        this.view.setupSelectPicker();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).triggerPickerAction(element, "refresh");
    }

    @Test
    public void testGetSelectPicker() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement expectedSelect = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DataTypeSelectView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        Mockito.when((Object)element.querySelector("[data-field='type-select']")).thenReturn((Object)expectedSelect);
        Element actualSelect = this.view.getSelectPicker();
        Assert.assertEquals((Object)expectedSelect, (Object)actualSelect);
    }

    @Test
    public void testEnableEditMode() {
        String type = "type";
        DataType dataType = this.makeDataType("type");
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).showSelectPicker();
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).setPickerValue((String)Mockito.any());
        Mockito.when((Object)this.presenter.getDataType()).thenReturn((Object)dataType);
        this.typeText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.enableEditMode();
        ((DOMTokenList)Mockito.verify((Object)this.typeText.classList)).add(new String[]{"hidden"});
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).showSelectPicker();
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).setPickerValue("type");
    }

    @Test
    public void testDisableEditMode() {
        String expectedTypeText = "type";
        DataType dataType = this.makeDataType("type");
        ((DataTypeSelectView)Mockito.doNothing().when((Object)this.view)).hideSelectPicker();
        Mockito.when((Object)this.presenter.getDataType()).thenReturn((Object)dataType);
        this.typeText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.disableEditMode();
        Assert.assertEquals((Object)"type", (Object)this.typeText.textContent);
        ((DOMTokenList)Mockito.verify((Object)this.typeText.classList)).remove(new String[]{"hidden"});
        ((DataTypeSelectView)Mockito.verify((Object)this.view)).hideSelectPicker();
    }

    private DataType makeDataType(String name) {
        DataType dataType = (DataType)Mockito.spy((Object)new DataType(null));
        ((DataType)Mockito.doReturn((Object)"uuid").when((Object)dataType)).getUUID();
        ((DataType)Mockito.doReturn((Object)"parentUUID").when((Object)dataType)).getParentUUID();
        ((DataType)Mockito.doReturn((Object)name).when((Object)dataType)).getName();
        ((DataType)Mockito.doReturn((Object)name).when((Object)dataType)).getType();
        return dataType;
    }
}

