/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.common;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeStackHash;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.mockito.Mockito;

public class DataTypeStackHashTest {
    private DataTypeStore dataTypeStore;
    private DataTypeStackHash dataTypeStackHash;
    private DataType tCity;
    private DataType tCityId;
    private DataType tCityName;
    private DataType tPerson;
    private DataType tPersonId;
    private DataType tPersonName;
    private DataType tPersonCity;
    private DataType tPersonCityId;
    private DataType tPersonCityName;

    @Before
    public void setup() {
        this.dataTypeStore = new DataTypeStore();
        this.dataTypeStackHash = new DataTypeStackHash(this.dataTypeStore);
        this.tCity = this.makeDataType("001", "tCity", "");
        this.tCityId = this.makeDataType("002", "id", this.tCity.getUUID());
        this.tCityName = this.makeDataType("003", "name", this.tCity.getUUID());
        this.tPerson = this.makeDataType("004", "tPerson", "");
        this.tPersonId = this.makeDataType("005", "id", this.tPerson.getUUID());
        this.tPersonName = this.makeDataType("006", "name", this.tPerson.getUUID());
        this.tPersonCity = this.makeDataType("007", "city", this.tPerson.getUUID());
        this.tPersonCityId = this.makeDataType("008", "id", this.tPersonCity.getUUID());
        this.tPersonCityName = this.makeDataType("009", "name", this.tPersonCity.getUUID());
        this.index(this.tCity, this.tCityId, this.tCityName, this.tPerson, this.tPersonId, this.tPersonName, this.tPersonCity, this.tPersonCityId, this.tPersonCityName);
    }

    @Test
    public void testCalculateHash() {
        Assert.assertEquals((Object)"tCity", (Object)this.dataTypeStackHash.calculateHash(this.tCity));
        Assert.assertEquals((Object)"tCity.id", (Object)this.dataTypeStackHash.calculateHash(this.tCityId));
        Assert.assertEquals((Object)"tCity.name", (Object)this.dataTypeStackHash.calculateHash(this.tCityName));
        Assert.assertEquals((Object)"tPerson", (Object)this.dataTypeStackHash.calculateHash(this.tPerson));
        Assert.assertEquals((Object)"tPerson.id", (Object)this.dataTypeStackHash.calculateHash(this.tPersonId));
        Assert.assertEquals((Object)"tPerson.name", (Object)this.dataTypeStackHash.calculateHash(this.tPersonName));
        Assert.assertEquals((Object)"tPerson.city", (Object)this.dataTypeStackHash.calculateHash(this.tPersonCity));
        Assert.assertEquals((Object)"tPerson.city.id", (Object)this.dataTypeStackHash.calculateHash(this.tPersonCityId));
        Assert.assertEquals((Object)"tPerson.city.name", (Object)this.dataTypeStackHash.calculateHash(this.tPersonCityName));
    }

    @Test
    public void testCalculateParentHash() {
        this.index(this.tCity, this.tCityId, this.tCityName, this.tPerson, this.tPersonId, this.tPersonName, this.tPersonCity, this.tPersonCityId, this.tPersonCityName);
        Assert.assertEquals((Object)"", (Object)this.dataTypeStackHash.calculateParentHash(this.tCity));
        Assert.assertEquals((Object)"tCity", (Object)this.dataTypeStackHash.calculateParentHash(this.tCityId));
        Assert.assertEquals((Object)"tCity", (Object)this.dataTypeStackHash.calculateParentHash(this.tCityName));
        Assert.assertEquals((Object)"", (Object)this.dataTypeStackHash.calculateParentHash(this.tPerson));
        Assert.assertEquals((Object)"tPerson", (Object)this.dataTypeStackHash.calculateParentHash(this.tPersonId));
        Assert.assertEquals((Object)"tPerson", (Object)this.dataTypeStackHash.calculateParentHash(this.tPersonName));
        Assert.assertEquals((Object)"tPerson", (Object)this.dataTypeStackHash.calculateParentHash(this.tPersonCity));
        Assert.assertEquals((Object)"tPerson.city", (Object)this.dataTypeStackHash.calculateParentHash(this.tPersonCityId));
        Assert.assertEquals((Object)"tPerson.city", (Object)this.dataTypeStackHash.calculateParentHash(this.tPersonCityName));
    }

    private void index(DataType ... dataTypes) {
        for (DataType dataType : dataTypes) {
            this.dataTypeStore.index(dataType.getUUID(), dataType);
        }
    }

    private DataType makeDataType(String uuid, String name, String parentUUID) {
        DataType dataType = (DataType)Mockito.spy((Object)new DataType(null));
        ((DataType)Mockito.doReturn((Object)uuid).when((Object)dataType)).getUUID();
        ((DataType)Mockito.doReturn((Object)name).when((Object)dataType)).getName();
        ((DataType)Mockito.doReturn((Object)parentUUID).when((Object)dataType)).getParentUUID();
        return dataType;
    }
}

