/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.confirmation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.DataTypeHasFieldsWarningMessage;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeHasFieldsWarningMessageTest {
    @Mock
    private TranslationService translationService;

    @Test
    public void testGetStrongMessage() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String expectedWarningMessage = "*Expected strong message.*";
        DataTypeHasFieldsWarningMessage warningMessage = new DataTypeHasFieldsWarningMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeWithFieldsWarningMessage.StrongMessage", new Object[0])).thenReturn((Object)"*Expected strong message.*");
        String actualWarningMessage = warningMessage.getStrongMessage(dataType);
        Assert.assertEquals((Object)"*Expected strong message.*", (Object)actualWarningMessage);
    }

    @Test
    public void testGetRegularMessage() {
        String expectedWarningMessage = "Expected regular message.";
        DataTypeHasFieldsWarningMessage warningMessage = new DataTypeHasFieldsWarningMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeWithFieldsWarningMessage.RegularMessage", new Object[0])).thenReturn((Object)"Expected regular message.");
        String actualWarningMessage = warningMessage.getRegularMessage();
        Assert.assertEquals((Object)"Expected regular message.", (Object)actualWarningMessage);
    }
}

