/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Event;
import elemental2.dom.HTMLInputElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.MinMaxValueHelper;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class MinMaxValueHelperTest {
    @Mock
    private HTMLInputElement input;
    @Mock
    private Event event;

    @Test
    public void testSetupMinMaxHandlersOnKeyDownWhenValueIsValid() {
        this.input.value = "50";
        this.input.max = "100";
        this.input.min = "-100";
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.input);
        Object result = this.input.onkeydown.onInvoke(this.event);
        Assert.assertEquals((Object)result, (Object)true);
        ((HTMLInputElement)Mockito.verify((Object)this.input)).setAttribute("data-old", "50");
    }

    @Test
    public void testSetupMinMaxHandlersOnKeyDownWhenValueIsNotValid() {
        this.input.value = "200";
        this.input.max = "100";
        this.input.min = "-100";
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.input);
        Object result = this.input.onkeydown.onInvoke(this.event);
        Assert.assertEquals((Object)result, (Object)true);
        ((HTMLInputElement)Mockito.verify((Object)this.input, (VerificationMode)Mockito.never())).setAttribute((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testSetupMinMaxHandlersOnKeyUpWhenNewValueIsValid() {
        String newValue = "2";
        String oldValue = "42";
        this.input.value = "2";
        this.input.max = "100";
        this.input.min = "-100";
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.input);
        Mockito.when((Object)this.input.getAttribute("data-old")).thenReturn((Object)"42");
        Object result = this.input.onkeyup.onInvoke(this.event);
        String actualValue = this.input.value;
        Assert.assertEquals((Object)result, (Object)true);
        Assert.assertEquals((Object)actualValue, (Object)"2");
    }

    @Test
    public void testSetupMinMaxHandlersOnKeyUpWhenNewValueIsNotValid() {
        String newValue = "150";
        String oldValue = "42";
        this.input.value = "150";
        this.input.max = "100";
        this.input.min = "-100";
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.input);
        Mockito.when((Object)this.input.getAttribute("data-old")).thenReturn((Object)"42");
        Object result = this.input.onkeyup.onInvoke(this.event);
        String actualValue = this.input.value;
        Assert.assertEquals((Object)result, (Object)true);
        Assert.assertEquals((Object)actualValue, (Object)"42");
    }

    @Test
    public void testSetupMinMaxHandlersOnFocusOutWhenNewValueIsValid() {
        String newValue = "2";
        String oldValue = "42";
        this.input.value = "2";
        this.input.max = "100";
        this.input.min = "-100";
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.input);
        Mockito.when((Object)this.input.getAttribute("data-old")).thenReturn((Object)"42");
        Object result = this.input.onfocusout.onInvoke(this.event);
        String actualValue = this.input.value;
        Assert.assertEquals((Object)result, (Object)true);
        Assert.assertEquals((Object)actualValue, (Object)"2");
    }

    @Test
    public void testSetupMinMaxHandlersOnFocusOutWhenNewValueIsNotValid() {
        String newValue = "150";
        String oldValue = "42";
        this.input.value = "150";
        this.input.max = "100";
        this.input.min = "-100";
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.input);
        Mockito.when((Object)this.input.getAttribute("data-old")).thenReturn((Object)"42");
        Object result = this.input.onfocusout.onInvoke(this.event);
        String actualValue = this.input.value;
        Assert.assertEquals((Object)result, (Object)true);
        Assert.assertEquals((Object)actualValue, (Object)"42");
    }

    @Test
    public void testIsValidValueWhenWithoutMaxValue() {
        this.input.min = "0";
        Assert.assertTrue((boolean)MinMaxValueHelper.isValidValue((HTMLInputElement)this.input, (int)0));
    }

    @Test
    public void testIsValidValueWhenWithoutMinValue() {
        this.input.max = "0";
        Assert.assertTrue((boolean)MinMaxValueHelper.isValidValue((HTMLInputElement)this.input, (int)0));
    }
}

