/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.TimeSelectorView;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimePicker;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValueFormatter;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeZoneProvider;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class TimeSelectorViewTest {
    @Mock
    private HTMLButtonElement toggleTimeZoneButton;
    @Mock
    private HTMLElement toggleTimeZoneIcon;
    @Mock
    private HTMLInputElement timeInput;
    @Mock
    private HTMLSelectElement timeZoneSelector;
    @Mock
    private HTMLOptionElement typeSelectOption;
    @Mock
    private TimePicker picker;
    @Mock
    private TimeValueFormatter formatter;
    @Mock
    private Consumer<BlurEvent> onValueInputBlur;
    @Mock
    private TimeZoneProvider timeZoneProvider;
    @Mock
    private ClientTranslationService translationService;
    @Mock
    private DOMTokenList toggleTimeZoneIconClassList;
    @Mock
    private HTMLElement element;
    private TimeSelectorView view;

    @Before
    public void setup() {
        this.toggleTimeZoneIcon.classList = this.toggleTimeZoneIconClassList;
        this.view = (TimeSelectorView)Mockito.spy((Object)new TimeSelectorView(this.timeInput, this.picker, this.timeZoneProvider, this.formatter, this.toggleTimeZoneIcon, this.toggleTimeZoneButton, this.translationService, this.timeZoneSelector, this.typeSelectOption));
        ((TimeSelectorView)Mockito.doReturn((Object)this.element).when((Object)this.view)).getElement();
        ((TimeSelectorView)Mockito.doReturn(this.onValueInputBlur).when((Object)this.view)).getOnValueInputBlur();
        ((TimeSelectorView)Mockito.doReturn((Object)this.timeZoneSelector).when((Object)this.view)).getSelectPicker();
    }

    @Test
    public void testPopulateTimeZoneSelectorWithIds() {
        HTMLOptionElement noneOption = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        HTMLOptionElement tz1Option = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        HTMLOptionElement tz2Option = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        List timeZones = (List)Mockito.mock(List.class);
        DMNSimpleTimeZone tz1 = (DMNSimpleTimeZone)Mockito.mock(DMNSimpleTimeZone.class);
        DMNSimpleTimeZone tz2 = (DMNSimpleTimeZone)Mockito.mock(DMNSimpleTimeZone.class);
        Mockito.when((Object)tz1.getId()).thenReturn((Object)"time zone 1");
        Mockito.when((Object)tz2.getId()).thenReturn((Object)"other time zone");
        Mockito.when((Object)timeZones.size()).thenReturn((Object)2);
        Mockito.when((Object)((DMNSimpleTimeZone)timeZones.get(0))).thenReturn((Object)tz1);
        Mockito.when((Object)((DMNSimpleTimeZone)timeZones.get(1))).thenReturn((Object)tz2);
        ((TimeSelectorView)Mockito.doReturn((Object)tz1Option).when((Object)this.view)).createOptionWithId(tz1);
        ((TimeSelectorView)Mockito.doReturn((Object)tz2Option).when((Object)this.view)).createOptionWithId(tz2);
        ((TimeSelectorView)Mockito.doReturn((Object)timeZones).when((Object)this.view)).getTimeZones();
        ((TimeSelectorView)Mockito.doReturn((Object)noneOption).when((Object)this.view)).createNoneOption();
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).timeZoneSelectorRefresh();
        this.view.populateTimeZoneSelectorWithIds();
        ((HTMLSelectElement)Mockito.verify((Object)this.timeZoneSelector)).appendChild((Node)noneOption);
        ((HTMLSelectElement)Mockito.verify((Object)this.timeZoneSelector)).appendChild((Node)tz1Option);
        ((HTMLSelectElement)Mockito.verify((Object)this.timeZoneSelector)).appendChild((Node)tz2Option);
        ((TimeSelectorView)Mockito.verify((Object)this.view)).timeZoneSelectorRefresh();
    }

    @Test
    public void testCreateOptionWithId() {
        String optionId = "some id";
        HTMLOptionElement option = new HTMLOptionElement();
        DMNSimpleTimeZone tz = new DMNSimpleTimeZone();
        tz.setId("some id");
        ((TimeSelectorView)Mockito.doReturn((Object)option).when((Object)this.view)).getNewOption();
        this.view.createOptionWithId(tz);
        Assert.assertEquals((Object)"some id", (Object)option.value);
        Assert.assertEquals((Object)"some id", (Object)option.text);
    }

    @Test
    public void testCreateNoneOption() {
        HTMLOptionElement noneOption = new HTMLOptionElement();
        String text = "text";
        Mockito.when((Object)this.translationService.getValue("TimeSelectorView.None")).thenReturn((Object)"text");
        ((TimeSelectorView)Mockito.doReturn((Object)noneOption).when((Object)this.view)).getNewOption();
        this.view.createNoneOption();
        Assert.assertEquals((Object)"None", (Object)noneOption.value);
        Assert.assertEquals((Object)"text", (Object)noneOption.text);
    }

    @Test
    public void testPopulateTimeZoneSelectorWithOffSets() {
        HTMLOptionElement noneOption = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        HTMLOptionElement option0 = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        HTMLOptionElement option1 = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        String os0 = "+01:00";
        String os1 = "-03:00";
        List offsets = (List)Mockito.mock(List.class);
        Mockito.when((Object)offsets.size()).thenReturn((Object)2);
        Mockito.when((Object)((String)offsets.get(0))).thenReturn((Object)"+01:00");
        Mockito.when((Object)((String)offsets.get(1))).thenReturn((Object)"-03:00");
        ((TimeSelectorView)Mockito.doReturn((Object)noneOption).when((Object)this.view)).createNoneOption();
        ((TimeSelectorView)Mockito.doReturn((Object)option0).when((Object)this.view)).createOptionWithOffset("+01:00");
        ((TimeSelectorView)Mockito.doReturn((Object)option1).when((Object)this.view)).createOptionWithOffset("-03:00");
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).timeZoneSelectorRefresh();
        Mockito.when((Object)this.timeZoneProvider.getTimeZonesOffsets()).thenReturn((Object)offsets);
        this.view.populateTimeZoneSelectorWithOffSets();
        ((HTMLSelectElement)Mockito.verify((Object)this.timeZoneSelector)).appendChild((Node)noneOption);
        ((HTMLSelectElement)Mockito.verify((Object)this.timeZoneSelector)).appendChild((Node)option0);
        ((HTMLSelectElement)Mockito.verify((Object)this.timeZoneSelector)).appendChild((Node)option1);
    }

    @Test
    public void testCreateOptionWithOffset() {
        String offset = "offset";
        HTMLOptionElement option = new HTMLOptionElement();
        ((TimeSelectorView)Mockito.doReturn((Object)option).when((Object)this.view)).getNewOption();
        this.view.createOptionWithOffset("offset");
        Assert.assertEquals((Object)"offset", (Object)option.value);
        Assert.assertEquals((Object)"offset", (Object)option.text);
    }

    @Test
    public void testGetValue() {
        String time = "10:20:00";
        String selectedValue = "selected-value";
        Mockito.when((Object)this.picker.getValue()).thenReturn((Object)"10:20:00");
        Mockito.when((Object)this.view.getTimeZoneSelectedValue()).thenReturn((Object)"selected-value");
        Mockito.when((Object)this.formatter.buildRawValue("10:20:00", "selected-value")).thenReturn((Object)"");
        this.view.getValue();
        ((TimeValueFormatter)Mockito.verify((Object)this.formatter)).buildRawValue("10:20:00", "selected-value");
    }

    @Test
    public void testGetValueWithNoneTimeZone() {
        String time = "10:20:00";
        Mockito.when((Object)this.picker.getValue()).thenReturn((Object)"10:20:00");
        Mockito.when((Object)this.view.getTimeZoneSelectedValue()).thenReturn((Object)"None");
        Mockito.when((Object)this.formatter.buildRawValue("10:20:00", "")).thenReturn((Object)"");
        this.view.getValue();
        ((TimeValueFormatter)Mockito.verify((Object)this.formatter)).buildRawValue("10:20:00", "");
    }

    @Test
    public void testGetValueWithNullTimeZone() {
        String time = "10:20:00";
        Mockito.when((Object)this.picker.getValue()).thenReturn((Object)"10:20:00");
        Mockito.when((Object)this.view.getTimeZoneSelectedValue()).thenReturn(null);
        Mockito.when((Object)this.formatter.buildRawValue("10:20:00", "")).thenReturn((Object)"");
        this.view.getValue();
        ((TimeValueFormatter)Mockito.verify((Object)this.formatter)).buildRawValue("10:20:00", "");
    }

    @Test
    public void testSetValueOffset() {
        String value = "value";
        TimeValue timeValue = (TimeValue)Mockito.mock(TimeValue.class);
        Mockito.when((Object)this.formatter.getTimeValue("value")).thenReturn((Object)timeValue);
        Mockito.when((Object)timeValue.getTimeZoneMode()).thenReturn((Object)TimeValue.TimeZoneMode.OFFSET);
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).refreshTimeZoneOffsetMode((TimeValue)ArgumentMatchers.any());
        this.view.setValue("value");
        ((TimeSelectorView)Mockito.verify((Object)this.view)).setIsOffsetMode(true);
        ((TimeSelectorView)Mockito.verify((Object)this.view)).refreshTimeZoneOffsetMode(timeValue);
    }

    @Test
    public void testSetValueTimezone() {
        String value = "value";
        TimeValue timeValue = (TimeValue)Mockito.mock(TimeValue.class);
        Mockito.when((Object)this.formatter.getTimeValue("value")).thenReturn((Object)timeValue);
        Mockito.when((Object)timeValue.getTimeZoneMode()).thenReturn((Object)TimeValue.TimeZoneMode.TIMEZONE);
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).refreshTimeZoneOffsetMode((TimeValue)ArgumentMatchers.any());
        this.view.setValue("value");
        ((TimeSelectorView)Mockito.verify((Object)this.view)).setIsOffsetMode(false);
        ((TimeSelectorView)Mockito.verify((Object)this.view)).refreshTimeZoneOffsetMode(timeValue);
    }

    @Test
    public void testSetValueNoTimezoneOrOffset() {
        String value = "value";
        TimeValue timeValue = (TimeValue)Mockito.mock(TimeValue.class);
        Mockito.when((Object)this.formatter.getTimeValue("value")).thenReturn((Object)timeValue);
        Mockito.when((Object)timeValue.getTimeZoneMode()).thenReturn((Object)TimeValue.TimeZoneMode.NONE);
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).refreshTimeZoneOffsetMode((TimeValue)ArgumentMatchers.any());
        this.view.setValue("value");
        ((TimeSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setIsOffsetMode(ArgumentMatchers.anyBoolean());
        ((TimeSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).refreshTimeZoneOffsetMode(timeValue);
        ((TimeSelectorView)Mockito.verify((Object)this.view)).setPickerValue("");
    }

    @Test
    public void testRefreshTimeZoneOffsetMode() {
        String tzValue = "timezone-value";
        TimeValue timeValue = (TimeValue)Mockito.mock(TimeValue.class);
        Mockito.when((Object)timeValue.getTimeZoneValue()).thenReturn((Object)"timezone-value");
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).refreshToggleTimeZoneIcon();
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).reloadTimeZoneSelector();
        this.view.refreshTimeZoneOffsetMode(timeValue);
        ((TimeSelectorView)Mockito.verify((Object)this.view)).refreshToggleTimeZoneIcon();
        ((TimeSelectorView)Mockito.verify((Object)this.view)).reloadTimeZoneSelector();
        ((TimeSelectorView)Mockito.verify((Object)this.view)).setPickerValue("timezone-value");
    }

    @Test
    public void testOnTimeInputBlur() {
        BlurEvent event = (BlurEvent)Mockito.mock(BlurEvent.class);
        Element target = (Element)Mockito.mock(Element.class);
        ((TimeSelectorView)Mockito.doReturn((Object)target).when((Object)this.view)).getEventTarget(event);
        ((TimeSelectorView)Mockito.doReturn((Object)false).when((Object)this.view)).isChildOfView((Object)target);
        this.view.onTimeInputBlur(event);
        ((Consumer)Mockito.verify(this.onValueInputBlur)).accept(event);
    }

    @Test
    public void testOnTimeInputBlurToChildrenElement() {
        BlurEvent event = (BlurEvent)Mockito.mock(BlurEvent.class);
        Element target = (Element)Mockito.mock(Element.class);
        ((TimeSelectorView)Mockito.doReturn((Object)target).when((Object)this.view)).getEventTarget(event);
        ((TimeSelectorView)Mockito.doReturn((Object)true).when((Object)this.view)).isChildOfView((Object)target);
        this.view.onTimeInputBlur(event);
        ((Consumer)Mockito.verify(this.onValueInputBlur, (VerificationMode)Mockito.never())).accept(event);
    }

    @Test
    public void testOnToggleTimeZoneButtonClickIsOffsetMode() {
        this.testOnToggleTimeZoneButtonClick(true);
    }

    @Test
    public void testOnToggleTimeZoneButtonClickIsNotOffsetMode() {
        this.testOnToggleTimeZoneButtonClick(false);
    }

    private void testOnToggleTimeZoneButtonClick(boolean isOffsetMode) {
        ((TimeSelectorView)Mockito.doReturn((Object)isOffsetMode).when((Object)this.view)).getIsOffsetMode();
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).refreshToggleTimeZoneIcon();
        ((TimeSelectorView)Mockito.doNothing().when((Object)this.view)).reloadTimeZoneSelector();
        this.view.onToggleTimeZoneButtonClick(null);
        ((TimeSelectorView)Mockito.verify((Object)this.view)).setIsOffsetMode(!isOffsetMode);
        ((TimeSelectorView)Mockito.verify((Object)this.view)).refreshToggleTimeZoneIcon();
        ((TimeSelectorView)Mockito.verify((Object)this.view)).reloadTimeZoneSelector();
    }

    @Test
    public void testReloadTimeZoneSelectorIsOffsetMode() {
        HTMLOptionElement none = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        ((TimeSelectorView)Mockito.doReturn((Object)none).when((Object)this.view)).createNoneOption();
        ((TimeSelectorView)Mockito.doReturn((Object)true).when((Object)this.view)).getIsOffsetMode();
        this.view.reloadTimeZoneSelector();
        ((TimeSelectorView)Mockito.verify((Object)this.view)).populateTimeZoneSelectorWithOffSets();
        ((TimeSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).populateTimeZoneSelectorWithIds();
    }

    @Test
    public void testReloadTimeZoneSelectorIsNotOffsetMode() {
        HTMLOptionElement none = (HTMLOptionElement)Mockito.mock(HTMLOptionElement.class);
        ((TimeSelectorView)Mockito.doReturn((Object)none).when((Object)this.view)).createNoneOption();
        ((TimeSelectorView)Mockito.doReturn((Object)false).when((Object)this.view)).getIsOffsetMode();
        this.view.reloadTimeZoneSelector();
        ((TimeSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).populateTimeZoneSelectorWithOffSets();
        ((TimeSelectorView)Mockito.verify((Object)this.view)).populateTimeZoneSelectorWithIds();
    }

    @Test
    public void testRefreshToggleTimeZoneIconWhenIsOffsetMode() {
        ((TimeSelectorView)Mockito.doReturn((Object)true).when((Object)this.view)).getIsOffsetMode();
        this.view.refreshToggleTimeZoneIcon();
        ((DOMTokenList)Mockito.verify((Object)this.toggleTimeZoneIconClassList)).remove(new String[]{"fa-globe"});
        ((DOMTokenList)Mockito.verify((Object)this.toggleTimeZoneIconClassList)).add(new String[]{"fa-clock-o"});
    }

    @Test
    public void testRefreshToggleTimeZoneIconWhenIsNotOffsetMode() {
        ((TimeSelectorView)Mockito.doReturn((Object)false).when((Object)this.view)).getIsOffsetMode();
        this.view.refreshToggleTimeZoneIcon();
        ((DOMTokenList)Mockito.verify((Object)this.toggleTimeZoneIconClassList)).add(new String[]{"fa-globe"});
        ((DOMTokenList)Mockito.verify((Object)this.toggleTimeZoneIconClassList)).remove(new String[]{"fa-clock-o"});
    }
}

