/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months;

import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLInputElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsSelectorView;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsValue;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class YearsMonthsSelectorViewTest {
    @Mock
    private HTMLInputElement yearInput;
    @Mock
    private HTMLInputElement monthInput;
    private YearsMonthsSelectorView view;

    @Before
    public void testSetup() {
        this.view = (YearsMonthsSelectorView)Mockito.spy((Object)new YearsMonthsSelectorView(this.yearInput, this.monthInput));
    }

    @Test
    public void testGetValue() {
        String inputYear = "inputYear";
        String inputMonth = "inputMonth";
        this.yearInput.value = "inputYear";
        this.monthInput.value = "inputMonth";
        YearsMonthsValue value = this.view.getValue();
        Assert.assertEquals((Object)"inputYear", (Object)value.getYears());
        Assert.assertEquals((Object)"inputMonth", (Object)value.getMonths());
    }

    @Test
    public void testSetValue() {
        String months = "months";
        String years = "years";
        YearsMonthsValue yearsMonthsValue = (YearsMonthsValue)Mockito.mock(YearsMonthsValue.class);
        Mockito.when((Object)yearsMonthsValue.getMonths()).thenReturn((Object)"months");
        Mockito.when((Object)yearsMonthsValue.getYears()).thenReturn((Object)"years");
        this.view.setValue(yearsMonthsValue);
        Assert.assertEquals((Object)"years", (Object)this.yearInput.value);
        Assert.assertEquals((Object)"months", (Object)this.monthInput.value);
    }

    @Test
    public void testSetPlaceHolder() {
        String value = "placeholderValue";
        this.view.setPlaceHolder("placeholderValue");
        ((HTMLInputElement)Mockito.verify((Object)this.yearInput)).setAttribute("placeholder", "placeholderValue");
        ((HTMLInputElement)Mockito.verify((Object)this.monthInput)).setAttribute("placeholder", "placeholderValue");
    }

    @Test
    public void testOnYearsInputBlur() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        NativeEvent nativeEvent = (NativeEvent)Mockito.mock(NativeEvent.class);
        EventTarget eventTarget = (EventTarget)Mockito.mock(EventTarget.class);
        Mockito.when((Object)blurEvent.getNativeEvent()).thenReturn((Object)nativeEvent);
        Mockito.when((Object)nativeEvent.getRelatedEventTarget()).thenReturn((Object)eventTarget);
        this.view.onYearsInputBlur(blurEvent);
        ((YearsMonthsSelectorView)Mockito.verify((Object)this.view)).handle(blurEvent);
    }

    @Test
    public void testOnMonthsInputBlur() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        NativeEvent nativeEvent = (NativeEvent)Mockito.mock(NativeEvent.class);
        EventTarget eventTarget = (EventTarget)Mockito.mock(EventTarget.class);
        Mockito.when((Object)blurEvent.getNativeEvent()).thenReturn((Object)nativeEvent);
        Mockito.when((Object)nativeEvent.getRelatedEventTarget()).thenReturn((Object)eventTarget);
        this.view.onMonthsInputBlur(blurEvent);
        ((YearsMonthsSelectorView)Mockito.verify((Object)this.view)).handle(blurEvent);
    }

    @Test
    public void testIsNotYearsOrMonthsInput() {
        Object object = Mockito.mock(Object.class);
        boolean actual = this.view.isYearsOrMonthsInput(object);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsYearsOrMonthsInput() {
        boolean isMonthInput = this.view.isYearsOrMonthsInput((Object)this.monthInput);
        Assert.assertTrue((boolean)isMonthInput);
        boolean isYearInput = this.view.isYearsOrMonthsInput((Object)this.yearInput);
        Assert.assertTrue((boolean)isYearInput);
    }

    @Test
    public void select() {
        this.view.select();
        ((HTMLInputElement)Mockito.verify((Object)this.yearInput)).select();
    }
}

