/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.ConstraintPlaceholderHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintParserWarningEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range.DataTypeConstraintRange;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintRangeTest {
    @Mock
    private DataTypeConstraintRange.View view;
    @Mock
    private ConstraintPlaceholderHelper placeholderHelper;
    @Mock
    private DMNClientServicesProxy clientServicesProxy;
    @Mock
    private EventSourceMock<DataTypeConstraintParserWarningEvent> parserWarningEvent;
    @Mock
    private DataTypeConstraintModal modal;
    private DataTypeConstraintRange constraintRange;

    @Before
    public void setup() {
        this.constraintRange = (DataTypeConstraintRange)Mockito.spy((Object)new DataTypeConstraintRange(this.view, this.placeholderHelper, this.clientServicesProxy, this.parserWarningEvent));
    }

    @Test
    public void testSetup() {
        this.constraintRange.setup();
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).init((Object)this.constraintRange);
    }

    @Test
    public void testDisableOkButton() {
        this.constraintRange.setModal(this.modal);
        this.constraintRange.disableOkButton();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).disableOkButton();
    }

    @Test
    public void testEnableOkButton() {
        this.constraintRange.setModal(this.modal);
        this.constraintRange.enableOkButton();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).enableOkButton();
    }

    @Test
    public void testSetValue() {
        String value = "value";
        this.constraintRange.setValue("value");
        ((DMNClientServicesProxy)Mockito.verify((Object)this.clientServicesProxy)).parseRangeValue((String)ArgumentMatchers.eq((Object)"value"), (ServiceCallback)ArgumentMatchers.any(ServiceCallback.class));
    }

    @Test
    public void testLoadConstraintValue() {
        this.constraintRange.setModal(this.modal);
        RangeValue rangeValue = new RangeValue();
        rangeValue.setIncludeStartValue(true);
        rangeValue.setIncludeEndValue(true);
        rangeValue.setStartValue("0");
        rangeValue.setEndValue("1");
        this.constraintRange.loadConstraintValue(rangeValue);
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setIncludeStartValue(true);
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setIncludeEndValue(true);
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setStartValue("0");
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setEndValue("1");
        ((DataTypeConstraintRange)Mockito.verify((Object)this.constraintRange)).enableOkButton();
    }

    @Test
    public void testLoadEmptyConstraintValue() {
        this.constraintRange.setModal(this.modal);
        RangeValue rangeValue = new RangeValue();
        this.constraintRange.loadConstraintValue(rangeValue);
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setIncludeStartValue(true);
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setIncludeEndValue(true);
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setStartValue("");
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setEndValue("");
        ((DataTypeConstraintRange)Mockito.verify((Object)this.constraintRange)).disableOkButton();
        ((DataTypeConstraintRange)Mockito.verify((Object)this.constraintRange, (VerificationMode)Mockito.never())).enableOkButton();
    }

    @Test
    public void testGetValueExcludeBoth() {
        Mockito.when((Object)this.view.getIncludeStartValue()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getStartValue()).thenReturn((Object)"1");
        Mockito.when((Object)this.view.getEndValue()).thenReturn((Object)"6");
        Mockito.when((Object)this.view.getIncludeEndValue()).thenReturn((Object)false);
        String expected = "(1..6)";
        String actual = this.constraintRange.getValue();
        Assert.assertEquals((Object)"(1..6)", (Object)actual);
    }

    @Test
    public void testGetValueIncludeBoth() {
        Mockito.when((Object)this.view.getIncludeStartValue()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getStartValue()).thenReturn((Object)"1");
        Mockito.when((Object)this.view.getEndValue()).thenReturn((Object)"6");
        Mockito.when((Object)this.view.getIncludeEndValue()).thenReturn((Object)true);
        String expected = "[1..6]";
        String actual = this.constraintRange.getValue();
        Assert.assertEquals((Object)"[1..6]", (Object)actual);
    }

    @Test
    public void testGetValueIncludeStartExcludeEnd() {
        Mockito.when((Object)this.view.getIncludeStartValue()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getStartValue()).thenReturn((Object)"1");
        Mockito.when((Object)this.view.getEndValue()).thenReturn((Object)"6");
        Mockito.when((Object)this.view.getIncludeEndValue()).thenReturn((Object)false);
        String expected = "[1..6)";
        String actual = this.constraintRange.getValue();
        Assert.assertEquals((Object)"[1..6)", (Object)actual);
    }

    @Test
    public void testGetValueExcludeStartIncludeEnd() {
        Mockito.when((Object)this.view.getIncludeStartValue()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getStartValue()).thenReturn((Object)"1");
        Mockito.when((Object)this.view.getEndValue()).thenReturn((Object)"6");
        Mockito.when((Object)this.view.getIncludeEndValue()).thenReturn((Object)true);
        String expected = "(1..6]";
        String actual = this.constraintRange.getValue();
        Assert.assertEquals((Object)"(1..6]", (Object)actual);
    }

    @Test
    public void testGetValue() {
        Mockito.when((Object)this.view.getIncludeStartValue()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getStartValue()).thenReturn((Object)"some_value");
        Mockito.when((Object)this.view.getEndValue()).thenReturn((Object)"other_value");
        Mockito.when((Object)this.view.getIncludeEndValue()).thenReturn((Object)true);
        String expected = "[some_value..other_value]";
        String actual = this.constraintRange.getValue();
        Assert.assertEquals((Object)"[some_value..other_value]", (Object)actual);
    }

    @Test
    public void testSetConstraintValueType() {
        String type = "string";
        String placeholder = "placeholder";
        Mockito.when((Object)this.placeholderHelper.getPlaceholderSample("string")).thenReturn((Object)"placeholder");
        this.constraintRange.setConstraintValueType("string");
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setPlaceholders("placeholder");
        ((DataTypeConstraintRange.View)Mockito.verify((Object)this.view)).setComponentSelector("string");
    }
}

