/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.tooltip;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeKind;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.tooltip.StructureTypesTooltip;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class StructureTypesTooltipTest {
    @Mock
    private StructureTypesTooltip.View view;
    @Mock
    private DataTypeUtils dataTypeUtils;
    @Mock
    private DataTypeList dataTypeList;
    @Mock
    private DataTypeManager dataTypeManager;
    private StructureTypesTooltip presenter;

    @Before
    public void setup() {
        this.presenter = (StructureTypesTooltip)Mockito.spy((Object)new StructureTypesTooltip(this.view, this.dataTypeUtils, this.dataTypeList, this.dataTypeManager));
    }

    @Test
    public void testSetup() {
        this.presenter.setup();
        ((StructureTypesTooltip.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testShow() {
        HTMLElement refElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        String typeName = "string";
        this.presenter.show(refElement, "string");
        ((StructureTypesTooltip.View)Mockito.verify((Object)this.view)).show(refElement);
        Assert.assertEquals((Object)"string", (Object)this.presenter.getTypeName());
    }

    @Test
    public void testGetListItems() {
        HTMLElement expected = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dataTypeList.getListItems()).thenReturn((Object)expected);
        HTMLElement actual = this.presenter.getListItems();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetTypeFields() {
        String typeName = "tPerson";
        DataType tPerson = (DataType)Mockito.mock(DataType.class);
        DataType name = (DataType)Mockito.mock(DataType.class);
        DataType age = (DataType)Mockito.mock(DataType.class);
        ((StructureTypesTooltip)Mockito.doReturn((Object)"tPerson").when((Object)this.presenter)).getTypeName();
        Mockito.when((Object)tPerson.getSubDataTypes()).thenReturn(Arrays.asList(name, age));
        Mockito.when((Object)this.dataTypeManager.getTopLevelDataTypeWithName("tPerson")).thenReturn(Optional.of(tPerson));
        List typeFields = this.presenter.getTypeFields();
        Assert.assertEquals((long)2L, (long)typeFields.size());
        Assert.assertTrue((boolean)typeFields.contains(name));
        Assert.assertTrue((boolean)typeFields.contains(age));
    }

    @Test
    public void testGoToDataType() {
        String typeName = "tPerson";
        HTMLElement refElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Optional<DataType> optDataType = Optional.of(dataType);
        DataTypeListItem dataTypeListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Optional<DataTypeListItem> optDataTypeListItem = Optional.of(dataTypeListItem);
        Mockito.when((Object)this.dataTypeManager.getTopLevelDataTypeWithName("tPerson")).thenReturn(optDataType);
        Mockito.when((Object)this.dataTypeList.findItem(dataType)).thenReturn(optDataTypeListItem);
        this.presenter.show(refElement, "tPerson");
        this.presenter.goToDataType();
        ((DataTypeListItem)Mockito.verify((Object)dataTypeListItem)).enableShortcutsHighlight();
    }

    @Test
    public void testGetDataTypeKind() {
        DataTypeKind expectedKind = DataTypeKind.CUSTOM;
        Mockito.when((Object)this.dataTypeUtils.getDataTypeKind((String)ArgumentMatchers.any())).thenReturn((Object)expectedKind);
        DataTypeKind actualKind = this.presenter.getDataTypeKind();
        Assert.assertEquals((Object)expectedKind, (Object)actualKind);
    }
}

