/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeCreateHandler;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeCreateHandlerTest {
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private ItemDefinitionRecordEngine recordEngine;
    private DataTypeCreateHandler handler;

    @Before
    public void setup() {
        this.handler = (DataTypeCreateHandler)Mockito.spy((Object)new DataTypeCreateHandler(this.dataTypeStore, this.dataTypeManager));
        this.handler.init(this.recordEngine);
    }

    @Test
    public void testAppend() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataTypeWithoutName = (DataType)Mockito.mock(DataType.class);
        DataType updatedDataType = (DataType)Mockito.mock(DataType.class);
        DataTypeManager withDataType = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager withNoName = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.dataTypeManager.withDataType(dataType)).thenReturn((Object)withDataType);
        Mockito.when((Object)withDataType.withNoName()).thenReturn((Object)withNoName);
        Mockito.when((Object)withNoName.get()).thenReturn((Object)dataTypeWithoutName);
        Mockito.when((Object)this.recordEngine.update(updatedDataType)).thenReturn(expectedAffectedDataTypes);
        ((DataTypeCreateHandler)Mockito.doReturn((Object)updatedDataType).when((Object)this.handler)).updateDataTypeProperties(dataTypeWithoutName, "", itemDefinition);
        List actualAffectedDataTypes = this.handler.append(dataType, itemDefinition);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testAppendWhenNameIsSet() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType updatedDataType = (DataType)Mockito.mock(DataType.class);
        DataTypeManager withDataType = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        String existingName = "existing name";
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"existing name");
        Mockito.when((Object)this.dataTypeManager.withDataType(dataType)).thenReturn((Object)withDataType);
        Mockito.when((Object)this.recordEngine.update(updatedDataType)).thenReturn(expectedAffectedDataTypes);
        ((DataTypeCreateHandler)Mockito.doReturn((Object)updatedDataType).when((Object)this.handler)).updateDataTypeProperties(dataType, "", itemDefinition);
        List actualAffectedDataTypes = this.handler.append(dataType, itemDefinition);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testInsertNotNested() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        CreationType creationType = CreationType.ABOVE;
        ((DataTypeCreateHandler)Mockito.doReturn(expectedAffectedDataTypes).when((Object)this.handler)).insertSibling(dataType, reference, creationType, itemDefinition);
        List actualAffectedDataTypes = this.handler.insertSibling(dataType, reference, creationType, itemDefinition);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testInsertWhenAbsoluteParentExists() {
        String uuid = "uuid";
        String name = "name";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        final DataType reference = (DataType)Mockito.mock(DataType.class);
        final DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        final DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType absoluteParent = (DataType)Mockito.mock(DataType.class);
        DataType updatedDataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ArrayList<DataType> siblings = new ArrayList<DataType>(){
            {
                this.add(dataType0);
                this.add(reference);
                this.add(dataType2);
            }
        };
        Mockito.when((Object)absoluteParent.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)reference.getName()).thenReturn((Object)"name");
        Mockito.when((Object)updatedDataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)absoluteParent.getSubDataTypes()).thenReturn((Object)siblings);
        Mockito.when((Object)this.recordEngine.update(absoluteParent)).thenReturn(expectedAffectedDataTypes);
        ((DataTypeCreateHandler)Mockito.doReturn(Optional.of(absoluteParent)).when((Object)this.handler)).lookupAbsoluteParent(reference);
        ((DataTypeCreateHandler)Mockito.doReturn((Object)updatedDataType).when((Object)this.handler)).updateDataTypeProperties(dataType, "uuid", itemDefinition);
        List actualAffectedDataTypes = this.handler.insertSibling(dataType, reference, CreationType.BELOW, itemDefinition);
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine)).doUpdate(dataType, itemDefinition);
        Assert.assertEquals(Arrays.asList(dataType0, reference, updatedDataType, dataType2), (Object)siblings);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testInsertWhenAbsoluteParentDoesNotExist() {
        String parentUUID = "parentUUID";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataType updatedDataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)reference.getParentUUID()).thenReturn((Object)"parentUUID");
        ((DataTypeCreateHandler)Mockito.doReturn(Optional.empty()).when((Object)this.handler)).lookupAbsoluteParent(reference);
        ((DataTypeCreateHandler)Mockito.doReturn((Object)updatedDataType).when((Object)this.handler)).updateDataTypeProperties(dataType, "parentUUID", itemDefinition);
        List actualAffectedDataTypes = this.handler.insertSibling(dataType, reference, CreationType.BELOW, itemDefinition);
        List expectedAffectedDataTypes = Collections.emptyList();
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine)).doUpdate(updatedDataType, itemDefinition);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testInsertNestedWhenReferenceTypeIsNotDefault() {
        String parentUUID = "parentUUID";
        String type = "tCity";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataType updatedDataType = (DataType)Mockito.mock(DataType.class);
        DataTypeManager updatedDataTypeManager = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager referenceDataTypeManager = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ArrayList referenceSubDataTypes = new ArrayList();
        Mockito.when((Object)reference.getUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)reference.getType()).thenReturn((Object)"tCity");
        Mockito.when((Object)reference.getSubDataTypes()).thenReturn(referenceSubDataTypes);
        Mockito.when((Object)this.dataTypeManager.withDataType(updatedDataType)).thenReturn((Object)updatedDataTypeManager);
        Mockito.when((Object)this.dataTypeManager.withDataType(reference)).thenReturn((Object)referenceDataTypeManager);
        Mockito.when((Object)this.recordEngine.update(updatedDataType)).thenReturn(expectedAffectedDataTypes);
        ((DataTypeCreateHandler)Mockito.doReturn((Object)updatedDataType).when((Object)this.handler)).updateDataTypeProperties(dataType, "parentUUID", itemDefinition);
        List actualAffectedDataTypes = this.handler.insertNested(dataType, reference, itemDefinition);
        ((DataTypeManager)Mockito.verify((Object)this.dataTypeManager, (VerificationMode)Mockito.never())).asStructure();
        Assert.assertEquals(Collections.singletonList(updatedDataType), referenceSubDataTypes);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testInsertNestedWhenReferenceTypeIsATopLevelDataType() {
        String parentUUID = "parentUUID";
        String type = "tCity";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataType topLevelReference = (DataType)Mockito.mock(DataType.class);
        DataType updatedDataType = (DataType)Mockito.mock(DataType.class);
        DataTypeManager updatedDataTypeManager = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager topLevelReferenceDataTypeManager = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ArrayList referenceSubDataTypes = new ArrayList();
        Mockito.when((Object)reference.getUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)reference.getType()).thenReturn((Object)"tCity");
        Mockito.when((Object)topLevelReference.getSubDataTypes()).thenReturn(referenceSubDataTypes);
        Mockito.when((Object)topLevelReference.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)topLevelReference.getType()).thenReturn((Object)BuiltInType.STRING.getName());
        Mockito.when((Object)this.dataTypeManager.withDataType(topLevelReference)).thenReturn((Object)topLevelReferenceDataTypeManager);
        Mockito.when((Object)this.dataTypeManager.withDataType(updatedDataType)).thenReturn((Object)updatedDataTypeManager);
        Mockito.when((Object)this.recordEngine.update(updatedDataType)).thenReturn(expectedAffectedDataTypes);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Collections.singletonList(topLevelReference));
        ((DataTypeCreateHandler)Mockito.doReturn((Object)updatedDataType).when((Object)this.handler)).updateDataTypeProperties(dataType, "parentUUID", itemDefinition);
        List actualAffectedDataTypes = this.handler.insertNested(dataType, reference, itemDefinition);
        ((DataTypeManager)Mockito.verify((Object)topLevelReferenceDataTypeManager)).asStructure();
        Assert.assertEquals(Collections.singletonList(updatedDataType), referenceSubDataTypes);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testInsertNestedWhenReferenceTypeIsDefault() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeManager updatedDataTypeManager = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager referenceDataTypeManager = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String parentUUID = "parentUUID";
        String type = BuiltInType.STRING.getName();
        DataType updatedDataType = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ArrayList referenceSubDataTypes = new ArrayList();
        Mockito.when((Object)reference.getUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)reference.getType()).thenReturn((Object)type);
        Mockito.when((Object)reference.getSubDataTypes()).thenReturn(referenceSubDataTypes);
        Mockito.when((Object)this.dataTypeManager.withDataType(updatedDataType)).thenReturn((Object)updatedDataTypeManager);
        Mockito.when((Object)this.dataTypeManager.withDataType(reference)).thenReturn((Object)referenceDataTypeManager);
        Mockito.when((Object)this.recordEngine.update(updatedDataType)).thenReturn(expectedAffectedDataTypes);
        ((DataTypeCreateHandler)Mockito.doReturn((Object)updatedDataType).when((Object)this.handler)).updateDataTypeProperties(dataType, "parentUUID", itemDefinition);
        List actualAffectedDataTypes = this.handler.insertNested(dataType, reference, itemDefinition);
        ((DataTypeManager)Mockito.verify((Object)referenceDataTypeManager)).asStructure();
        Assert.assertEquals(Collections.singletonList(updatedDataType), referenceSubDataTypes);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testLookupAbsoluteParentWhenReferenceDoesNotHaveParent() {
        DataType reference = (DataType)Mockito.mock(DataType.class);
        String parentUUID = "parentUUID";
        Mockito.when((Object)reference.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.dataTypeStore.get("parentUUID")).thenReturn(null);
        Optional absoluteParent = this.handler.lookupAbsoluteParent(reference);
        Assert.assertFalse((boolean)absoluteParent.isPresent());
    }

    @Test
    public void testLookupAbsoluteParentWhenReferenceTypeIsStructure() {
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataType expectedParent = (DataType)Mockito.mock(DataType.class);
        String parentUUID = "parentUUID";
        String structure = "Structure";
        Mockito.when((Object)reference.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)expectedParent.getType()).thenReturn((Object)"Structure");
        Mockito.when((Object)this.dataTypeStore.get("parentUUID")).thenReturn((Object)expectedParent);
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"Structure");
        Optional actualParent = this.handler.lookupAbsoluteParent(reference);
        Assert.assertEquals(Optional.of(expectedParent), (Object)actualParent);
    }

    @Test
    public void testLookupAbsoluteParentWhenReferenceTypeIsNotStructure() {
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataType expectedParent = (DataType)Mockito.mock(DataType.class);
        DataType tCityTopLevel = (DataType)Mockito.mock(DataType.class);
        String parentUUID = "parentUUID";
        String structure = "Structure";
        String type = "tCity";
        Mockito.when((Object)reference.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)expectedParent.getType()).thenReturn((Object)"tCity");
        Mockito.when((Object)tCityTopLevel.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)this.dataTypeStore.get("parentUUID")).thenReturn((Object)expectedParent);
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"Structure");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Collections.singletonList(tCityTopLevel));
        Optional actualParent = this.handler.lookupAbsoluteParent(reference);
        Assert.assertEquals(Optional.of(tCityTopLevel), (Object)actualParent);
    }

    @Test
    public void testUpdateDataType() {
        String parentUUID = "parentUUID";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType expectedUpdateDataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        DataTypeManager dataTypeManagerWithDataType = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManagerWithParentUUID = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManagerWithItemDefinition = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManagerWithIndexedItemDefinition = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManagerWithItemDefinitionSubDataTypes = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManagerWithUniqueName = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        Mockito.when((Object)this.dataTypeManager.withDataType(dataType)).thenReturn((Object)dataTypeManagerWithDataType);
        Mockito.when((Object)dataTypeManagerWithDataType.withParentUUID("parentUUID")).thenReturn((Object)dataTypeManagerWithParentUUID);
        Mockito.when((Object)dataTypeManagerWithParentUUID.withItemDefinition(itemDefinition)).thenReturn((Object)dataTypeManagerWithItemDefinition);
        Mockito.when((Object)dataTypeManagerWithItemDefinition.withIndexedItemDefinition()).thenReturn((Object)dataTypeManagerWithIndexedItemDefinition);
        Mockito.when((Object)dataTypeManagerWithIndexedItemDefinition.withItemDefinitionSubDataTypes()).thenReturn((Object)dataTypeManagerWithItemDefinitionSubDataTypes);
        Mockito.when((Object)dataTypeManagerWithItemDefinitionSubDataTypes.withUniqueName()).thenReturn((Object)dataTypeManagerWithUniqueName);
        Mockito.when((Object)dataTypeManagerWithUniqueName.get()).thenReturn((Object)expectedUpdateDataType);
        DataType actualUpdatedDataType = this.handler.updateDataTypeProperties(dataType, "parentUUID", itemDefinition);
        Assert.assertEquals((Object)expectedUpdateDataType, (Object)actualUpdatedDataType);
    }
}

