/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeUpdateHandler;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeUpdateHandlerTest {
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private ItemDefinitionRecordEngine recordEngine;
    private DataTypeUpdateHandler handler;

    @Before
    public void setup() {
        this.handler = (DataTypeUpdateHandler)Mockito.spy((Object)new DataTypeUpdateHandler(this.itemDefinitionStore, this.dataTypeStore, this.dataTypeManager));
        this.handler.init(this.recordEngine);
        Mockito.when((Object)this.dataTypeManager.withDataType((DataType)ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)this.dataTypeManager.getTypeName()).thenCallRealMethod();
    }

    @Test
    public void testUpdateWhenDataTypeIsStructure() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeUpdateHandler)Mockito.doReturn((Object)true).when((Object)this.handler)).isStructure(dataType);
        Mockito.when((Object)this.dataTypeManager.from(dataType)).thenReturn((Object)this.dataTypeManager);
        this.handler.update(dataType);
        ((DataTypeManager)Mockito.verify((Object)this.dataTypeManager, (VerificationMode)Mockito.never())).withSubDataTypes(Collections.emptyList());
    }

    @Test
    public void testUpdateWhenDataTypeIsNotStructure() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeUpdateHandler)Mockito.doReturn((Object)false).when((Object)this.handler)).isStructure(dataType);
        Mockito.when((Object)this.dataTypeManager.from(dataType)).thenReturn((Object)this.dataTypeManager);
        this.handler.update(dataType);
        ((DataTypeManager)Mockito.verify((Object)this.dataTypeManager)).withSubDataTypes(Collections.emptyList());
    }

    @Test
    public void testRefreshDependentDataTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String oldItemDefinitionName = "oldItemDefinitionName";
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        ((DataTypeUpdateHandler)Mockito.doReturn(Arrays.asList(dataType0, dataType1)).when((Object)this.handler)).handleTopLevelDataTypeUpdate(dataType, "oldItemDefinitionName");
        ((DataTypeUpdateHandler)Mockito.doReturn(Arrays.asList(dataType2, dataType3)).when((Object)this.handler)).handleNestedDataTypeFieldUpdate(dataType);
        List<DataType> expectedDataTypes = Arrays.asList(dataType0, dataType1, dataType2, dataType3);
        List actualDataTypes = this.handler.refreshDependentDataTypes(dataType, "oldItemDefinitionName");
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testHandleTopLevelDataTypeUpdate() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedDataTypes = Arrays.asList(dataType0, dataType1);
        String oldItemDefinitionName = "oldItemDefinitionName";
        ((DataTypeUpdateHandler)Mockito.doReturn(expectedDataTypes).when((Object)this.handler)).updateAllChildrenWithTheNewTypeName(dataType, "oldItemDefinitionName");
        List actualDataTypes = this.handler.handleTopLevelDataTypeUpdate(dataType, "oldItemDefinitionName");
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testHandleNestedDataTypeFieldUpdateWhenDataTypeIsStructure() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> dependentDataTypes = Arrays.asList(dataType0, dataType1, dataType2);
        String name = "name";
        Mockito.when((Object)topLevelDataType.getName()).thenReturn((Object)"name");
        ((DataTypeUpdateHandler)Mockito.doReturn(Optional.of(topLevelDataType)).when((Object)this.handler)).getClosestTopLevelDataType(dataType);
        ((DataTypeUpdateHandler)Mockito.doReturn(dependentDataTypes).when((Object)this.handler)).handleTopLevelDataTypeUpdate(topLevelDataType, "name");
        ((DataTypeUpdateHandler)Mockito.doReturn((Object)true).when((Object)this.handler)).isStructure(dataType);
        List<DataType> expectedDataTypes = Arrays.asList(dataType0, dataType1, dataType2, topLevelDataType);
        List actualDataTypes = this.handler.handleNestedDataTypeFieldUpdate(dataType);
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testHandleNestedDataTypeFieldUpdateWhenDataTypeIsNotStructure() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        String name = "name";
        String type = "type";
        Mockito.when((Object)dataType0.getType()).thenReturn((Object)"name");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"type");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"type");
        Mockito.when((Object)topLevelDataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)topLevelDataType.getType()).thenReturn((Object)"type");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType0, dataType1, dataType2));
        ((DataTypeUpdateHandler)Mockito.doReturn(Optional.of(topLevelDataType)).when((Object)this.handler)).getClosestTopLevelDataType(dataType);
        ((DataTypeUpdateHandler)Mockito.doReturn((Object)false).when((Object)this.handler)).isStructure(dataType);
        List<DataType> expectedDataTypes = Arrays.asList(dataType1, dataType2, topLevelDataType);
        List actualDataTypes = this.handler.handleNestedDataTypeFieldUpdate(dataType);
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testUpdateAllChildrenWithTheNewTypeNameWhenDataTypeIsNotTopLevel() {
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        String oldItemDefinitionName = "oldItemDefinitionName";
        Mockito.when((Object)topLevelDataType.isTopLevel()).thenReturn((Object)false);
        List expectedDependentDataTypes = Collections.emptyList();
        List actualDependentDataTypes = this.handler.updateAllChildrenWithTheNewTypeName(topLevelDataType, "oldItemDefinitionName");
        ((DataTypeUpdateHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).refreshSubDataType((DataType)ArgumentMatchers.any(), (String)Mockito.any());
        Assert.assertEquals(expectedDependentDataTypes, (Object)actualDependentDataTypes);
    }

    @Test
    public void testUpdateAllChildrenWithTheNewTypeNameWhenDataTypeIsTopLevel() {
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        String oldItemDefinitionName = "oldItemDefinitionName";
        String topLevelName = "topLevelName";
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType0, dataType1, dataType2, dataType3));
        Mockito.when((Object)topLevelDataType.getName()).thenReturn((Object)"topLevelName");
        Mockito.when((Object)dataType0.getType()).thenReturn((Object)"oldItemDefinitionName");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"oldItemDefinitionName");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)"oldItemDefinitionName");
        Mockito.when((Object)dataType3.getType()).thenReturn((Object)"oldItemDefinitionName");
        Mockito.when((Object)topLevelDataType.isTopLevel()).thenReturn((Object)true);
        ((DataTypeUpdateHandler)Mockito.doNothing().when((Object)this.handler)).refreshSubDataType((DataType)ArgumentMatchers.any(), (String)Mockito.any());
        List<DataType> expectedDependentDataTypes = Arrays.asList(dataType0, dataType1, dataType2, dataType3, topLevelDataType);
        List actualDependentDataTypes = this.handler.updateAllChildrenWithTheNewTypeName(topLevelDataType, "oldItemDefinitionName");
        ((DataTypeUpdateHandler)Mockito.verify((Object)this.handler)).refreshSubDataType(dataType0, "topLevelName");
        ((DataTypeUpdateHandler)Mockito.verify((Object)this.handler)).refreshSubDataType(dataType1, "topLevelName");
        ((DataTypeUpdateHandler)Mockito.verify((Object)this.handler)).refreshSubDataType(dataType2, "topLevelName");
        ((DataTypeUpdateHandler)Mockito.verify((Object)this.handler)).refreshSubDataType(dataType3, "topLevelName");
        Assert.assertEquals(expectedDependentDataTypes, (Object)actualDependentDataTypes);
    }

    @Test
    public void testRefreshSubDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String newType = "newType";
        String type = "type";
        String uuid = "uuid";
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"type");
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.dataTypeManager.from(dataType)).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.withType("newType")).thenReturn((Object)this.dataTypeManager);
        this.handler.refreshSubDataType(dataType, "newType");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.dataTypeManager, this.dataTypeManager, this.recordEngine, this.handler});
        ((DataTypeManager)inOrder.verify((Object)this.dataTypeManager)).from(dataType);
        ((DataTypeManager)inOrder.verify((Object)this.dataTypeManager)).withType("newType");
        ((ItemDefinitionRecordEngine)inOrder.verify((Object)this.recordEngine)).doUpdate(dataType, itemDefinition);
    }
}

