/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBarView;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSearchBarViewTest {
    @Mock
    private HTMLInputElement searchBar;
    @Mock
    private HTMLElement searchIcon;
    @Mock
    private HTMLButtonElement closeSearch;
    @Mock
    private DataTypeSearchBar presenter;
    @Mock
    private TranslationService translationService;
    @Captor
    private ArgumentCaptor<DomGlobal.SetTimeoutCallbackFn> callback;
    private DataTypeSearchBarView view;

    @Before
    public void setup() {
        this.view = (DataTypeSearchBarView)Mockito.spy((Object)new DataTypeSearchBarView(this.searchBar, this.searchIcon, this.closeSearch, this.translationService));
        this.view.init(this.presenter);
        this.searchIcon.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.closeSearch.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
    }

    @Test
    public void testSetupSearchBar() {
        String search = "Search...";
        Mockito.when((Object)this.translationService.format("DataTypeSearchBarView.Search", new Object[0])).thenReturn((Object)"Search...");
        this.view.setupSearchBar();
        Assert.assertEquals((Object)this.searchBar.placeholder, (Object)"Search...");
    }

    @Test
    public void testOnSearchBarCloseButton() {
        this.view.onSearchBarCloseButton((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).reset();
    }

    @Test
    public void testOnSearchBarKeyUpEventWhenKeyPressedIsEscape() {
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        Mockito.when((Object)event.getNativeKeyCode()).thenReturn((Object)27);
        this.view.onSearchBarKeyUpEvent(event);
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).reset();
    }

    @Test
    public void testOnSearchBarKeyUpEventWhenKeyPressedIsNotEscape() {
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        Mockito.when((Object)event.getNativeKeyCode()).thenReturn((Object)17);
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).search();
        this.view.onSearchBarKeyUpEvent(event);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).search();
    }

    @Test
    public void testOnSearchBarKeyDownEvent() {
        this.view.onSearchBarKeyDownEvent((KeyDownEvent)Mockito.mock(KeyDownEvent.class));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
    }

    @Test
    public void testOnSearchBarChangeEvent() {
        this.view.onSearchBarChangeEvent((ChangeEvent)Mockito.mock(ChangeEvent.class));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
    }

    @Test
    public void testShowSearchResults() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element3 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<DataType> results = Arrays.asList(dataType0, dataType1, dataType2);
        List<DataTypeListItem> listItems = Arrays.asList(listItem0, listItem1, listItem2, listItem3);
        element0.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element3.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)listItem0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem0.getDragAndDropElement()).thenReturn((Object)element0);
        Mockito.when((Object)listItem1.getDragAndDropElement()).thenReturn((Object)element1);
        Mockito.when((Object)listItem2.getDragAndDropElement()).thenReturn((Object)element2);
        Mockito.when((Object)listItem3.getDragAndDropElement()).thenReturn((Object)element3);
        Mockito.when((Object)this.presenter.getDataTypeListItemsSortedByPositionY()).thenReturn(listItems);
        Mockito.when((Object)this.presenter.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).enableSearch();
        this.view.showSearchResults(results);
        ((DOMTokenList)Mockito.verify((Object)element0.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element3.classList)).add(new String[]{"hidden"});
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element0, 0.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element1, 1.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element2, 2.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element3, -1.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).refreshItemsPosition();
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).refreshDragAreaSize();
        ((DataTypeListItem)Mockito.verify((Object)listItem0)).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem2)).expand();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).enableSearch();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).groupElementsWithItsParents(listItems);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).expandListItems(listItems);
    }

    @Test
    public void testExpandListItems() {
        DataTypeListItem item1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem item2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> list = Arrays.asList(item1, item2);
        this.view.expandListItems(list);
        ((DataTypeListItem)Mockito.verify((Object)item1)).expand();
        ((DataTypeListItem)Mockito.verify((Object)item2)).expand();
    }

    @Test
    public void testGroupElementsWithItsParents() {
        List groupedElementsList = (List)Mockito.mock(List.class);
        DataTypeListItem element1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem element2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> allElements = Arrays.asList(element1, element2);
        ((DataTypeSearchBarView)Mockito.doReturn((Object)groupedElementsList).when((Object)this.view)).getGroupedElementsList();
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).groupElementWithItsParent(groupedElementsList, allElements, element1);
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).groupElementWithItsParent(groupedElementsList, allElements, element2);
        List actual = this.view.groupElementsWithItsParents(allElements);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).groupElementWithItsParent(groupedElementsList, allElements, element1);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).groupElementWithItsParent(groupedElementsList, allElements, element2);
        Assert.assertEquals((Object)actual, (Object)groupedElementsList);
    }

    @Test
    public void testGroupElementWithItsParentWhenParentIsNotOnList() {
        DataTypeListItem item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem parent = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList groupedElements = new ArrayList();
        List<DataTypeListItem> allElements = Arrays.asList(parent);
        String parentUuid = "parent_uuid";
        HTMLElement itemDragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentDragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)parent.getDragAndDropElement()).thenReturn((Object)parentDragAndDropElement);
        Mockito.when((Object)item.getDragAndDropElement()).thenReturn((Object)itemDragAndDropElement);
        Mockito.when((Object)itemDragAndDropElement.getAttribute("data-parent-row-uuid")).thenReturn((Object)"parent_uuid");
        Mockito.when((Object)parentDragAndDropElement.getAttribute("data-row-uuid")).thenReturn((Object)"parent_uuid");
        ((DataTypeSearchBarView)Mockito.doReturn((Object)false).when((Object)this.view)).isParentElementOnList(groupedElements, "parent_uuid");
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).groupElementWithItsParent(groupedElements, allElements, parent);
        this.view.groupElementWithItsParent(groupedElements, allElements, item);
        Assert.assertEquals((long)1L, (long)groupedElements.size());
        Assert.assertEquals((Object)item, groupedElements.get(0));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).groupElementWithItsParent(groupedElements, allElements, parent);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getIndexOfParentOrLastElementInGroup(groupedElements, parent);
    }

    @Test
    public void testGroupElementWithItsParentWhenParentIsOnList() {
        DataTypeListItem item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem parent = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem dummy = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> groupedElements = new ArrayList<DataTypeListItem>();
        groupedElements.add(parent);
        groupedElements.add(dummy);
        List<DataTypeListItem> allElements = Arrays.asList(parent);
        String parentUuid = "parent_uuid";
        HTMLElement itemDragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentDragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)parent.getDragAndDropElement()).thenReturn((Object)parentDragAndDropElement);
        Mockito.when((Object)item.getDragAndDropElement()).thenReturn((Object)itemDragAndDropElement);
        Mockito.when((Object)itemDragAndDropElement.getAttribute("data-parent-row-uuid")).thenReturn((Object)"parent_uuid");
        Mockito.when((Object)parentDragAndDropElement.getAttribute("data-row-uuid")).thenReturn((Object)"parent_uuid");
        ((DataTypeSearchBarView)Mockito.doReturn((Object)true).when((Object)this.view)).isParentElementOnList(groupedElements, "parent_uuid");
        ((DataTypeSearchBarView)Mockito.doReturn((Object)0).when((Object)this.view)).getIndexOfParentOrLastElementInGroup(groupedElements, parent);
        this.view.groupElementWithItsParent(groupedElements, allElements, item);
        Assert.assertEquals((long)3L, (long)groupedElements.size());
        Assert.assertEquals((Object)parent, groupedElements.get(0));
        Assert.assertEquals((Object)item, groupedElements.get(1));
        Assert.assertEquals((Object)dummy, groupedElements.get(2));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).groupElementWithItsParent(groupedElements, allElements, parent);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).getIndexOfParentOrLastElementInGroup(groupedElements, parent);
    }

    @Test
    public void testGroupElementWithItsParentWhenParentIsAtTheEndOfList() {
        DataTypeListItem item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem parent = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> groupedElements = new ArrayList<DataTypeListItem>();
        groupedElements.add(parent);
        List<DataTypeListItem> allElements = Arrays.asList(parent);
        String parentUuid = "parent_uuid";
        HTMLElement itemDragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentDragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)parent.getDragAndDropElement()).thenReturn((Object)parentDragAndDropElement);
        Mockito.when((Object)item.getDragAndDropElement()).thenReturn((Object)itemDragAndDropElement);
        Mockito.when((Object)itemDragAndDropElement.getAttribute("data-parent-row-uuid")).thenReturn((Object)"parent_uuid");
        Mockito.when((Object)parentDragAndDropElement.getAttribute("data-row-uuid")).thenReturn((Object)"parent_uuid");
        ((DataTypeSearchBarView)Mockito.doReturn((Object)true).when((Object)this.view)).isParentElementOnList(groupedElements, "parent_uuid");
        ((DataTypeSearchBarView)Mockito.doReturn((Object)0).when((Object)this.view)).getIndexOfParentOrLastElementInGroup(groupedElements, parent);
        this.view.groupElementWithItsParent(groupedElements, allElements, item);
        Assert.assertEquals((long)2L, (long)groupedElements.size());
        Assert.assertEquals((Object)parent, groupedElements.get(0));
        Assert.assertEquals((Object)item, groupedElements.get(1));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).groupElementWithItsParent(groupedElements, allElements, parent);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).getIndexOfParentOrLastElementInGroup(groupedElements, parent);
    }

    @Test
    public void testGetIndexOfParentOrLastElementInGroup() {
        DataTypeListItem parent = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement parentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        String parentId = "parentId";
        ArrayList<DataTypeListItem> groupedElements = new ArrayList<DataTypeListItem>();
        groupedElements.add(parent);
        boolean expectedIndex = false;
        Mockito.when((Object)parentElement.getAttribute("data-row-uuid")).thenReturn((Object)"parentId");
        Mockito.when((Object)parent.getDragAndDropElement()).thenReturn((Object)parentElement);
        int index = this.view.getIndexOfParentOrLastElementInGroup(groupedElements, parent);
        Assert.assertEquals((long)0L, (long)index);
    }

    @Test
    public void testGetIndexOfParentOrLastElementInGroupWhenHaveMoreElements() {
        DataTypeListItem parent = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement parentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement listItemElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement listItemElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        String parentId = "parentId";
        ArrayList<DataTypeListItem> groupedElements = new ArrayList<DataTypeListItem>();
        groupedElements.add(parent);
        groupedElements.add(listItem1);
        groupedElements.add(listItem2);
        int expectedIndex = 2;
        Mockito.when((Object)parentElement.getAttribute("data-row-uuid")).thenReturn((Object)"parentId");
        Mockito.when((Object)parent.getDragAndDropElement()).thenReturn((Object)parentElement);
        Mockito.when((Object)listItem1.getDragAndDropElement()).thenReturn((Object)listItemElement1);
        Mockito.when((Object)listItem2.getDragAndDropElement()).thenReturn((Object)listItemElement2);
        Mockito.when((Object)listItemElement1.getAttribute("data-parent-row-uuid")).thenReturn((Object)"parentId");
        Mockito.when((Object)listItemElement2.getAttribute("data-parent-row-uuid")).thenReturn((Object)"parentId");
        int index = this.view.getIndexOfParentOrLastElementInGroup(groupedElements, parent);
        Assert.assertEquals((long)2L, (long)index);
    }

    @Test
    public void testIsParentElementOnListWhenIsPresent() {
        DataTypeListItem item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String id = "id";
        Mockito.when((Object)element.getAttribute("data-row-uuid")).thenReturn((Object)"id");
        Mockito.when((Object)item.getDragAndDropElement()).thenReturn((Object)element);
        List<DataTypeListItem> groupedElements = Arrays.asList(item);
        boolean isPresent = this.view.isParentElementOnList(groupedElements, "id");
        Assert.assertTrue((boolean)isPresent);
    }

    @Test
    public void testIsParentElementOnListWhenIsNotPresent() {
        DataTypeListItem item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String id = "id";
        Mockito.when((Object)element.getAttribute("data-row-uuid")).thenReturn((Object)"otherId");
        Mockito.when((Object)item.getDragAndDropElement()).thenReturn((Object)element);
        List<DataTypeListItem> groupedElements = Arrays.asList(item);
        boolean isPresent = this.view.isParentElementOnList(groupedElements, "id");
        Assert.assertFalse((boolean)isPresent);
    }

    @Test
    public void testResetSearchBar() {
        this.searchBar.value = "something";
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).disableSearch();
        this.view.resetSearchBar();
        Assert.assertEquals((Object)this.searchBar.value, (Object)"");
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).disableSearch();
    }

    @Test
    public void testEnableSearch() {
        HTMLElement resultsContainer = (HTMLElement)Mockito.mock(HTMLElement.class);
        resultsContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.presenter.getResultsContainer()).thenReturn((Object)resultsContainer);
        this.view.enableSearch();
        ((DOMTokenList)Mockito.verify((Object)resultsContainer.classList)).add(new String[]{"kie-search-engine-enabled"});
    }

    @Test
    public void testDisableSearch() {
        HTMLElement resultsContainer = (HTMLElement)Mockito.mock(HTMLElement.class);
        resultsContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.presenter.getResultsContainer()).thenReturn((Object)resultsContainer);
        this.view.disableSearch();
        ((DOMTokenList)Mockito.verify((Object)resultsContainer.classList)).remove(new String[]{"kie-search-engine-enabled"});
    }

    @Test
    public void testSearch() {
        String keyword = "keyword";
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)ArgumentMatchers.any(), Mockito.anyDouble());
        this.searchBar.value = "keyword";
        this.view.search();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)this.callback.capture(), ArgumentMatchers.eq((double)500.0));
        ((DomGlobal.SetTimeoutCallbackFn)this.callback.getValue()).onInvoke(new Object[0]);
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).search("keyword");
    }

    @Test
    public void testRefreshSearchBarStateWhenItsActive() {
        this.searchBar.value = "keyword";
        this.view.refreshSearchBarState();
        ((DOMTokenList)Mockito.verify((Object)this.searchIcon.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeSearch.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testRefreshSearchBarStateWhenItsNotActive() {
        this.searchBar.value = "";
        this.view.refreshSearchBarState();
        ((DOMTokenList)Mockito.verify((Object)this.searchIcon.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeSearch.classList)).add(new String[]{"hidden"});
    }
}

