/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.graph;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder;
import org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Question;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.graph.DMNElementsSynchronizer;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.NodeTextSetter;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.forms.client.event.FormFieldChanged;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNElementsSynchronizerTest {
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private EventSourceMock<RefreshDecisionComponents> refreshDecisionComponentsEvent;
    @Mock
    private DMNGraphUtils graphUtils;
    @Mock
    private NodeTextSetter nodeTextSetter;
    private DMNElementsSynchronizer synchronizer;

    @Before
    public void setup() {
        this.synchronizer = (DMNElementsSynchronizer)Mockito.spy((Object)new DMNElementsSynchronizer(this.dmnDiagramsSession, this.refreshDecisionComponentsEvent, this.graphUtils, this.nodeTextSetter));
    }

    @Test
    public void testOnExpressionEditorChanged() {
        ExpressionEditorChanged event = (ExpressionEditorChanged)Mockito.mock(ExpressionEditorChanged.class);
        String id = "id";
        Node node = (Node)Mockito.mock(Node.class);
        Optional<Node> nodeOptional = Optional.of(node);
        Mockito.when((Object)event.getNodeUUID()).thenReturn((Object)"id");
        ((DMNElementsSynchronizer)Mockito.doReturn(nodeOptional).when((Object)this.synchronizer)).getNode("id");
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeFromNode(nodeOptional);
        this.synchronizer.onExpressionEditorChanged(event);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).getNode("id");
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeFromNode(nodeOptional);
    }

    @Test
    public void testOnPropertyChanged() {
        FormFieldChanged event = (FormFieldChanged)Mockito.mock(FormFieldChanged.class);
        String id = "id";
        Node node = (Node)Mockito.mock(Node.class);
        Optional<Node> nodeOptional = Optional.of(node);
        Mockito.when((Object)event.getUuid()).thenReturn((Object)"id");
        ((DMNElementsSynchronizer)Mockito.doReturn(nodeOptional).when((Object)this.synchronizer)).getNode("id");
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeFromNode(nodeOptional);
        this.synchronizer.onPropertyChanged(event);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).getNode("id");
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeFromNode(nodeOptional);
    }

    @Test
    public void testSynchronizeElementsFrom() {
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Node node3 = (Node)Mockito.mock(Node.class);
        List<Node> nodes = Arrays.asList(node1, node2, node3);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        String contentDefinitionId = "id";
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement3 = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)drgElement.getContentDefinitionId()).thenReturn((Object)"id");
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).updateText((DRGElement)ArgumentMatchers.any(DRGElement.class), (Node)ArgumentMatchers.any(Node.class));
        ((DMNElementsSynchronizer)Mockito.doReturn(nodes).when((Object)this.synchronizer)).getElementsWithContentId("id");
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)drgElement1).when((Object)this.synchronizer)).getDRGElementFromContentDefinition(node1);
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)drgElement2).when((Object)this.synchronizer)).getDRGElementFromContentDefinition(node2);
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)drgElement3).when((Object)this.synchronizer)).getDRGElementFromContentDefinition(node3);
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeBaseDRGProperties((DRGElement)ArgumentMatchers.any(DRGElement.class), (DRGElement)ArgumentMatchers.any(DRGElement.class));
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeSpecializedProperties((DRGElement)ArgumentMatchers.any(DRGElement.class), (DRGElement)ArgumentMatchers.any(DRGElement.class));
        this.synchronizer.synchronizeElementsFrom(drgElement);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).getElementsWithContentId("id");
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).updateText(drgElement, node1);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).updateText(drgElement, node2);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).updateText(drgElement, node3);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeBaseDRGProperties(drgElement, drgElement1);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeBaseDRGProperties(drgElement, drgElement2);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeBaseDRGProperties(drgElement, drgElement3);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeSpecializedProperties(drgElement, drgElement1);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeSpecializedProperties(drgElement, drgElement2);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeSpecializedProperties(drgElement, drgElement3);
        ((EventSourceMock)Mockito.verify(this.refreshDecisionComponentsEvent)).fire((Object)((RefreshDecisionComponents)ArgumentMatchers.any(RefreshDecisionComponents.class)));
    }

    @Test
    public void testSynchronizeSpecializedProperties_DecisionNode() {
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeDecisionNode((Decision)ArgumentMatchers.any(Decision.class), (Decision)ArgumentMatchers.any(Decision.class));
        Decision from = (Decision)Mockito.mock(Decision.class);
        Decision to = (Decision)Mockito.mock(Decision.class);
        this.synchronizer.synchronizeSpecializedProperties((DRGElement)from, (DRGElement)to);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeDecisionNode(from, to);
    }

    @Test
    public void testSynchronizeSpecializedProperties_BusinessKnowledgeModelNode() {
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeBusinessKnowledgeModelNode((BusinessKnowledgeModel)ArgumentMatchers.any(BusinessKnowledgeModel.class), (BusinessKnowledgeModel)ArgumentMatchers.any(BusinessKnowledgeModel.class));
        BusinessKnowledgeModel from = (BusinessKnowledgeModel)Mockito.mock(BusinessKnowledgeModel.class);
        BusinessKnowledgeModel to = (BusinessKnowledgeModel)Mockito.mock(BusinessKnowledgeModel.class);
        this.synchronizer.synchronizeSpecializedProperties((DRGElement)from, (DRGElement)to);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeBusinessKnowledgeModelNode(from, to);
    }

    @Test
    public void testSynchronizeSpecializedProperties_DecisionServiceNode() {
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeDecisionServiceNode((DecisionService)ArgumentMatchers.any(DecisionService.class), (DecisionService)ArgumentMatchers.any(DecisionService.class));
        DecisionService from = (DecisionService)Mockito.mock(DecisionService.class);
        DecisionService to = (DecisionService)Mockito.mock(DecisionService.class);
        this.synchronizer.synchronizeSpecializedProperties((DRGElement)from, (DRGElement)to);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeDecisionServiceNode(from, to);
    }

    @Test
    public void testSynchronizeSpecializedProperties_InputDataNode() {
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeInputDataNode((InputData)ArgumentMatchers.any(InputData.class), (InputData)ArgumentMatchers.any(InputData.class));
        InputData from = (InputData)Mockito.mock(InputData.class);
        InputData to = (InputData)Mockito.mock(InputData.class);
        this.synchronizer.synchronizeSpecializedProperties((DRGElement)from, (DRGElement)to);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeInputDataNode(from, to);
    }

    @Test
    public void testSynchronizeSpecializedProperties_KnowledgeSourceNode() {
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeKnowledgeSourceNode((KnowledgeSource)ArgumentMatchers.any(KnowledgeSource.class), (KnowledgeSource)ArgumentMatchers.any(KnowledgeSource.class));
        KnowledgeSource from = (KnowledgeSource)Mockito.mock(KnowledgeSource.class);
        KnowledgeSource to = (KnowledgeSource)Mockito.mock(KnowledgeSource.class);
        this.synchronizer.synchronizeSpecializedProperties((DRGElement)from, (DRGElement)to);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeKnowledgeSourceNode(from, to);
    }

    @Test
    public void testSynchronizeBaseDRGProperties() {
        DRGElement from = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement to = (DRGElement)Mockito.mock(DRGElement.class);
        Description description = (Description)Mockito.mock(Description.class);
        DocumentationLinksHolder linksHolder = (DocumentationLinksHolder)Mockito.mock(DocumentationLinksHolder.class);
        Name name = (Name)Mockito.mock(Name.class);
        Mockito.when((Object)from.getDescription()).thenReturn((Object)description);
        Mockito.when((Object)from.getLinksHolder()).thenReturn((Object)linksHolder);
        Mockito.when((Object)from.getName()).thenReturn((Object)name);
        this.synchronizer.synchronizeBaseDRGProperties(from, to);
        ((DRGElement)Mockito.verify((Object)to)).setDescription(description);
        ((DRGElement)Mockito.verify((Object)to)).setName(name);
        ((DRGElement)Mockito.verify((Object)to)).setLinksHolder(linksHolder);
    }

    @Test
    public void testSynchronizeKnowledgeSourceNode() {
        KnowledgeSource from = (KnowledgeSource)Mockito.mock(KnowledgeSource.class);
        KnowledgeSource to = (KnowledgeSource)Mockito.mock(KnowledgeSource.class);
        KnowledgeSourceType type = (KnowledgeSourceType)Mockito.mock(KnowledgeSourceType.class);
        LocationURI locationURI = (LocationURI)Mockito.mock(LocationURI.class);
        Mockito.when((Object)from.getType()).thenReturn((Object)type);
        Mockito.when((Object)from.getLocationURI()).thenReturn((Object)locationURI);
        this.synchronizer.synchronizeKnowledgeSourceNode(from, to);
        ((KnowledgeSource)Mockito.verify((Object)to)).setType(type);
        ((KnowledgeSource)Mockito.verify((Object)to)).setLocationURI(locationURI);
    }

    @Test
    public void testSynchronizeInputDataNode() {
        InputData from = (InputData)Mockito.mock(InputData.class);
        InputData to = (InputData)Mockito.mock(InputData.class);
        InformationItemPrimary variable = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        Mockito.when((Object)from.getVariable()).thenReturn((Object)variable);
        this.synchronizer.synchronizeInputDataNode(from, to);
        ((InputData)Mockito.verify((Object)to)).setVariable(variable);
    }

    @Test
    public void testSynchronizeDecisionServiceNode() {
        DecisionService from = (DecisionService)Mockito.mock(DecisionService.class);
        DecisionService to = (DecisionService)Mockito.mock(DecisionService.class);
        InformationItemPrimary variable = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        Mockito.when((Object)from.getVariable()).thenReturn((Object)variable);
        this.synchronizer.synchronizeDecisionServiceNode(from, to);
        ((DecisionService)Mockito.verify((Object)to)).setVariable(variable);
    }

    @Test
    public void testSynchronizeBusinessKnowledgeModelNode() {
        BusinessKnowledgeModel from = (BusinessKnowledgeModel)Mockito.mock(BusinessKnowledgeModel.class);
        BusinessKnowledgeModel to = (BusinessKnowledgeModel)Mockito.mock(BusinessKnowledgeModel.class);
        InformationItemPrimary variable = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        Mockito.when((Object)from.getVariable()).thenReturn((Object)variable);
        this.synchronizer.synchronizeBusinessKnowledgeModelNode(from, to);
        ((BusinessKnowledgeModel)Mockito.verify((Object)to)).setVariable(variable);
    }

    @Test
    public void testSynchronizeDecisionNodeNode() {
        Decision from = (Decision)Mockito.mock(Decision.class);
        Decision to = (Decision)Mockito.mock(Decision.class);
        Question question = (Question)Mockito.mock(Question.class);
        AllowedAnswers allowedAnswers = (AllowedAnswers)Mockito.mock(AllowedAnswers.class);
        Expression expression = (Expression)Mockito.mock(Expression.class);
        InformationItemPrimary variable = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        Mockito.when((Object)from.getQuestion()).thenReturn((Object)question);
        Mockito.when((Object)from.getAllowedAnswers()).thenReturn((Object)allowedAnswers);
        Mockito.when((Object)from.getExpression()).thenReturn((Object)expression);
        Mockito.when((Object)from.getVariable()).thenReturn((Object)variable);
        this.synchronizer.synchronizeDecisionNode(from, to);
        ((Decision)Mockito.verify((Object)to)).setQuestion(question);
        ((Decision)Mockito.verify((Object)to)).setAllowedAnswers(allowedAnswers);
        ((Decision)Mockito.verify((Object)to)).setExpression(expression);
        ((Decision)Mockito.verify((Object)to)).setVariable(variable);
    }

    @Test
    public void testUpdateText() {
        Decision from = (Decision)Mockito.mock(Decision.class);
        Node to = (Node)Mockito.mock(Node.class);
        Name name = (Name)Mockito.mock(Name.class);
        String nameValue = "the name";
        Mockito.when((Object)name.getValue()).thenReturn((Object)"the name");
        Mockito.when((Object)from.getName()).thenReturn((Object)name);
        this.synchronizer.updateText((DRGElement)from, to);
        ((NodeTextSetter)Mockito.verify((Object)this.nodeTextSetter)).setText("the name", to);
    }

    @Test
    public void testGetElementsWithContentId() {
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Node node3 = (Node)Mockito.mock(Node.class);
        DRGElement contentDefinition1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement contentDefinition3 = (DRGElement)Mockito.mock(DRGElement.class);
        String theId = "the id";
        String anotherId = "another id";
        List<Node> nodes = Arrays.asList(node1, node2, node3);
        Mockito.when((Object)this.dmnDiagramsSession.getAllNodes()).thenReturn(nodes);
        Mockito.when((Object)contentDefinition1.getContentDefinitionId()).thenReturn((Object)"the id");
        Mockito.when((Object)contentDefinition3.getContentDefinitionId()).thenReturn((Object)"another id");
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)contentDefinition1).when((Object)this.synchronizer)).getDRGElementFromContentDefinition(node1);
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)contentDefinition3).when((Object)this.synchronizer)).getDRGElementFromContentDefinition(node3);
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)true).when((Object)this.synchronizer)).definitionContainsDRGElement(node1);
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)false).when((Object)this.synchronizer)).definitionContainsDRGElement(node2);
        ((DMNElementsSynchronizer)Mockito.doReturn((Object)true).when((Object)this.synchronizer)).definitionContainsDRGElement(node3);
        List elements = this.synchronizer.getElementsWithContentId("the id");
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).definitionContainsDRGElement(node1);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).definitionContainsDRGElement(node2);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).definitionContainsDRGElement(node3);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).getDRGElementFromContentDefinition(node1);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).getDRGElementFromContentDefinition(node2);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).getDRGElementFromContentDefinition(node3);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertTrue((boolean)elements.contains(node1));
    }

    @Test
    public void testDefinitionContainsDRGElement() {
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        boolean containsDRGElement = this.synchronizer.definitionContainsDRGElement(node);
        Assert.assertTrue((boolean)containsDRGElement);
    }

    @Test
    public void testDefinitionContainsDRGElement_WhenDoesNotContains() {
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Object obj = Mockito.mock(Object.class);
        Mockito.when((Object)definition.getDefinition()).thenReturn(obj);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        boolean containsDRGElement = this.synchronizer.definitionContainsDRGElement(node);
        Assert.assertFalse((boolean)containsDRGElement);
    }

    @Test
    public void testDefinitionContainsDRGElement_WhenContentIsNotDefinition() {
        Node node = (Node)Mockito.mock(Node.class);
        Object obj = Mockito.mock(Definition.class);
        Mockito.when((Object)node.getContent()).thenReturn(obj);
        boolean containsDRGElement = this.synchronizer.definitionContainsDRGElement(node);
        Assert.assertFalse((boolean)containsDRGElement);
    }

    @Test
    public void testGetDRGElementFromContentDefinition() {
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        DRGElement actual = this.synchronizer.getDRGElementFromContentDefinition(node);
        Assert.assertEquals((Object)drgElement, (Object)actual);
    }

    @Test
    public void testGetNode() {
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Node node3 = (Node)Mockito.mock(Node.class);
        String id = "id";
        Mockito.when((Object)node1.getUUID()).thenReturn((Object)"id");
        Mockito.when((Object)node2.getUUID()).thenReturn((Object)"id2");
        Mockito.when((Object)node3.getUUID()).thenReturn((Object)"id3");
        Mockito.when((Object)this.graphUtils.getNodeStream()).thenReturn(Stream.of(node1, node2, node3));
        Optional node = this.synchronizer.getNode("id");
        Assert.assertTrue((boolean)node.isPresent());
        Assert.assertEquals((Object)node1, node.get());
    }

    @Test
    public void testSynchronizeFromNode() {
        Node node = (Node)Mockito.mock(Node.class);
        Optional<Node> optional = Optional.of(node);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        ((DMNElementsSynchronizer)Mockito.doNothing().when((Object)this.synchronizer)).synchronizeElementsFrom(drgElement);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        this.synchronizer.synchronizeFromNode(optional);
        ((DMNElementsSynchronizer)Mockito.verify((Object)this.synchronizer)).synchronizeElementsFrom(drgElement);
    }
}

