/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.marshaller.common.WrapperUtils;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.mockito.Mockito;

public class WrapperUtilsTest {
    @Test
    public void testGetDmnElementRefWithNamespace() {
        Decision drgElement = (Decision)Mockito.mock(Decision.class);
        ViewImpl view = new ViewImpl((Object)drgElement, null);
        Name drgElementName = (Name)Mockito.mock(Name.class);
        Name importName = (Name)Mockito.mock(Name.class);
        Id id = (Id)Mockito.mock(Id.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        List<Import> imports = Collections.singletonList(anImport);
        String includedModelName = "includedModel";
        String defaultNamespace = "://default";
        String namespaceName = "include1";
        String importNamespace = "://namespace";
        HashMap<String, String> nsContext = new HashMap<String, String>();
        Mockito.when((Object)importName.getValue()).thenReturn((Object)"includedModel");
        Mockito.when((Object)anImport.getName()).thenReturn((Object)importName);
        Mockito.when((Object)anImport.getNamespace()).thenReturn((Object)"://namespace");
        Mockito.when((Object)id.getValue()).thenReturn((Object)"0000-1111-2222");
        Mockito.when((Object)drgElementName.getValue()).thenReturn((Object)"includedModel.Decision");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)drgElementName);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        nsContext.put("include1", "://namespace");
        Mockito.when((Object)definitions.getImport()).thenReturn(imports);
        Mockito.when((Object)definitions.getNsContext()).thenReturn(nsContext);
        QName actual = WrapperUtils.getDmnElementRef((Definitions)definitions, (View)view, (String)"://default");
        Assert.assertEquals((Object)"://default", (Object)actual.getNamespaceURI());
        Assert.assertEquals((Object)"include1:0000-1111-2222", (Object)actual.getLocalPart());
        Assert.assertEquals((Object)"", (Object)actual.getPrefix());
    }

    @Test
    public void testGetDmnElementRefWithNamespaceWhenImportHasAnOddName() {
        Decision drgElement = (Decision)Mockito.mock(Decision.class);
        ViewImpl view = new ViewImpl((Object)drgElement, null);
        Name drgElementName = (Name)Mockito.mock(Name.class);
        Name importName = (Name)Mockito.mock(Name.class);
        Id id = (Id)Mockito.mock(Id.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        List<Import> imports = Collections.singletonList(anImport);
        String includedModelName = "d.i.v.i.";
        String defaultNamespace = "://default";
        String namespaceName = "include1";
        String importNamespace = "://namespace";
        HashMap<String, String> nsContext = new HashMap<String, String>();
        Mockito.when((Object)importName.getValue()).thenReturn((Object)"d.i.v.i.");
        Mockito.when((Object)anImport.getName()).thenReturn((Object)importName);
        Mockito.when((Object)anImport.getNamespace()).thenReturn((Object)"://namespace");
        Mockito.when((Object)id.getValue()).thenReturn((Object)"0000-1111-2222");
        Mockito.when((Object)drgElementName.getValue()).thenReturn((Object)"d.i.v.i..Decision");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)drgElementName);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        nsContext.put("include1", "://namespace");
        Mockito.when((Object)definitions.getImport()).thenReturn(imports);
        Mockito.when((Object)definitions.getNsContext()).thenReturn(nsContext);
        QName actual = WrapperUtils.getDmnElementRef((Definitions)definitions, (View)view, (String)"://default");
        Assert.assertEquals((Object)"://default", (Object)actual.getNamespaceURI());
        Assert.assertEquals((Object)"include1:0000-1111-2222", (Object)actual.getLocalPart());
        Assert.assertEquals((Object)"", (Object)actual.getPrefix());
    }

    @Test
    public void testGetDmnElementRefWithFakeNamespace() {
        Decision drgElement = (Decision)Mockito.mock(Decision.class);
        ViewImpl view = new ViewImpl((Object)drgElement, null);
        String defaultNamespace = "://default";
        Name drgElementName = (Name)Mockito.mock(Name.class);
        Id id = (Id)Mockito.mock(Id.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)id.getValue()).thenReturn((Object)"0000-1111-2222");
        Mockito.when((Object)drgElementName.getValue()).thenReturn((Object)"fakeNamespace.Decision");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)drgElementName);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getImport()).thenReturn(Collections.emptyList());
        QName actual = WrapperUtils.getDmnElementRef((Definitions)definitions, (View)view, (String)"://default");
        Assert.assertEquals((Object)"://default", (Object)actual.getNamespaceURI());
        Assert.assertEquals((Object)"0000-1111-2222", (Object)actual.getLocalPart());
        Assert.assertEquals((Object)"", (Object)actual.getPrefix());
    }

    @Test
    public void testGetDmnElementRefWithoutNamespace() {
        Decision drgElement = (Decision)Mockito.mock(Decision.class);
        ViewImpl view = new ViewImpl((Object)drgElement, null);
        String defaultNamespace = "://default";
        Name drgElementName = (Name)Mockito.mock(Name.class);
        Id id = (Id)Mockito.mock(Id.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)id.getValue()).thenReturn((Object)"0000-1111-2222");
        Mockito.when((Object)drgElementName.getValue()).thenReturn((Object)"Decision");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)drgElementName);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getImport()).thenReturn(Collections.emptyList());
        QName actual = WrapperUtils.getDmnElementRef((Definitions)definitions, (View)view, (String)"://default");
        Assert.assertEquals((Object)"://default", (Object)actual.getNamespaceURI());
        Assert.assertEquals((Object)"0000-1111-2222", (Object)actual.getLocalPart());
        Assert.assertEquals((Object)"", (Object)actual.getPrefix());
    }
}

