/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression;
import org.kie.workbench.common.dmn.client.marshaller.converters.LiteralExpressionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.OutputClauseLiteralExpressionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITLiteralExpression;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class OutputClauseLiteralExpressionPropertyConverterTest {
    private static final String TEXT = "text";
    private static final JSITLiteralExpression jsitLiteralExpression = (JSITLiteralExpression)Mockito.mock(JSITLiteralExpression.class);

    @BeforeClass
    public static void setupAttributesCast() {
        LiteralExpressionPropertyConverter.LITERAL_EXPRESSION_PROVIDER = new LiteralExpressionPropertyConverter.JSITLiteralExpressionFactory(){

            JSITLiteralExpression make() {
                return jsitLiteralExpression;
            }
        };
    }

    @AfterClass
    public static void restoreAttributesCast() {
        LiteralExpressionPropertyConverter.LITERAL_EXPRESSION_PROVIDER = new LiteralExpressionPropertyConverter.JSITLiteralExpressionFactory();
    }

    @Test
    public void testWBFromDMNWhenNull() {
        OutputClauseLiteralExpression wb = OutputClauseLiteralExpressionPropertyConverter.wbFromDMN(null);
        Assertions.assertThat((Object)wb).isNotNull();
    }

    @Test
    public void testWBFromDMNWhenNonNull() {
        Mockito.when((Object)jsitLiteralExpression.getText()).thenReturn((Object)TEXT);
        OutputClauseLiteralExpression wb = OutputClauseLiteralExpressionPropertyConverter.wbFromDMN((JSITLiteralExpression)jsitLiteralExpression);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((String)wb.getText().getValue()).isEqualTo(TEXT);
    }

    @Test
    public void testDMNFromWBWhenNull() {
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB(null);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenTextIsNull() {
        OutputClauseLiteralExpression wb = new OutputClauseLiteralExpression();
        wb.setText(null);
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB((OutputClauseLiteralExpression)wb);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenNonNullWithEmptyString() {
        OutputClauseLiteralExpression wb = new OutputClauseLiteralExpression();
        wb.getText().setValue("");
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB((OutputClauseLiteralExpression)wb);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenNonNullWithNonEmptyString() {
        OutputClauseLiteralExpression wb = new OutputClauseLiteralExpression();
        wb.getText().setValue(TEXT);
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB((OutputClauseLiteralExpression)wb);
        Assertions.assertThat((Object)dmn).isNotNull();
        ((JSITLiteralExpression)Mockito.verify((Object)jsitLiteralExpression)).setText(TEXT);
    }
}

