/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.marshaller.common.DMNDiagramElementsUtils;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsClientHelper;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.DMNUnmarshaller;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntriesFactory;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNUnmarshallerTest {
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private Metadata metadata;
    @Mock
    private JSITDefinitions jsitDefinitions;
    @Mock
    private DMNMarshallerImportsClientHelper dmnMarshallerImportsHelper;
    @Mock
    private NodeEntriesFactory modelToStunnerConverter;
    @Mock
    private DMNDiagramElementsUtils dmnDiagramElementsUtils;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    private DMNUnmarshaller dmnUnmarshaller;
    private List<JSITImport> imports;
    private Promises promises;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.dmnUnmarshaller = new DMNUnmarshaller(this.factoryManager, this.dmnMarshallerImportsHelper, this.promises, this.modelToStunnerConverter, this.dmnDiagramElementsUtils, this.dmnDiagramsSession);
        this.imports = new ArrayList<JSITImport>();
        this.imports.add((JSITImport)Mockito.mock(JSITImport.class));
        Mockito.when((Object)this.jsitDefinitions.getImport()).thenReturn(this.imports);
        Mockito.when((Object)this.dmnMarshallerImportsHelper.getImportDefinitionsAsync((Metadata)ArgumentMatchers.eq((Object)this.metadata), (List)ArgumentMatchers.eq(this.imports))).thenReturn((Object)this.promises.resolve(Collections.emptyMap()));
        Mockito.when((Object)this.dmnMarshallerImportsHelper.getPMMLDocumentsAsync((Metadata)ArgumentMatchers.eq((Object)this.metadata), (List)ArgumentMatchers.eq(this.imports))).thenReturn((Object)this.promises.resolve(Collections.emptyMap()));
    }

    @Test
    public void unmarshall() {
        this.dmnUnmarshaller.unmarshall(this.metadata, this.jsitDefinitions);
        ((DMNMarshallerImportsClientHelper)Mockito.verify((Object)this.dmnMarshallerImportsHelper, (VerificationMode)Mockito.times((int)1))).getImportDefinitionsAsync((Metadata)ArgumentMatchers.eq((Object)this.metadata), (List)ArgumentMatchers.eq(this.imports));
        ((DMNMarshallerImportsClientHelper)Mockito.verify((Object)this.dmnMarshallerImportsHelper, (VerificationMode)Mockito.times((int)1))).getPMMLDocumentsAsync((Metadata)ArgumentMatchers.eq((Object)this.metadata), (List)ArgumentMatchers.eq(this.imports));
    }
}

