/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.styling.BgColour;
import org.kie.workbench.common.dmn.api.property.styling.BorderColour;
import org.kie.workbench.common.dmn.api.property.styling.FontColour;
import org.kie.workbench.common.dmn.api.property.styling.FontSize;
import org.kie.workbench.common.dmn.api.property.styling.StylingSet;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.StunnerConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIColor;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIStyle;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNStyle;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class StunnerConverterTest {
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private DMNDiagramsSession diagramsSession;
    @Captor
    private ArgumentCaptor<BgColour> bgColourArgumentCaptor;
    @Captor
    private ArgumentCaptor<BorderColour> borderColourArgumentCaptor;
    @Captor
    private ArgumentCaptor<FontColour> fontColourArgumentCaptor;
    @Captor
    private ArgumentCaptor<FontSize> fontSizeArgumentCaptor;
    private StunnerConverter converter;

    @Before
    public void setUp() throws Exception {
        this.converter = (StunnerConverter)Mockito.spy((Object)new StunnerConverter(this.factoryManager, this.diagramsSession));
    }

    @Test
    public void testDecision() {
        StylingSet decisionStylingSet = (StylingSet)Mockito.mock(StylingSet.class);
        Decision decision = (Decision)Mockito.spy((Object)new Decision());
        Mockito.when((Object)decision.getStylingSet()).thenReturn((Object)decisionStylingSet);
        JSITDecision jsitDecision = (JSITDecision)Mockito.mock(JSITDecision.class);
        Mockito.when((Object)jsitDecision.getTYPE_NAME()).thenReturn((Object)"DMN12.TDecision");
        JSIStyle style = (JSIStyle)Mockito.mock(JSIStyle.class);
        JSIDMNShape shape = (JSIDMNShape)Mockito.mock(JSIDMNShape.class);
        JSIDMNStyle dmnStyleOfDrgShape = (JSIDMNStyle)Mockito.mock(JSIDMNStyle.class);
        Mockito.when((Object)shape.getStyle()).thenReturn((Object)style);
        ((StunnerConverter)Mockito.doReturn((Object)style).when((Object)this.converter)).getUnwrappedJSIStyle(style);
        ((StunnerConverter)Mockito.doReturn((Object)true).when((Object)this.converter)).isJSIDMNStyle(style);
        ((StunnerConverter)Mockito.doReturn((Object)dmnStyleOfDrgShape).when((Object)this.converter)).getJSIDmnStyle(style);
        NodeEntry nodeEntry = (NodeEntry)Mockito.mock(NodeEntry.class);
        Mockito.when((Object)nodeEntry.getDmnElement()).thenReturn((Object)jsitDecision);
        Mockito.when((Object)nodeEntry.getId()).thenReturn((Object)"_id");
        Mockito.when((Object)nodeEntry.getDmnShape()).thenReturn((Object)shape);
        Element graphElement = (Element)Mockito.mock(Element.class);
        Node graphNode = (Node)Mockito.mock(Node.class);
        View content = (View)Mockito.mock(View.class);
        Mockito.when((Object)this.factoryManager.newElement(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)graphElement);
        Mockito.when((Object)graphElement.asNode()).thenReturn((Object)graphNode);
        Mockito.when((Object)graphNode.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)decision);
        JSIColor randomColor = (JSIColor)Mockito.mock(JSIColor.class);
        Mockito.when((Object)randomColor.getRed()).thenReturn((Object)12);
        Mockito.when((Object)randomColor.getGreen()).thenReturn((Object)34);
        Mockito.when((Object)randomColor.getBlue()).thenReturn((Object)56);
        Mockito.when((Object)dmnStyleOfDrgShape.getFontColor()).thenReturn((Object)randomColor);
        Mockito.when((Object)dmnStyleOfDrgShape.getStrokeColor()).thenReturn((Object)randomColor);
        Mockito.when((Object)dmnStyleOfDrgShape.getFillColor()).thenReturn((Object)randomColor);
        Mockito.when((Object)dmnStyleOfDrgShape.getFontSize()).thenReturn((Object)11.0);
        this.converter.make(nodeEntry);
        ((StylingSet)Mockito.verify((Object)decisionStylingSet)).setFontSize((FontSize)this.fontSizeArgumentCaptor.capture());
        Assertions.assertThat((Double)((FontSize)this.fontSizeArgumentCaptor.getValue()).getValue()).isEqualTo(11.0);
        ((StylingSet)Mockito.verify((Object)decisionStylingSet)).setBorderColour((BorderColour)this.borderColourArgumentCaptor.capture());
        Assertions.assertThat((String)((BorderColour)this.borderColourArgumentCaptor.getValue()).getValue()).isEqualTo("#0c2238");
        ((StylingSet)Mockito.verify((Object)decisionStylingSet)).setBgColour((BgColour)this.bgColourArgumentCaptor.capture());
        Assertions.assertThat((String)((BgColour)this.bgColourArgumentCaptor.getValue()).getValue()).isEqualTo("#0c2238");
        ((StylingSet)Mockito.verify((Object)decisionStylingSet)).setFontColour((FontColour)this.fontColourArgumentCaptor.capture());
        Assertions.assertThat((String)((FontColour)this.fontColourArgumentCaptor.getValue()).getValue()).isEqualTo("#0c2238");
    }
}

