/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.view.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.DMNViewDefinition;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.Height;
import org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.Width;
import org.kie.workbench.common.dmn.api.property.styling.StylingSet;
import org.kie.workbench.common.dmn.client.shape.def.DMNSVGShapeDefImpl;
import org.kie.workbench.common.stunner.core.client.shape.TextWrapperStrategy;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.handler.FontHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.handler.SizeHandler;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNViewHandlersTest {
    @Mock
    private View<DMNViewDefinition> view;
    @Mock
    private DMNViewDefinition definition;
    @Mock
    private SVGShapeView shape;
    private Bounds bounds = Bounds.create((double)0.0, (double)0.0, (double)100.0, (double)100.0);
    private RectangleDimensionsSet dimensions = new GeneralRectangleDimensionsSet(new Width(Double.valueOf(50.0)), new Height(Double.valueOf(50.0)));

    @Before
    public void setup() {
        ((View)Mockito.doReturn((Object)this.definition).when(this.view)).getDefinition();
        ((View)Mockito.doReturn((Object)this.bounds).when(this.view)).getBounds();
        ((DMNViewDefinition)Mockito.doReturn((Object)this.dimensions).when((Object)this.definition)).getDimensionsSet();
        ((DMNViewDefinition)Mockito.doReturn((Object)new StylingSet()).when((Object)this.definition)).getStylingSet();
    }

    @Test
    public void testNewSizeHandler() {
        SizeHandler handler = new DMNSVGShapeDefImpl().newSizeHandler();
        handler.handle(this.view, (ShapeView)this.shape);
        ((SVGShapeView)Mockito.verify((Object)this.shape)).setMinWidth(Double.valueOf(ArgumentMatchers.eq((double)this.dimensions.getMinimumWidth())));
        ((SVGShapeView)Mockito.verify((Object)this.shape)).setMaxWidth(Double.valueOf(ArgumentMatchers.eq((double)this.dimensions.getMaximumWidth())));
        ((SVGShapeView)Mockito.verify((Object)this.shape)).setMinHeight(Double.valueOf(ArgumentMatchers.eq((double)this.dimensions.getMinimumHeight())));
        ((SVGShapeView)Mockito.verify((Object)this.shape)).setMaxHeight(Double.valueOf(ArgumentMatchers.eq((double)this.dimensions.getMaximumHeight())));
    }

    @Test
    public void testNewFontHandler() {
        FontHandler handler = new DMNSVGShapeDefImpl().newFontHandler();
        handler.handle((Object)this.definition, (ShapeView)this.shape);
        ((SVGShapeView)Mockito.verify((Object)this.shape)).setTextWrapper(TextWrapperStrategy.TRUNCATE);
    }
}

