/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNElementReference;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersList;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters.DecisionServiceParametersListWidget;
import org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters.parametergroup.ParameterGroup;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionServiceParametersListWidgetTest {
    @Mock
    private ClientTranslationService translationService;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private Elemental2DomUtil util;
    @Mock
    private HTMLDivElement container;
    @Mock
    private ParameterGroup groupEncapsulated;
    @Mock
    private ParameterGroup groupOutputs;
    @Mock
    private ParameterGroup groupInputs;
    private DecisionServiceParametersListWidget widget;

    @Before
    public void setup() {
        this.widget = (DecisionServiceParametersListWidget)Mockito.spy((Object)new DecisionServiceParametersListWidget(this.translationService, this.util, this.dmnDiagramsSession, this.groupEncapsulated, this.groupOutputs, this.groupInputs, this.container));
    }

    @Test
    public void testSetup() {
        String encapsulatedDecisions = "Encapsulated Decisions";
        String outputs = "Outputs";
        String inputs = "Inputs";
        Mockito.when((Object)this.translationService.getValue("DecisionServiceParameters.EncapsulatedDecisions")).thenReturn((Object)"Encapsulated Decisions");
        Mockito.when((Object)this.translationService.getValue("DecisionServiceParameters.Outputs")).thenReturn((Object)"Outputs");
        Mockito.when((Object)this.translationService.getValue("DecisionServiceParameters.Inputs")).thenReturn((Object)"Inputs");
        this.widget.setup();
        ((ParameterGroup)Mockito.verify((Object)this.groupEncapsulated)).setHeader("Encapsulated Decisions");
        ((ParameterGroup)Mockito.verify((Object)this.groupInputs)).setHeader("Inputs");
        ((ParameterGroup)Mockito.verify((Object)this.groupOutputs)).setHeader("Outputs");
    }

    @Test
    public void testSetValue() {
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).refresh();
        DecisionServiceParametersList value = (DecisionServiceParametersList)Mockito.mock(DecisionServiceParametersList.class);
        this.widget.setValue(value, false);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).refresh();
    }

    @Test
    public void testRefresh() {
        DecisionServiceParametersList value = (DecisionServiceParametersList)Mockito.mock(DecisionServiceParametersList.class);
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        String contentDefinitionId = "contentId";
        org.kie.workbench.common.stunner.core.graph.Node node = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Edge edge1 = (Edge)Mockito.mock(Edge.class);
        Child child1 = (Child)Mockito.mock(Child.class);
        org.kie.workbench.common.stunner.core.graph.Node targetNode1 = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Edge edge2 = (Edge)Mockito.mock(Edge.class);
        Child child2 = (Child)Mockito.mock(Child.class);
        org.kie.workbench.common.stunner.core.graph.Node targetNode2 = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Edge edge3 = (Edge)Mockito.mock(Edge.class);
        Child child3 = (Child)Mockito.mock(Child.class);
        org.kie.workbench.common.stunner.core.graph.Node targetNode3 = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Edge edgeNotChild = (Edge)Mockito.mock(Edge.class);
        Object notChild = Mockito.mock(Object.class);
        List<Edge> edges = Arrays.asList(edge1, edge2, edge3, edgeNotChild);
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement3 = (DRGElement)Mockito.mock(DRGElement.class);
        Optional<DRGElement> targetDrg1 = Optional.of(drgElement1);
        Optional<DRGElement> targetDrg2 = Optional.of(drgElement2);
        Optional<DRGElement> targetDrg3 = Optional.of(drgElement3);
        ArrayList sortedList = new ArrayList();
        Mockito.when((Object)decisionService.getContentDefinitionId()).thenReturn((Object)"contentId");
        Mockito.when((Object)value.getDecisionService()).thenReturn((Object)decisionService);
        Mockito.when((Object)edge1.getContent()).thenReturn((Object)child1);
        Mockito.when((Object)edge1.getTargetNode()).thenReturn((Object)targetNode1);
        Mockito.when((Object)edge2.getContent()).thenReturn((Object)child2);
        Mockito.when((Object)edge2.getTargetNode()).thenReturn((Object)targetNode2);
        Mockito.when((Object)edge3.getContent()).thenReturn((Object)child3);
        Mockito.when((Object)edge3.getTargetNode()).thenReturn((Object)targetNode3);
        Mockito.when((Object)edgeNotChild.getContent()).thenReturn(notChild);
        Mockito.when((Object)node.getOutEdges()).thenReturn(edges);
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).clear();
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).loadGroupsElements();
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).loadInputsParameters(ArgumentMatchers.anyList());
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).loadDecisionsFromNode((org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.any(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.any());
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).loadInputsFromNode((List)ArgumentMatchers.any(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.any());
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).loadInputsFromOthersDiagrams(ArgumentMatchers.anyList(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.any(org.kie.workbench.common.stunner.core.graph.Node.class));
        ((DecisionServiceParametersListWidget)Mockito.doReturn((Object)value).when((Object)this.widget)).getValue();
        ((DecisionServiceParametersListWidget)Mockito.doReturn((Object)node).when((Object)this.widget)).getNode("contentId");
        ((DecisionServiceParametersListWidget)Mockito.doReturn(targetDrg1).when((Object)this.widget)).getTargetDRGElement(edge1);
        ((DecisionServiceParametersListWidget)Mockito.doReturn(targetDrg2).when((Object)this.widget)).getTargetDRGElement(edge2);
        ((DecisionServiceParametersListWidget)Mockito.doReturn(targetDrg3).when((Object)this.widget)).getTargetDRGElement(edge3);
        ((DecisionServiceParametersListWidget)Mockito.doReturn(Optional.empty()).when((Object)this.widget)).getTargetDRGElement(edgeNotChild);
        ((DecisionServiceParametersListWidget)Mockito.doReturn(sortedList).when((Object)this.widget)).getSortedInputs(ArgumentMatchers.anyList());
        this.widget.refresh();
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadDecisionsFromNode(node, targetNode1);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadDecisionsFromNode(node, targetNode2);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadDecisionsFromNode(node, targetNode3);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromNode(ArgumentMatchers.anyList(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.eq((Object)targetNode1));
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromNode(ArgumentMatchers.anyList(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.eq((Object)targetNode2));
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromNode(ArgumentMatchers.anyList(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.eq((Object)targetNode3));
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromOthersDiagrams(ArgumentMatchers.anyList(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.eq((Object)targetNode1));
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromOthersDiagrams(ArgumentMatchers.anyList(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.eq((Object)targetNode2));
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromOthersDiagrams(ArgumentMatchers.anyList(), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.eq((Object)targetNode3));
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).getSortedInputs(ArgumentMatchers.anyList());
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsParameters(sortedList);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadGroupsElements();
    }

    @Test
    public void testGetSortedInputs() {
        DecisionServiceParametersList value = (DecisionServiceParametersList)Mockito.mock(DecisionServiceParametersList.class);
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        String newId1 = "newId1";
        String newId2 = "newId2";
        List<DMNElementReference> list = this.createListOfDMNElementReferenceWithIds("id1", "id2", "id3");
        List<InputData> unsortedInputs = Arrays.asList(this.createInputDataWithId("id2"), this.createInputDataWithId("id3"), this.createInputDataWithId("newId2"), this.createInputDataWithId("id1"), this.createInputDataWithId("newId1"));
        ((DecisionServiceParametersListWidget)Mockito.doReturn((Object)value).when((Object)this.widget)).getValue();
        Mockito.when((Object)value.getDecisionService()).thenReturn((Object)decisionService);
        Mockito.when((Object)decisionService.getInputData()).thenReturn(list);
        List sorted = this.widget.getSortedInputs(unsortedInputs);
        Assertions.assertThat((List)sorted).extracting(inputData -> inputData.getId().getValue()).containsExactly((Object[])new String[]{"id1", "id2", "id3", "newId1", "newId2"});
    }

    @Test
    public void testGetCurrentItems() {
        DecisionServiceParametersList value = (DecisionServiceParametersList)Mockito.mock(DecisionServiceParametersList.class);
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        List<DMNElementReference> list = this.createListOfDMNElementReferenceWithIds("id1", "id2", "id3");
        List<InputData> unsortedInputs = Arrays.asList(this.createInputDataWithId("id2"), this.createInputDataWithId("id3"), this.createInputDataWithId("id1"));
        ((DecisionServiceParametersListWidget)Mockito.doReturn((Object)value).when((Object)this.widget)).getValue();
        Mockito.when((Object)value.getDecisionService()).thenReturn((Object)decisionService);
        Mockito.when((Object)decisionService.getInputData()).thenReturn(list);
        List sorted = this.widget.getCurrentItems(unsortedInputs);
        Assertions.assertThat((List)sorted).extracting(inputData -> inputData.getId().getValue()).containsExactly((Object[])new String[]{"id1", "id2", "id3"});
    }

    @Test
    public void testGetNewItems() {
        DecisionServiceParametersList value = (DecisionServiceParametersList)Mockito.mock(DecisionServiceParametersList.class);
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        String newItem1 = "aaa";
        String newItem2 = "bbb";
        String newItem3 = "ccc";
        String newItem4 = "ddd";
        List<DMNElementReference> list = this.createListOfDMNElementReferenceWithIds("id1", "id2", "id3");
        List<InputData> currentItems = Arrays.asList(this.createInputDataWithId("id2"), this.createInputDataWithId("id3"), this.createInputDataWithId("id1"));
        List<InputData> inputs = Arrays.asList(this.createInputDataWithId("ccc"), this.createInputDataWithId("bbb"), this.createInputDataWithId("ddd"), this.createInputDataWithId("aaa"));
        ((DecisionServiceParametersListWidget)Mockito.doReturn((Object)value).when((Object)this.widget)).getValue();
        Mockito.when((Object)value.getDecisionService()).thenReturn((Object)decisionService);
        Mockito.when((Object)decisionService.getInputData()).thenReturn(list);
        List result = this.widget.getNewItems(inputs, currentItems);
        Assertions.assertThat((List)result).extracting(inputData -> inputData.getId().getValue()).containsExactly((Object[])new String[]{"aaa", "bbb", "ccc", "ddd"});
    }

    private InputData createInputDataWithId(String id) {
        InputData inputData = new InputData();
        inputData.getId().setValue(id);
        inputData.getName().setValue(id);
        return inputData;
    }

    private List<DMNElementReference> createListOfDMNElementReferenceWithIds(String ... ids) {
        ArrayList<DMNElementReference> list = new ArrayList<DMNElementReference>();
        for (String id : ids) {
            DMNElementReference reference = new DMNElementReference();
            reference.setHref("#" + id);
            list.add(reference);
        }
        return list;
    }

    @Test
    public void testLoadDecisionsFromNode_WhenIsOutputDecision() {
        org.kie.workbench.common.stunner.core.graph.Node node = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        org.kie.workbench.common.stunner.core.graph.Node targetNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        View targetContent = (View)Mockito.mock(View.class);
        View nodeContent = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeContent);
        Mockito.when((Object)targetNode.getContent()).thenReturn((Object)targetContent);
        ((DecisionServiceParametersListWidget)Mockito.doReturn((Object)true).when((Object)this.widget)).isOutputDecision(targetContent, nodeContent);
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).addDecisionNodeToGroup(this.groupOutputs, targetNode);
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).addDecisionNodeToGroup(this.groupEncapsulated, targetNode);
        this.widget.loadDecisionsFromNode(node, targetNode);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).isOutputDecision(targetContent, nodeContent);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).addDecisionNodeToGroup(this.groupOutputs, targetNode);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).addDecisionNodeToGroup(this.groupEncapsulated, targetNode);
    }

    @Test
    public void testLoadDecisionsFromNode_WhenIsEncapsulatedDecision() {
        org.kie.workbench.common.stunner.core.graph.Node node = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        org.kie.workbench.common.stunner.core.graph.Node targetNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        View targetContent = (View)Mockito.mock(View.class);
        View nodeContent = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeContent);
        Mockito.when((Object)targetNode.getContent()).thenReturn((Object)targetContent);
        ((DecisionServiceParametersListWidget)Mockito.doReturn((Object)false).when((Object)this.widget)).isOutputDecision(targetContent, nodeContent);
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).addDecisionNodeToGroup(this.groupOutputs, targetNode);
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).addDecisionNodeToGroup(this.groupEncapsulated, targetNode);
        this.widget.loadDecisionsFromNode(node, targetNode);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).isOutputDecision(targetContent, nodeContent);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).addDecisionNodeToGroup(this.groupOutputs, targetNode);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).addDecisionNodeToGroup(this.groupEncapsulated, targetNode);
    }

    @Test
    public void testLoadGroupElements() {
        HTMLElement inputElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement outputElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement encapsulatedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.groupInputs.getElement()).thenReturn((Object)inputElement);
        Mockito.when((Object)this.groupOutputs.getElement()).thenReturn((Object)outputElement);
        Mockito.when((Object)this.groupEncapsulated.getElement()).thenReturn((Object)encapsulatedElement);
        elemental2.dom.HTMLElement htmlInput = (elemental2.dom.HTMLElement)Mockito.mock(elemental2.dom.HTMLElement.class);
        elemental2.dom.HTMLElement htmlOutput = (elemental2.dom.HTMLElement)Mockito.mock(elemental2.dom.HTMLElement.class);
        elemental2.dom.HTMLElement htmlEncapsulated = (elemental2.dom.HTMLElement)Mockito.mock(elemental2.dom.HTMLElement.class);
        Mockito.when((Object)this.util.asHTMLElement(inputElement)).thenReturn((Object)htmlInput);
        Mockito.when((Object)this.util.asHTMLElement(outputElement)).thenReturn((Object)htmlOutput);
        Mockito.when((Object)this.util.asHTMLElement(encapsulatedElement)).thenReturn((Object)htmlEncapsulated);
        this.widget.loadGroupsElements();
        ((HTMLDivElement)Mockito.verify((Object)this.container)).appendChild((Node)htmlInput);
        ((HTMLDivElement)Mockito.verify((Object)this.container)).appendChild((Node)htmlOutput);
        ((HTMLDivElement)Mockito.verify((Object)this.container)).appendChild((Node)htmlEncapsulated);
    }

    @Test
    public void testLoadInputParameters() {
        String name1 = "name1";
        String type1 = "type1";
        String name2 = "name2";
        String type2 = "type2";
        String name3 = "name3";
        String type3 = "type3";
        InputData input1 = this.createInputData("name1", "type1");
        InputData input2 = this.createInputData("name2", "type2");
        InputData input3 = this.createInputData("name3", "type3");
        List<InputData> inputs = Arrays.asList(input1, input2, input3);
        this.widget.loadInputsParameters(inputs);
        ((ParameterGroup)Mockito.verify((Object)this.groupInputs)).addParameter("name1", "type1");
        ((ParameterGroup)Mockito.verify((Object)this.groupInputs)).addParameter("name2", "type2");
        ((ParameterGroup)Mockito.verify((Object)this.groupInputs)).addParameter("name3", "type3");
    }

    @Test
    public void testGetTargetDRGElement_WhenTargetIsDRGElement() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        org.kie.workbench.common.stunner.core.graph.Node targetNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        View targetNodeView = (View)Mockito.mock(View.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)edge.getTargetNode()).thenReturn((Object)targetNode);
        Mockito.when((Object)targetNode.getContent()).thenReturn((Object)targetNodeView);
        Mockito.when((Object)targetNodeView.getDefinition()).thenReturn((Object)drgElement);
        Optional actual = this.widget.getTargetDRGElement(edge);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)drgElement, actual.get());
    }

    @Test
    public void testGetTargetDRGElement_WhenTargetIsNotDRGElement() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        org.kie.workbench.common.stunner.core.graph.Node targetNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        View targetNodeView = (View)Mockito.mock(View.class);
        Object obj = Mockito.mock(Object.class);
        Mockito.when((Object)edge.getTargetNode()).thenReturn((Object)targetNode);
        Mockito.when((Object)targetNode.getContent()).thenReturn((Object)targetNodeView);
        Mockito.when((Object)targetNodeView.getDefinition()).thenReturn(obj);
        Optional actual = this.widget.getTargetDRGElement(edge);
        Assert.assertFalse((boolean)actual.isPresent());
    }

    @Test
    public void testAddDecisionNodeToGroup() {
        ParameterGroup group = (ParameterGroup)Mockito.mock(ParameterGroup.class);
        org.kie.workbench.common.stunner.core.graph.Node node = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        InformationItemPrimary variable = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        String decisionName = "decision name";
        String type = "type";
        QName typeRef = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)decision);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)decision.getVariable()).thenReturn((Object)variable);
        Mockito.when((Object)decision.getName()).thenReturn((Object)new Name("decision name"));
        Mockito.when((Object)typeRef.getLocalPart()).thenReturn((Object)"type");
        Mockito.when((Object)variable.getTypeRef()).thenReturn((Object)typeRef);
        this.widget.addDecisionNodeToGroup(group, node);
        ((ParameterGroup)Mockito.verify((Object)group)).addParameter("decision name", "type");
    }

    @Test
    public void testGetInputs() {
        org.kie.workbench.common.stunner.core.graph.Node targetNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Edge e1 = (Edge)Mockito.mock(Edge.class);
        Edge e2 = (Edge)Mockito.mock(Edge.class);
        Edge e3 = (Edge)Mockito.mock(Edge.class);
        List<Edge> inEdges = Arrays.asList(e1, e2, e3);
        Mockito.when((Object)targetNode.getInEdges()).thenReturn(inEdges);
        InputData input1 = this.createInputData("1", "type1");
        InputData input2 = this.createInputData("2", "type2");
        InputData input3 = this.createInputData("3", "type3");
        Optional<InputData> nodeInputData1 = Optional.of(input1);
        Optional<InputData> nodeInputData2 = Optional.of(input2);
        Optional<InputData> nodeInputData3 = Optional.of(input3);
        ((DecisionServiceParametersListWidget)Mockito.doReturn(nodeInputData1).when((Object)this.widget)).getSourceNodeInputData(e1);
        ((DecisionServiceParametersListWidget)Mockito.doReturn(nodeInputData2).when((Object)this.widget)).getSourceNodeInputData(e2);
        ((DecisionServiceParametersListWidget)Mockito.doReturn(nodeInputData3).when((Object)this.widget)).getSourceNodeInputData(e3);
        List inputData = this.widget.getInputs(targetNode);
        Assert.assertEquals((long)3L, (long)inputData.size());
        Assert.assertTrue((boolean)inputData.contains(input1));
        Assert.assertTrue((boolean)inputData.contains(input2));
        Assert.assertTrue((boolean)inputData.contains(input3));
    }

    @Test
    public void testGetSourceNodeInputData() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        org.kie.workbench.common.stunner.core.graph.Node sourceNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        View view = (View)Mockito.mock(View.class);
        InputData inputData = (InputData)Mockito.mock(InputData.class);
        Mockito.when((Object)view.getDefinition()).thenReturn((Object)inputData);
        Mockito.when((Object)sourceNode.getContent()).thenReturn((Object)view);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Optional actualInputData = this.widget.getSourceNodeInputData(edge);
        Assert.assertTrue((boolean)actualInputData.isPresent());
        Assert.assertEquals((Object)inputData, actualInputData.get());
    }

    @Test
    public void testGetSourceNodeInputData_WhenContentIsNotView() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        org.kie.workbench.common.stunner.core.graph.Node sourceNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Object obj = Mockito.mock(Object.class);
        Mockito.when((Object)sourceNode.getContent()).thenReturn(obj);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Optional actualInputData = this.widget.getSourceNodeInputData(edge);
        Assert.assertFalse((boolean)actualInputData.isPresent());
    }

    @Test
    public void testGetSourceNodeInputData_WhenDoesNotHaveInputData() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        org.kie.workbench.common.stunner.core.graph.Node sourceNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        View view = (View)Mockito.mock(View.class);
        DRGElement anotherDrgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)view.getDefinition()).thenReturn((Object)anotherDrgElement);
        Mockito.when((Object)sourceNode.getContent()).thenReturn((Object)view);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Optional actualInputData = this.widget.getSourceNodeInputData(edge);
        Assert.assertFalse((boolean)actualInputData.isPresent());
    }

    @Test
    public void testGetSourceNodeInputData_WhenDefinitionIsNotDRGElement() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        org.kie.workbench.common.stunner.core.graph.Node sourceNode = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        View view = (View)Mockito.mock(View.class);
        Object anotherObject = Mockito.mock(Object.class);
        Mockito.when((Object)view.getDefinition()).thenReturn(anotherObject);
        Mockito.when((Object)sourceNode.getContent()).thenReturn((Object)view);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Optional actualInputData = this.widget.getSourceNodeInputData(edge);
        Assert.assertFalse((boolean)actualInputData.isPresent());
    }

    @Test
    public void testIsOutputDecision_WhenIsOutput() {
        this.testOutputDecision(99.0, 100.0, true);
    }

    @Test
    public void testIsOutputDecision_WhenIsNotOutput() {
        this.testOutputDecision(101.0, 100.0, false);
    }

    @Test
    public void testGetElementWithContentId() {
        String id1 = "id1";
        String id2 = "id2";
        org.kie.workbench.common.stunner.core.graph.Node node1 = this.createNodeWithContentDefinitionId("id1");
        org.kie.workbench.common.stunner.core.graph.Node node2 = this.createNodeWithContentDefinitionId("id2");
        Stream stream = Arrays.asList(node1, node2).stream();
        org.kie.workbench.common.stunner.core.graph.Node actual = this.widget.getElementWithContentId("id1", stream);
        Assert.assertEquals((Object)node1, (Object)actual);
    }

    @Test
    public void testLoadInputsFromOtherDiagrams() {
        String id = "theId";
        org.kie.workbench.common.stunner.core.graph.Node node1 = this.createNodeWithContentDefinitionId("theId");
        org.kie.workbench.common.stunner.core.graph.Node node2 = this.createNodeWithContentDefinitionId("theId");
        org.kie.workbench.common.stunner.core.graph.Node node3 = this.createNodeWithContentDefinitionId("theId");
        List<org.kie.workbench.common.stunner.core.graph.Node> list = Arrays.asList(node1, node2, node3);
        ArrayList inputs = new ArrayList();
        org.kie.workbench.common.stunner.core.graph.Node targetNode = this.createNodeWithContentDefinitionId("theId");
        ((DecisionServiceParametersListWidget)Mockito.doNothing().when((Object)this.widget)).loadInputsFromNode((List)ArgumentMatchers.eq(inputs), (org.kie.workbench.common.stunner.core.graph.Node)ArgumentMatchers.any(org.kie.workbench.common.stunner.core.graph.Node.class));
        Mockito.when((Object)this.dmnDiagramsSession.getNodesFromAllDiagramsWithContentId("theId")).thenReturn(list);
        this.widget.loadInputsFromOthersDiagrams(inputs, targetNode);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromNode(inputs, node1);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromNode(inputs, node2);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).loadInputsFromNode(inputs, node3);
    }

    private org.kie.workbench.common.stunner.core.graph.Node createNodeWithContentDefinitionId(String contentDefinitionId) {
        org.kie.workbench.common.stunner.core.graph.Node node = (org.kie.workbench.common.stunner.core.graph.Node)Mockito.mock(org.kie.workbench.common.stunner.core.graph.Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)drgElement.getContentDefinitionId()).thenReturn((Object)contentDefinitionId);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        return node;
    }

    @Test(expected=IllegalStateException.class)
    public void testGetElementWithContentId_WhenContentIsNotFound() {
        String id1 = "id1";
        String id2 = "id2";
        org.kie.workbench.common.stunner.core.graph.Node node1 = this.createNodeWithContentDefinitionId("id1");
        org.kie.workbench.common.stunner.core.graph.Node node2 = this.createNodeWithContentDefinitionId("id2");
        Stream stream = Arrays.asList(node1, node2).stream();
        this.widget.getElementWithContentId("not found id", stream);
    }

    private void testOutputDecision(double y, double dividerLineValue, boolean expected) {
        View childView = (View)Mockito.mock(View.class);
        View decisionServiceView = (View)Mockito.mock(View.class);
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        Bound upperLeft = (Bound)Mockito.mock(Bound.class);
        Mockito.when((Object)upperLeft.getY()).thenReturn((Object)y);
        Mockito.when((Object)bounds.getUpperLeft()).thenReturn((Object)upperLeft);
        Mockito.when((Object)childView.getBounds()).thenReturn((Object)bounds);
        DecisionService definition = (DecisionService)Mockito.mock(DecisionService.class);
        DecisionServiceDividerLineY dividerLineY = (DecisionServiceDividerLineY)Mockito.mock(DecisionServiceDividerLineY.class);
        Mockito.when((Object)dividerLineY.getValue()).thenReturn((Object)dividerLineValue);
        Mockito.when((Object)definition.getDividerLineY()).thenReturn((Object)dividerLineY);
        Mockito.when((Object)((DecisionService)decisionServiceView.getDefinition())).thenReturn((Object)definition);
        boolean actual = this.widget.isOutputDecision(childView, decisionServiceView);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private InputData createInputData(String name, String type) {
        InputData input = (InputData)Mockito.mock(InputData.class);
        InformationItemPrimary variable = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        QName typeRef = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)input.getVariable()).thenReturn((Object)variable);
        Mockito.when((Object)input.getName()).thenReturn((Object)new Name(name));
        Mockito.when((Object)typeRef.getLocalPart()).thenReturn((Object)type);
        Mockito.when((Object)variable.getTypeRef()).thenReturn((Object)typeRef);
        return input;
    }
}

